/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.xml;

import com.jcabi.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

final class DomParser {
    private static final Pattern PATTERN = Pattern.compile("(?:<\\?xml.*\\?>\\s*)?(?:<!DOCTYPE.*>)?(?:<!--.*-->)?\\<[_\\:a-zA-Z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd](?:[\u00b7\\.\\-0-9\u0300-\u036f\u203f-\u2040])*.*(?:[_\\:a-zA-Z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd](?:[\u00b7\\.\\-0-9\u0300-\u036f\u203f-\u2040])*|/)\\>");
    private final transient String xml;
    private final transient DocumentBuilderFactory factory;

    DomParser(DocumentBuilderFactory fct, String txt) {
        if (txt.isEmpty()) {
            throw new IllegalArgumentException("Empty document, not an XML");
        }
        if (!PATTERN.matcher(txt.replaceAll("\\s", "")).matches()) {
            throw new IllegalArgumentException(String.format("Doesn't look like XML: '%s'", txt));
        }
        this.xml = txt;
        this.factory = fct;
    }

    public Document document() {
        Document doc;
        try {
            doc = this.factory.newDocumentBuilder().parse(new ByteArrayInputStream(this.xml.getBytes("UTF-8")));
        }
        catch (IOException | ParserConfigurationException ex) {
            throw new IllegalStateException(ex);
        }
        catch (SAXException ex) {
            throw new IllegalArgumentException(Logger.format((String)"Invalid XML: \"%s\"", (Object[])new Object[]{this.xml}), ex);
        }
        return doc;
    }

    public String toString() {
        return "DomParser(xml=" + this.xml + ", factory=" + this.factory + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DomParser)) {
            return false;
        }
        DomParser other = (DomParser)o;
        String this$xml = this.xml;
        String other$xml = other.xml;
        return !(this$xml == null ? other$xml != null : !this$xml.equals(other$xml));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $xml = this.xml;
        result = result * 59 + ($xml == null ? 43 : $xml.hashCode());
        return result;
    }
}

