/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

final class DomParser {
    private final transient byte[] xml;
    private final transient DocumentBuilderFactory factory;

    DomParser(DocumentBuilderFactory fct, String txt) {
        this(fct, txt.getBytes(StandardCharsets.UTF_8));
    }

    DomParser(DocumentBuilderFactory fct, byte[] bytes) {
        this.xml = bytes;
        this.factory = fct;
    }

    public Document document() {
        Document doc;
        try {
            doc = this.factory.newDocumentBuilder().parse(new ByteArrayInputStream(this.xml));
        }
        catch (IOException | ParserConfigurationException ex) {
            throw new IllegalStateException(ex);
        }
        catch (SAXException ex) {
            throw new IllegalArgumentException("Can't parse, most probably the XML is invalid", ex);
        }
        return doc;
    }

    public String toString() {
        return "DomParser(xml=" + Arrays.toString(this.xml) + ", factory=" + this.factory + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DomParser)) {
            return false;
        }
        DomParser other = (DomParser)o;
        return Arrays.equals(this.xml, other.xml);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.xml);
        return result;
    }
}

