/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.xml;

import com.jcabi.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

final class DomParser {
    private final transient byte[] xml;
    private final transient DocumentBuilderFactory factory;

    DomParser(DocumentBuilderFactory fct, String txt) {
        this(fct, txt.getBytes(StandardCharsets.UTF_8));
    }

    DomParser(DocumentBuilderFactory fct, byte[] bytes) {
        this.xml = bytes;
        this.factory = fct;
    }

    public Document document() {
        Document doc;
        DocumentBuilder builder;
        try {
            builder = this.factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalArgumentException(String.format("Failed to create document builder by %s", this.factory.getClass().getName()), ex);
        }
        try {
            doc = builder.parse(new ByteArrayInputStream(this.xml));
        }
        catch (IOException | SAXException ex) {
            throw new IllegalArgumentException(String.format("Can't parse by %s, most probably the XML is invalid", builder.getClass().getName()), ex);
        }
        if (Logger.isDebugEnabled((Object)this)) {
            Logger.debug((Object)this, (String)"%s parsed XML", (Object[])new Object[]{builder.getClass().getName()});
        }
        return doc;
    }

    public String toString() {
        return "DomParser(xml=" + Arrays.toString(this.xml) + ", factory=" + this.factory + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DomParser)) {
            return false;
        }
        DomParser other = (DomParser)o;
        return Arrays.equals(this.xml, other.xml);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.xml);
        return result;
    }
}

