/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.xml;

import com.jcabi.xml.XML;
import java.io.StringReader;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import org.w3c.dom.Node;

public final class SaxonDocument
implements XML {
    private static final Processor SAXON = new Processor(false);
    private static final DocumentBuilder DOC_BUILDER = SAXON.newDocumentBuilder();
    private static final XPathCompiler XPATH_COMPILER = SAXON.newXPathCompiler();
    private static final String UNSUPPORTED = "The %s method is not supported yet. You can use XMLDocument instead or if you need to use Saxon specific features, you can open an issue at https://github.com/jcabi/jcabi-xml";
    private final XdmNode xdm;

    public SaxonDocument(String text) {
        this(SaxonDocument.node(text));
    }

    public SaxonDocument(XdmNode xml) {
        this.xdm = xml;
    }

    @Override
    public List<String> xpath(String query) {
        try {
            XPathSelector selector = XPATH_COMPILER.compile(query).load();
            selector.setContextItem((XdmItem)this.xdm);
            return selector.evaluate().stream().map(XdmItem::getStringValue).collect(Collectors.toList());
        }
        catch (SaxonApiException exception) {
            throw new IllegalArgumentException(String.format("Can't evaluate the '%s' XPath query with Saxon API", query), exception);
        }
    }

    @Override
    public List<XML> nodes(String query) {
        throw new UnsupportedOperationException(String.format(UNSUPPORTED, "nodes"));
    }

    @Override
    public XML registerNs(String prefix, Object uri) {
        throw new UnsupportedOperationException(String.format(UNSUPPORTED, "registerNs"));
    }

    @Override
    public XML merge(NamespaceContext context) {
        throw new UnsupportedOperationException(String.format(UNSUPPORTED, "merge"));
    }

    @Override
    public Node node() {
        throw new UnsupportedOperationException(String.format(UNSUPPORTED, "node"));
    }

    private static XdmNode node(String text) {
        try {
            return DOC_BUILDER.build((Source)new StreamSource(new StringReader(text)));
        }
        catch (SaxonApiException exception) {
            throw new IllegalArgumentException(String.format("SaxonDocument can't parse XML: %s", text), exception);
        }
    }
}

