/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.xml;

import com.jcabi.xml.Sources;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import lombok.Generated;

public final class ClasspathSources
implements Sources {
    private static final String PATTERN = "%s%s";
    private final transient String prefix;

    public ClasspathSources() {
        this("");
    }

    public ClasspathSources(Class<?> type) {
        this(String.format("/%s/", type.getPackage().getName().replace(".", "/")));
    }

    public ClasspathSources(String pfx) {
        this.prefix = pfx;
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        InputStream stream = this.getClass().getResourceAsStream(String.format(PATTERN, this.prefix, href));
        if (stream == null && (stream = this.getClass().getResourceAsStream(String.format(PATTERN, base, href))) == null) {
            throw new TransformerException(String.format("Resource \"%s\" not found in classpath with prefix \"%s\" and base \"%s\"", href, this.prefix, base));
        }
        return new StreamSource(stream);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClasspathSources)) {
            return false;
        }
        ClasspathSources other = (ClasspathSources)o;
        String this$prefix = this.prefix;
        String other$prefix = other.prefix;
        return !(this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $prefix = this.prefix;
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        return result;
    }
}

