/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.xml;

import com.jcabi.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import lombok.Generated;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

final class DomParser {
    private final transient DocumentBuilderFactory factory;
    private final DocSource source;

    DomParser(DocumentBuilderFactory fct, String txt) {
        this(fct, new BytesSource(txt));
    }

    DomParser(DocumentBuilderFactory fct, byte[] bytes) {
        this(fct, new BytesSource(bytes));
    }

    DomParser(DocumentBuilderFactory fct, File file) {
        this(fct, new FileSource(file));
    }

    private DomParser(DocumentBuilderFactory factory, DocSource source) {
        this.factory = factory;
        this.source = source;
    }

    public Document document() {
        Document doc;
        DocumentBuilder builder;
        try {
            builder = this.factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalArgumentException(String.format("Failed to create document builder by %s", this.factory.getClass().getName()), ex);
        }
        long start = System.nanoTime();
        try {
            doc = this.source.apply(builder);
        }
        catch (IOException | SAXException ex) {
            throw new IllegalArgumentException(String.format("Can't parse by %s, most probably the XML is invalid", builder.getClass().getName()), ex);
        }
        if (Logger.isTraceEnabled((Object)this)) {
            Logger.trace((Object)this, (String)"%s parsed %d bytes of XML in %[nano]s", (Object[])new Object[]{builder.getClass().getName(), this.source.length(), System.nanoTime() - start});
        }
        return doc;
    }

    @Generated
    public String toString() {
        return "DomParser(factory=" + this.factory + ", source=" + this.source + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DomParser)) {
            return false;
        }
        DomParser other = (DomParser)o;
        DocSource this$source = this.source;
        DocSource other$source = other.source;
        return !(this$source == null ? other$source != null : !this$source.equals(other$source));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DocSource $source = this.source;
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        return result;
    }

    private static class BytesSource
    implements DocSource {
        private final byte[] xml;

        BytesSource(String xml) {
            this(xml.getBytes(StandardCharsets.UTF_8));
        }

        BytesSource(byte[] xml) {
            this.xml = xml;
        }

        @Override
        public Document apply(DocumentBuilder builder) throws IOException, SAXException {
            return builder.parse(new ByteArrayInputStream(this.xml));
        }

        @Override
        public long length() {
            return this.xml.length;
        }
    }

    private static interface DocSource {
        public Document apply(DocumentBuilder var1) throws IOException, SAXException;

        public long length();
    }

    private static class FileSource
    implements DocSource {
        private final File file;

        FileSource(File file) {
            this.file = file;
        }

        @Override
        public Document apply(DocumentBuilder builder) throws IOException, SAXException {
            return builder.parse(this.file);
        }

        @Override
        public long length() {
            return this.file.length();
        }
    }
}

