/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.xml;

import com.jcabi.log.Logger;
import com.jcabi.xml.ClasspathResolver;
import com.jcabi.xml.XML;
import com.jcabi.xml.XMLDocument;
import java.io.IOException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import lombok.Generated;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class StrictXML
implements XML {
    private final transient XML origin;

    public StrictXML(XML xml) {
        this(xml, new ClasspathResolver());
    }

    public StrictXML(XML xml, LSResourceResolver resolver) {
        this(xml, StrictXML.newValidator(resolver));
    }

    public StrictXML(XML xml, Validator val) {
        this(xml, StrictXML.validate(xml, val));
    }

    public StrictXML(XML xml, XML schema) {
        this(xml, StrictXML.check(xml, schema));
    }

    private StrictXML(XML xml, Collection<SAXParseException> errors) {
        if (!errors.isEmpty()) {
            Logger.warn(StrictXML.class, (String)"%d XML validation error(s):\n  %s\n%s", (Object[])new Object[]{errors.size(), StrictXML.join(StrictXML.print(errors), "\n  "), xml});
            throw new IllegalArgumentException(String.format("%d error(s) in XML document: %s", errors.size(), StrictXML.join(StrictXML.print(errors), ";")));
        }
        this.origin = xml;
    }

    public String toString() {
        return this.origin.toString();
    }

    @Override
    public List<String> xpath(String query) {
        return this.origin.xpath(query);
    }

    @Override
    public List<XML> nodes(String query) {
        return this.origin.nodes(query);
    }

    @Override
    public XML registerNs(String prefix, Object uri) {
        return this.origin.registerNs(prefix, uri);
    }

    @Override
    public XML merge(NamespaceContext context) {
        return this.origin.merge(context);
    }

    @Override
    @Deprecated
    public Node node() {
        return this.origin.deepCopy();
    }

    @Override
    public Node inner() {
        return this.origin.inner();
    }

    @Override
    public Node deepCopy() {
        return this.origin.deepCopy();
    }

    @Override
    public Collection<SAXParseException> validate() {
        return this.origin.validate();
    }

    @Override
    public Collection<SAXParseException> validate(XML xsd) {
        return this.origin.validate(xsd);
    }

    private static Collection<SAXParseException> check(XML xml, XML xsd) {
        return xml.validate(xsd);
    }

    private static Iterable<String> print(Collection<SAXParseException> errors) {
        ArrayList<String> lines = new ArrayList<String>(errors.size());
        for (SAXParseException error : errors) {
            lines.add(StrictXML.asMessage(error));
        }
        return lines;
    }

    private static String asMessage(SAXParseException violation) {
        StringBuilder msg = new StringBuilder(100);
        if (violation.getLineNumber() >= 0) {
            msg.append('#').append(violation.getLineNumber());
            if (violation.getColumnNumber() >= 0) {
                msg.append(':').append(violation.getColumnNumber());
            }
            msg.append(' ');
        }
        msg.append(violation.getLocalizedMessage());
        if (violation.getException() != null) {
            msg.append(" (").append(violation.getException().getClass().getSimpleName()).append(')');
        }
        return msg.toString();
    }

    private static String join(Iterable<?> iterable, String sep) {
        Iterator<?> iterator = iterable.iterator();
        Object first = iterator.next();
        StringBuilder buf = new StringBuilder(256);
        if (first != null) {
            buf.append(first);
        }
        while (iterator.hasNext()) {
            buf.append(sep);
            Object obj = iterator.next();
            if (obj == null) continue;
            buf.append(obj);
        }
        return buf.toString();
    }

    private static Collection<SAXParseException> validate(XML xml, Validator validator) {
        CopyOnWriteArrayList<SAXParseException> errors = new CopyOnWriteArrayList<SAXParseException>();
        int max = 3;
        try {
            validator.setErrorHandler(new XMLDocument.ValidationHandler(errors));
            DOMSource dom = new DOMSource(xml.inner());
            for (int retry = 1; retry <= 3; ++retry) {
                try {
                    validator.validate(dom);
                    break;
                }
                catch (SocketException ex) {
                    Logger.error(StrictXML.class, (String)"Try #%d of %d failed: %s: %s", (Object[])new Object[]{retry, 3, ex.getClass().getName(), ex.getMessage()});
                    if (retry != 3) continue;
                    throw new IllegalStateException(ex);
                }
            }
        }
        catch (IOException | SAXException ex) {
            throw new IllegalStateException(ex);
        }
        return errors;
    }

    private static Validator newValidator(LSResourceResolver resolver) {
        try {
            Validator validator = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema().newValidator();
            validator.setResourceResolver(resolver);
            return validator;
        }
        catch (SAXException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StrictXML)) {
            return false;
        }
        StrictXML other = (StrictXML)o;
        XML this$origin = this.origin;
        XML other$origin = other.origin;
        return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        XML $origin = this.origin;
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        return result;
    }
}

