/*
 * Decompiled with CFR 0.152.
 */
package com.jcohy.oss;

import com.jcohy.oss.OssFile;
import com.jcohy.oss.ali.AliOssTemplate;
import com.jcohy.oss.dsl.AliOssExtension;
import com.jcohy.oss.dsl.Upload;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssUploadTask
extends DefaultTask {
    private final Logger log = LoggerFactory.getLogger(OssUploadTask.class);
    private final AliOssExtension extension;
    private final Upload upload;
    private final Project project;

    @Inject
    public OssUploadTask(AliOssExtension extension) {
        this.extension = extension;
        this.upload = extension.getUpload();
        this.project = extension.getProject();
    }

    @TaskAction
    public void upload() {
        Map<String, File> uploadFiles = this.getUploadFiles();
        AliOssTemplate aliOssTemplate = new AliOssTemplate(this.extension);
        List<OssFile> ossFiles = aliOssTemplate.putUploadFile(uploadFiles);
        ossFiles.forEach(ossFile -> this.log.info(ossFile.getName() + "\uff1a\u6587\u4ef6\u4e0a\u4f20\u6210\u529f!!!\u4e0b\u8f7d\u5730\u5740\uff1a" + ossFile.getLink()));
    }

    public Map<String, File> getUploadFiles() {
        String prefix = this.upload.getPrefix();
        Set localFiles = this.project.getLayout().getProjectDirectory().dir(this.upload.getSource()).getAsFileTree().getFiles().stream().filter(file -> !this.contains(file.getPath())).collect(Collectors.toSet());
        Map<String, File> uploadFiles = !this.upload.isRecursion() ? localFiles.stream().collect(Collectors.toMap(key -> this.getUploadFileName(key.getName()), Function.identity())) : localFiles.stream().collect(Collectors.toMap(key -> prefix + "/" + this.getUploadFilePath(key.getPath()), Function.identity()));
        return uploadFiles;
    }

    private String getUploadFilePath(String localFilePath) {
        localFilePath = localFilePath.replace("\\", "/");
        String source = this.upload.getSource();
        int index = localFilePath.indexOf(source);
        return this.upload.isIgnoreSourceDir() ? localFilePath.substring(index + source.length() + 1) : localFilePath.substring(index);
    }

    private String getUploadFileName(String localFileName) {
        String source = this.upload.getSource();
        String prefix = this.upload.getPrefix();
        return this.upload.isIgnoreSourceDir() ? prefix + "/" + localFileName : prefix + "/" + source + "/" + localFileName;
    }

    public boolean contains(String filePath) {
        filePath = filePath.replace("\\", "/");
        for (String e : this.extension.getUpload().getExclusions()) {
            if (!filePath.contains(e)) continue;
            return true;
        }
        return false;
    }
}

