/*
 * Decompiled with CFR 0.152.
 */
package com.jcohy.oss.ali;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.DefaultCredentialProvider;
import com.aliyun.oss.common.utils.StringUtils;
import com.aliyun.oss.model.CreateBucketRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.jcohy.oss.OssFile;
import com.jcohy.oss.dsl.AliOssExtension;
import com.jcohy.oss.dsl.BucketScope;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class AliOssTemplate {
    private final OSSClient client;
    private final AliOssExtension extension;
    private final String bucket;

    public AliOssTemplate(AliOssExtension extension) {
        this.extension = extension;
        this.client = this.createClient(extension);
        this.bucket = extension.getBucket();
    }

    private OSSClient createClient(AliOssExtension extension) {
        ClientConfiguration conf = new ClientConfiguration();
        conf.setMaxConnections(1024);
        conf.setConnectionRequestTimeout(1000);
        DefaultCredentialProvider credentialsProvider = new DefaultCredentialProvider(extension.getAccessKey(), extension.getSecretKey());
        OSSClient ossClient = new OSSClient(extension.getEndpoint(), (CredentialsProvider)credentialsProvider, conf);
        ossClient.setBucketAcl(extension.getBucket(), BucketScope.getAccessControl(extension.getScope()));
        return ossClient;
    }

    public OssFile putFile(String key, File file) {
        return this.putFile(this.bucket, key, file);
    }

    public OssFile putFile(String bucket, String key, File file) {
        return this.put(bucket, file, key, true);
    }

    public List<OssFile> putUploadFile(Map<String, File> uploadFiles) {
        ArrayList<OssFile> list = new ArrayList<OssFile>();
        uploadFiles.forEach((key, value) -> list.add(this.putFile((String)key, (File)value)));
        return list;
    }

    public OssFile put(String bucketName, File file, String key, boolean cover) {
        key = this.formatKey(key);
        this.createBucket(bucketName);
        if (cover) {
            this.client.putObject(bucketName, key, file);
        } else {
            PutObjectResult response = this.client.putObject(bucketName, key, file);
            int retryCount = 4;
            for (int retry = 0; StringUtils.isNullOrEmpty((String)response.getETag()) && retry < retryCount; ++retry) {
                response = this.client.putObject(bucketName, key, file);
            }
        }
        OssFile ossFile = new OssFile();
        ossFile.setOriginalName(key);
        ossFile.setName(key);
        ossFile.setDomain(this.getOssHost(bucketName));
        ossFile.setLink(this.fileLink(bucketName, key));
        return ossFile;
    }

    public void createBucket(String bucket) {
        if (!this.bucketExists(bucket)) {
            CreateBucketRequest request = new CreateBucketRequest(this.bucket);
            request.setCannedACL(BucketScope.getAccessControl(this.extension.getScope()));
            this.client.createBucket(request);
        }
    }

    public boolean bucketExists(String bucket) {
        return this.client.doesBucketExist(this.extension.getBucket());
    }

    public String fileLink(String key) {
        return this.getOssHost().concat("/").concat(key);
    }

    public String fileLink(String bucket, String key) {
        return this.getOssHost(bucket).concat("/").concat(key);
    }

    public String getOssHost() {
        return this.getOssHost(this.extension.getBucket());
    }

    public String getOssHost(String bucketName) {
        String prefix = this.extension.getEndpoint().contains("https://") ? "https://" : "http://";
        return prefix + bucketName + "." + this.extension.getEndpoint().replaceFirst(prefix, "");
    }

    public String formatKey(String key) {
        if (StringUtils.isNullOrEmpty((String)key)) {
            return "";
        }
        if (key.startsWith("\\") || key.startsWith("/")) {
            key = key.substring(1);
        }
        Pattern pattern = Pattern.compile("[\\\\|/]{2,}");
        return pattern.matcher(key).replaceAll("/");
    }
}

