/*
 * Decompiled with CFR 0.152.
 */
package com.jcohy.convention.conventions;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import org.asciidoctor.gradle.jvm.AbstractAsciidoctorTask;
import org.asciidoctor.gradle.jvm.AsciidoctorJExtension;
import org.asciidoctor.gradle.jvm.AsciidoctorJPlugin;
import org.asciidoctor.gradle.jvm.AsciidoctorTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.Sync;
import org.springframework.util.StringUtils;

public class AsciidoctorConventions {
    private static final String ASCIIDOCTORJ_VERSION = "2.4.3";
    private static final String EXTENSIONS_CONFIGURATION_NAME = "asciidoctorExtensions";

    void apply(Project project) {
        project.getPlugins().withType(AsciidoctorJPlugin.class, asciidoctorPlugin -> {
            this.configureDocumentationDependenciesRepository(project);
            this.makeAllWarningsFatal(project);
            this.upgradeAsciidoctorJVersion(project);
            this.createAsciidoctorExtensionsConfiguration(project);
            this.createAsciidoctorPdfTask(project);
            project.getTasks().withType(AbstractAsciidoctorTask.class, asciidoctorTask -> this.configureAsciidoctorTask(project, (AbstractAsciidoctorTask)asciidoctorTask));
        });
    }

    private void configureAsciidoctorTask(Project project, AbstractAsciidoctorTask asciidoctorTask) {
        asciidoctorTask.configurations(new Object[]{EXTENSIONS_CONFIGURATION_NAME});
        this.configureCommonAttributes(project, asciidoctorTask);
        this.configureOptions(asciidoctorTask);
        asciidoctorTask.baseDirFollowsSourceDir();
        this.createSyncDocumentationSourceTask(project, asciidoctorTask);
        if (asciidoctorTask instanceof AsciidoctorTask) {
            boolean pdf = asciidoctorTask.getName().toLowerCase().contains("pdf");
            if (!pdf) {
                this.replaceLogo(project, asciidoctorTask);
            }
            String backend = !pdf ? "spring-html" : "spring-pdf";
            ((AsciidoctorTask)asciidoctorTask).outputOptions(outputOptions -> outputOptions.backends(new String[]{backend}));
        }
    }

    private void replaceLogo(Project project, AbstractAsciidoctorTask asciidoctorTask) {
        asciidoctorTask.doLast(replaceIcon -> {
            String language = asciidoctorTask.getLanguages().contains("zh-cn") ? "/zh-cn" : "";
            project.delete(new Object[]{project.getBuildDir() + "/docs/asciidoc" + language + "/img/banner-logo.svg"});
            try {
                Files.copy(AsciidoctorConventions.class.getResourceAsStream("/data/images/banner-logo.svg"), Paths.get(project.getBuildDir() + "/docs/asciidoc" + language + "/img/banner-logo.svg", new String[0]), new CopyOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    private void createAsciidoctorPdfTask(Project project) {
        project.getTasks().register("asciidoctorPdf", AsciidoctorTask.class, asciidoctorPdf -> {
            asciidoctorPdf.sources(new String[]{"index.singleadoc"});
            this.configureAsciidoctorPdfTask(project, (AsciidoctorTask)asciidoctorPdf);
        });
    }

    private void configureAsciidoctorPdfTask(Project project, AsciidoctorTask asciidoctorPdf) {
        try {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("pdf-fontsdir", AsciidoctorConventions.class.getResource("/data/fonts").toURI());
            attributes.put("pdf-stylesdir", AsciidoctorConventions.class.getResource("/data/themes").toURI());
            attributes.put("pdf-style", "Chinese");
            asciidoctorPdf.attributes(attributes);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private void configureDocumentationDependenciesRepository(Project project) {
        project.getRepositories().maven(mavenRepo -> {
            mavenRepo.setUrl(URI.create("https://repo.spring.io/release"));
            mavenRepo.mavenContent(mavenContent -> {
                mavenContent.includeGroup("io.spring.asciidoctor");
                mavenContent.includeGroup("io.spring.asciidoctor.backends");
                mavenContent.includeGroup("io.spring.docresources");
            });
        });
    }

    private void makeAllWarningsFatal(Project project) {
        ((AsciidoctorJExtension)project.getExtensions().getByType(AsciidoctorJExtension.class)).fatalWarnings(new Object[]{".*"});
    }

    private void createAsciidoctorExtensionsConfiguration(Project project) {
        project.getConfigurations().create(EXTENSIONS_CONFIGURATION_NAME, configuration -> {
            project.getConfigurations().matching(candidate -> "dependencyManagement".equals(candidate.getName())).all(xva$0 -> configuration.extendsFrom(new Configuration[]{xva$0}));
            configuration.getDependencies().add((Object)project.getDependencies().create((Object)"io.spring.asciidoctor.backends:spring-asciidoctor-backends:0.0.2"));
            configuration.getDependencies().add((Object)project.getDependencies().create((Object)"org.asciidoctor:asciidoctorj-pdf:1.5.3"));
        });
    }

    private void upgradeAsciidoctorJVersion(Project project) {
        ((AsciidoctorJExtension)project.getExtensions().getByType(AsciidoctorJExtension.class)).setVersion((Object)ASCIIDOCTORJ_VERSION);
    }

    private void configureOptions(AbstractAsciidoctorTask asciidoctorTask) {
        asciidoctorTask.options(Collections.singletonMap("doctype", "book"));
    }

    private void configureCommonAttributes(Project project, AbstractAsciidoctorTask asciidoctorTask) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("idprefix", "");
        attributes.put("idseparator", "-");
        attributes.put("toc", "left");
        attributes.put("toclevels", 4);
        attributes.put("tabsize", 4);
        attributes.put("numbered", "");
        attributes.put("source-indent", 0);
        attributes.put("sectanchors", "");
        attributes.put("icons", "font");
        attributes.put("hide-uri-scheme", "font");
        attributes.put("allow-uri-read", true);
        attributes.put("revnumber", null);
        attributes.put("docinfo", "shared,private");
        attributes.put("doc-url", "https://docs.jcohy.com");
        attributes.put("resource-url", "https://resources.jcohy.com");
        attributes.put("software-url", "https://software.jcohy.com");
        attributes.put("study-url", "https://study.jcohy.com");
        attributes.put("project-url", "https://project.jcohy.com");
        asciidoctorTask.attributes(attributes);
    }

    private Sync createSyncDocumentationSourceTask(Project project, AbstractAsciidoctorTask asciidoctorTask) {
        Sync syncDocumentationSource = (Sync)project.getTasks().create("syncDocumentationSourceFor" + StringUtils.capitalize((String)asciidoctorTask.getName()), Sync.class);
        File syncedSource = new File(project.getBuildDir(), "docs/src/" + asciidoctorTask.getName());
        syncDocumentationSource.setDestinationDir(syncedSource);
        syncDocumentationSource.from(new Object[]{"src/docs"});
        syncDocumentationSource.from((Object)"src/main/java", spec -> spec.into((Object)"main/java"));
        syncDocumentationSource.from((Object)"src/main/groovy", spec -> spec.into((Object)"main/groovy"));
        syncDocumentationSource.from((Object)"src/main/kotlin", spec -> spec.into((Object)"main/kotlin"));
        syncDocumentationSource.from((Object)"src/test/java", spec -> spec.into((Object)"test/java"));
        syncDocumentationSource.from((Object)"src/test/groovy", spec -> spec.into((Object)"test/groovy"));
        syncDocumentationSource.from((Object)"src/test/kotlin", spec -> spec.into((Object)"test/kotlin"));
        asciidoctorTask.dependsOn(new Object[]{syncDocumentationSource});
        asciidoctorTask.getInputs().dir((Object)syncedSource).withPathSensitivity(PathSensitivity.RELATIVE).withPropertyName("synced source");
        asciidoctorTask.setSourceDir((Object)project.relativePath((Object)new File(syncedSource, "asciidoc/")));
        return syncDocumentationSource;
    }
}

