/*
 * Decompiled with CFR 0.152.
 */
package com.jcohy.convention.conventions;

import com.jcohy.convention.constant.BomCoordinates;
import com.jcohy.convention.conventions.ExtractResources;
import com.jcohy.convention.optional.OptionalDependenciesPlugin;
import com.jcohy.convention.testing.TestFailuresPlugin;
import com.jcohy.convention.toolchain.ToolchainPlugin;
import io.spring.gradle.dependencymanagement.DependencyManagementPlugin;
import io.spring.gradle.dependencymanagement.dsl.DependencyManagementExtension;
import io.spring.javaformat.gradle.FormatTask;
import io.spring.javaformat.gradle.SpringJavaFormatPlugin;
import java.net.URI;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.quality.CheckstyleExtension;
import org.gradle.api.plugins.quality.CheckstylePlugin;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.api.tasks.testing.Test;
import org.gradle.external.javadoc.JavadocMemberLevel;
import org.gradle.jvm.tasks.Jar;
import org.gradle.testretry.TestRetryPlugin;
import org.gradle.testretry.TestRetryTaskExtension;

class JavaConventions {
    JavaConventions() {
    }

    void apply(Project project) {
        project.getPlugins().withType(JavaBasePlugin.class, java -> {
            project.getPlugins().apply(TestFailuresPlugin.class);
            this.configureSpringJavaFormat(project);
            project.setProperty("sourceCompatibility", (Object)"1.8");
            this.configureMavenRepository(project);
            this.configureJavaCompileConventions(project);
            this.configureJavadocConventions(project);
            this.configureTestConventions(project);
            this.configureJarManifestConventions(project);
            this.configureDependencyManagement(project);
            this.configureToolchain(project);
        });
    }

    private void configureMavenRepository(Project project) {
        project.getRepositories().maven(mavenRepo -> {
            mavenRepo.setUrl(URI.create("http://192.168.11.230:8081/repository/releases/"));
            mavenRepo.setName("xw-release");
        });
        project.getRepositories().maven(mavenRepo -> {
            mavenRepo.setUrl(URI.create("http://192.168.11.230:8081/repository/snapshot"));
            mavenRepo.setName("xw-snapshot");
        });
        project.getRepositories().maven(mavenRepo -> {
            mavenRepo.setUrl(URI.create("https://maven.aliyun.com/repository/central"));
            mavenRepo.setName("ali");
        });
        project.getRepositories().maven(mavenRepo -> {
            mavenRepo.setUrl(URI.create("https://repo.spring.io/artifactory/release/"));
            mavenRepo.setName("spring");
        });
    }

    private void configureToolchain(Project project) {
        project.getPlugins().apply(ToolchainPlugin.class);
    }

    private void configureDependencyManagement(Project project) {
        ConfigurationContainer configurations = project.getConfigurations();
        Configuration dependencyManagement = (Configuration)configurations.create("dependencyManagement", configuration -> {
            configuration.setVisible(false);
            configuration.setCanBeConsumed(false);
            configuration.setCanBeResolved(false);
        });
        project.getPlugins().apply(DependencyManagementPlugin.class);
        DependencyManagementExtension dependencyManagementExtension = (DependencyManagementExtension)project.getExtensions().getByType(DependencyManagementExtension.class);
        dependencyManagementExtension.imports(importsHandler -> {
            importsHandler.mavenBom(BomCoordinates.SPRING_BOM_COORDINATES);
            importsHandler.mavenBom("com.alibaba.cloud:aliyun-spring-boot-dependencies:1.0.0");
            importsHandler.mavenBom("com.alibaba.cloud:spring-cloud-alibaba-dependencies:2.2.2.RELEASE");
        });
        configurations.matching(configuration -> configuration.getName().endsWith("Classpath") || "annotationProcessor".equals(configuration.getName())).all(configuration -> configuration.extendsFrom(new Configuration[]{dependencyManagement}));
        project.getPlugins().withType(OptionalDependenciesPlugin.class, optionalDependencies -> configurations.getByName("optional").extendsFrom(new Configuration[]{dependencyManagement}));
    }

    private void configureJarManifestConventions(Project project) {
        ExtractResources extractLegalResources = (ExtractResources)project.getTasks().create("extractLegalResources", ExtractResources.class);
        extractLegalResources.getDestinationDirectory().set(project.getLayout().getBuildDirectory().dir("legal"));
        extractLegalResources.setResourcesNames(Arrays.asList("LICENSE.txt", "NOTICE.txt", "README.txt"));
        extractLegalResources.property("version", project.getVersion().toString());
        extractLegalResources.property("copyright", DateTimeFormatter.ofPattern("yyyy").format(LocalDateTime.now()));
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        Set sourceJarTaskNames = sourceSets.stream().map(SourceSet::getSourcesJarTaskName).collect(Collectors.toSet());
        Set javadocJarTaskNames = sourceSets.stream().map(SourceSet::getJavadocJarTaskName).collect(Collectors.toSet());
        project.getTasks().withType(Jar.class, jar -> project.afterEvaluate(evaluated -> {
            jar.metaInf(metaInf -> metaInf.from(new Object[]{extractLegalResources}));
            jar.manifest(manifest -> {
                TreeMap<String, Object> attributes = new TreeMap<String, Object>();
                attributes.put("Automatic-Module-Name", project.getName().replace("-", "."));
                attributes.put("Build-Jdk-Spec", project.property("sourceCompatibility"));
                attributes.put("Built-By", "Jcohy");
                attributes.put("Implementation-Title", this.determineImplementationTitle(project, sourceJarTaskNames, javadocJarTaskNames, (Jar)jar));
                attributes.put("Implementation-Version", project.getVersion());
                manifest.attributes(attributes);
            });
        }));
    }

    private String determineImplementationTitle(Project project, Set<String> sourceJarTaskNames, Set<String> javadocJarTaskNames, Jar jar) {
        if (sourceJarTaskNames.contains(jar.getName())) {
            return "Source for " + project.getName();
        }
        if (javadocJarTaskNames.contains(jar.getName())) {
            return "Javadoc for " + project.getName();
        }
        return project.getDescription();
    }

    private void configureTestConventions(Project project) {
        project.getTasks().withType(Test.class, test -> {
            test.useJUnitPlatform();
            test.setMaxHeapSize("1024M");
        });
        project.getPlugins().withType(JavaPlugin.class, javaPlugin -> {
            project.getDependencies().add("testRuntimeOnly", (Object)"org.junit.platform:junit-platform-launcher");
            project.getDependencies().add("testRuntimeOnly", (Object)"org.junit.jupiter:junit-jupiter");
            project.getDependencies().add("testRuntimeOnly", (Object)"org.assertj:assertj-core");
            project.getDependencies().add("testImplementation", (Object)"org.springframework.boot:spring-boot-starter-test");
        });
        project.getPlugins().apply(TestRetryPlugin.class);
        project.getTasks().withType(Test.class, test -> project.getPlugins().withType(TestRetryPlugin.class, testRetryPlugin -> {
            TestRetryTaskExtension testRetry = (TestRetryTaskExtension)test.getExtensions().getByType(TestRetryTaskExtension.class);
            testRetry.getFailOnPassedAfterRetry().set((Object)true);
            testRetry.getMaxRetries().set((Object)(this.isCi() ? 3 : 0));
        }));
    }

    private boolean isCi() {
        return Boolean.parseBoolean(System.getenv("CI"));
    }

    private void configureJavadocConventions(Project project) {
        project.getTasks().withType(Javadoc.class, javadoc -> {
            javadoc.setDescription("Generates project-level javadoc for use in -javadoc jar");
            javadoc.options(option -> {
                option.encoding("UTF-8");
                option.source("1.8");
                option.setMemberLevel(JavadocMemberLevel.PROTECTED);
                option.header(project.getName());
            });
        });
    }

    private void configureJavaCompileConventions(Project project) {
        project.getTasks().withType(JavaCompile.class, compile -> {
            compile.getOptions().setEncoding("UTF-8");
            compile.setSourceCompatibility("1.8");
            compile.setTargetCompatibility("1.8");
            List args = compile.getOptions().getCompilerArgs();
            if (!args.contains("-parameters")) {
                args.add("-parameters");
            }
            if (this.buildingWithJava8(project)) {
                args.addAll(Arrays.asList("-Werror", "-Xlint:unchecked", "-Xlint:deprecation", "-Xlint:rawtypes", "-Xlint:varargs"));
            }
        });
    }

    private boolean buildingWithJava8(Project project) {
        return !project.hasProperty("toolchainVersion") && JavaVersion.current() == JavaVersion.VERSION_1_8;
    }

    private void configureSpringJavaFormat(Project project) {
        project.getPlugins().apply(SpringJavaFormatPlugin.class);
        project.getTasks().withType(FormatTask.class, formatTask -> formatTask.setEncoding("UTF-8"));
        project.getPlugins().apply(CheckstylePlugin.class);
        CheckstyleExtension checkstyle = (CheckstyleExtension)project.getExtensions().getByType(CheckstyleExtension.class);
        checkstyle.setToolVersion("8.44");
        checkstyle.getConfigDirectory().set(project.getRootProject().file((Object)"src/checkstyle"));
        DependencySet checkstyleDependencies = project.getConfigurations().getByName("checkstyle").getDependencies();
        checkstyleDependencies.add((Object)project.getDependencies().create((Object)BomCoordinates.JCOHY_CHECKSTYLE));
    }
}

