/*
 * Decompiled with CFR 0.152.
 */
package com.jcohy.convention.deployed;

import com.jcohy.convention.version.ReleaseStatus;
import com.jcohy.convention.version.Repository;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaPlatformPlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.plugins.MavenPublishPlugin;
import org.gradle.api.tasks.bundling.Jar;

public class DeployedPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        PluginContainer plugins = project.getPlugins();
        plugins.apply(MavenPublishPlugin.class);
        PublishingExtension publishing = (PublishingExtension)project.getExtensions().getByType(PublishingExtension.class);
        MavenPublication mavenPublication = (MavenPublication)publishing.getPublications().create("maven", MavenPublication.class);
        publishing.getRepositories().maven(mavenRepository -> {
            Repository repository = Repository.of(ReleaseStatus.ofProject(project));
            mavenRepository.setUrl((Object)repository.getUrl());
            mavenRepository.setName(repository.getName());
            mavenRepository.credentials(passwordCredentials -> {
                passwordCredentials.setUsername("xw-developer");
                passwordCredentials.setPassword("developer");
            });
        });
        project.afterEvaluate(evaluated -> project.getPlugins().withType(JavaPlugin.class).all(javaPlugin -> {
            if (((Jar)project.getTasks().getByName("jar")).isEnabled()) {
                project.getComponents().matching(component -> component.getName().equals("java")).all(javaComponent -> mavenPublication.from(javaComponent));
            }
        }));
        project.getPlugins().withType(JavaPlatformPlugin.class).all(javaPlugin -> project.getComponents().matching(component -> component.getName().equals("javaPlatform")).all(javaComponent -> mavenPublication.from(javaComponent)));
    }
}

