/*
 * Decompiled with CFR 0.152.
 */
package com.jcohy.convention.testing;

import com.jcohy.convention.testing.TestResultsOverview;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.TestDescriptor;
import org.gradle.api.tasks.testing.TestListener;
import org.gradle.api.tasks.testing.TestResult;

public class TestFailuresPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        Provider testResultsOverview = project.getGradle().getSharedServices().registerIfAbsent("testResultsOverview", TestResultsOverview.class, spec -> {});
        project.getTasks().withType(Test.class, test -> test.addTestListener((TestListener)new FailureRecordingTestListener((Provider<TestResultsOverview>)testResultsOverview, (Test)test)));
    }

    private final class FailureRecordingTestListener
    implements TestListener {
        private final List<TestDescriptor> failures = new ArrayList<TestDescriptor>();
        private final Provider<TestResultsOverview> testResultsOverview;
        private final Test test;

        private FailureRecordingTestListener(Provider<TestResultsOverview> testResultOverview, Test test) {
            this.testResultsOverview = testResultOverview;
            this.test = test;
        }

        public void beforeSuite(TestDescriptor suite) {
        }

        public void afterSuite(TestDescriptor suite, TestResult result) {
            if (!this.failures.isEmpty()) {
                ((TestResultsOverview)this.testResultsOverview.get()).addFailures(this.test, this.failures);
            }
        }

        public void beforeTest(TestDescriptor testDescriptor) {
        }

        public void afterTest(TestDescriptor testDescriptor, TestResult result) {
            if (result.getFailedTestCount() > 0L) {
                this.failures.add(testDescriptor);
            }
        }
    }
}

