/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ForwardedTCPIPDaemon;
import com.jcraft.jsch.IO;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SocketFactory;
import java.net.Socket;
import java.util.Vector;

public class ChannelForwardedTCPIP
extends Channel {
    static Vector pool = new Vector();
    private static final int LOCAL_WINDOW_SIZE_MAX = 131072;
    private static final int LOCAL_MAXIMUM_PACKET_SIZE = 16384;
    SocketFactory factory = null;
    String target;
    int lport;
    int rport;

    ChannelForwardedTCPIP() {
        this.setLocalWindowSizeMax(131072);
        this.setLocalWindowSize(131072);
        this.setLocalPacketSize(16384);
        this.io = new IO();
    }

    void init() {
        try {
            if (this.lport == -1) {
                Class<?> clazz = Class.forName(this.target);
                ForwardedTCPIPDaemon forwardedTCPIPDaemon = (ForwardedTCPIPDaemon)clazz.newInstance();
                forwardedTCPIPDaemon.setChannel(this);
                Object[] objectArray = ChannelForwardedTCPIP.getPort(this.session, this.rport);
                forwardedTCPIPDaemon.setArg((Object[])objectArray[3]);
                this.connected = true;
                new Thread(forwardedTCPIPDaemon).start();
                return;
            }
            Socket socket = this.factory == null ? new Socket(this.target, this.lport) : this.factory.createSocket(this.target, this.lport);
            socket.setTcpNoDelay(true);
            this.io.setInputStream(socket.getInputStream());
            this.io.setOutputStream(socket.getOutputStream());
            this.connected = true;
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    public void run() {
        this.thread = Thread.currentThread();
        Buffer buffer = new Buffer(this.rmpsize);
        Packet packet = new Packet(buffer);
        int n = 0;
        try {
            while (this.thread != null && this.io != null && this.io.in != null) {
                n = this.io.in.read(buffer.buffer, 14, buffer.buffer.length - 14 - 32 - 20);
                if (n <= 0) {
                    this.eof();
                } else {
                    packet.reset();
                    if (!this.close) {
                        buffer.putByte((byte)94);
                        buffer.putInt(this.recipient);
                        buffer.putInt(n);
                        buffer.skip(n);
                        this.session.write(packet, this, n);
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getData(Buffer buffer) {
        this.setRecipient(buffer.getInt());
        this.setRemoteWindowSize(buffer.getInt());
        this.setRemotePacketSize(buffer.getInt());
        int n = buffer.getInt();
        Vector vector = pool;
        synchronized (vector) {
            int n2 = 0;
            while (n2 < pool.size()) {
                Object[] objectArray = (Object[])pool.elementAt(n2);
                if (objectArray[0] == this.session && (Integer)objectArray[1] == n) {
                    this.rport = n;
                    this.target = (String)objectArray[2];
                    this.lport = objectArray[3] == null || objectArray[3] instanceof Object[] ? -1 : (Integer)objectArray[3];
                    if (objectArray.length < 5) break;
                    this.factory = (SocketFactory)objectArray[4];
                    break;
                }
                ++n2;
            }
            if (this.target == null) {
                System.err.println("??");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Object[] getPort(Session session, int n) {
        Vector vector = pool;
        synchronized (vector) {
            int n2 = 0;
            while (n2 < pool.size()) {
                Object[] objectArray = (Object[])pool.elementAt(n2);
                if (objectArray[0] == session && (Integer)objectArray[1] == n) {
                    return objectArray;
                }
                ++n2;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] getPortForwarding(Session session) {
        Vector<String> vector = new Vector<String>();
        Vector vector2 = pool;
        synchronized (vector2) {
            int n = 0;
            while (n < pool.size()) {
                Object[] objectArray = (Object[])pool.elementAt(n);
                if (objectArray[0] == session) {
                    if (objectArray[3] == null) {
                        vector.addElement(objectArray[1] + ":" + objectArray[2] + ":");
                    } else {
                        vector.addElement(objectArray[1] + ":" + objectArray[2] + ":" + objectArray[3]);
                    }
                }
                ++n;
            }
        }
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addPort(Session session, int n, String string, int n2, SocketFactory socketFactory) throws JSchException {
        Vector vector = pool;
        synchronized (vector) {
            if (ChannelForwardedTCPIP.getPort(session, n) != null) {
                throw new JSchException("PortForwardingR: remote port " + n + " is already registered.");
            }
            Object[] objectArray = new Object[]{session, new Integer(n), string, new Integer(n2), socketFactory};
            pool.addElement(objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addPort(Session session, int n, String string, Object[] objectArray) throws JSchException {
        Vector vector = pool;
        synchronized (vector) {
            if (ChannelForwardedTCPIP.getPort(session, n) != null) {
                throw new JSchException("PortForwardingR: remote port " + n + " is already registered.");
            }
            Object[] objectArray2 = new Object[]{session, new Integer(n), string, objectArray};
            pool.addElement(objectArray2);
        }
    }

    static void delPort(ChannelForwardedTCPIP channelForwardedTCPIP) {
        ChannelForwardedTCPIP.delPort(channelForwardedTCPIP.session, channelForwardedTCPIP.rport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void delPort(Session session, int n) {
        Object[] objectArray;
        Vector vector = pool;
        synchronized (vector) {
            objectArray = null;
            int n2 = 0;
            while (n2 < pool.size()) {
                Object[] objectArray2 = (Object[])pool.elementAt(n2);
                if (objectArray2[0] == session && (Integer)objectArray2[1] == n) {
                    objectArray = objectArray2;
                    break;
                }
                ++n2;
            }
            if (objectArray == null) {
                return;
            }
            pool.removeElement(objectArray);
        }
        objectArray = new Buffer(100);
        Packet packet = new Packet((Buffer)objectArray);
        try {
            packet.reset();
            objectArray.putByte((byte)80);
            objectArray.putString("cancel-tcpip-forward".getBytes());
            objectArray.putByte((byte)0);
            objectArray.putString("0.0.0.0".getBytes());
            objectArray.putInt(n);
            session.write(packet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void delPort(Session session) {
        int n;
        int[] nArray = null;
        int n2 = 0;
        Vector vector = pool;
        synchronized (vector) {
            nArray = new int[pool.size()];
            n = 0;
            while (n < pool.size()) {
                Object[] objectArray = (Object[])pool.elementAt(n);
                if (objectArray[0] == session) {
                    nArray[n2++] = (Integer)objectArray[1];
                }
                ++n;
            }
        }
        n = 0;
        while (n < n2) {
            ChannelForwardedTCPIP.delPort(session, nArray[n]);
            ++n;
        }
    }

    public int getRemotePort() {
        return this.rport;
    }

    void setSocketFactory(SocketFactory socketFactory) {
        this.factory = socketFactory;
    }
}

