/*
 * Decompiled with CFR 0.152.
 */
package com.jd.easyflow.flow.el;

import com.jd.easyflow.flow.el.ElEvaluator;
import com.jd.easyflow.flow.el.ElRootMap;
import com.jd.easyflow.flow.engine.FlowContext;
import com.jd.easyflow.flow.model.NodeContext;
import com.jd.easyflow.flow.util.JsonUtil;
import com.jd.easyflow.flow.util.SpelHelper;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpelEvaluator
implements ElEvaluator {
    private static final Logger logger = LoggerFactory.getLogger(SpelEvaluator.class);
    public static final int ROOT_TYPE_HASH_MAP = 0;
    public static final int ROOT_TYPE_ROOT_MAP = 1;
    private int rootType = 1;
    private boolean cache = true;

    @Override
    public <T> T evalWithDefaultContext(String exp, Object root, boolean cache) {
        try {
            return SpelHelper.evalWithDefaultContext(exp, root, cache);
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("Eval spel exception, exp:" + exp + "," + e.getMessage());
            }
            throw e;
        }
    }

    @Override
    public <T> T eval(String exp, NodeContext nodeContext, FlowContext flowContext, Map<String, Object> data) {
        if (flowContext.isLogOn() && logger.isInfoEnabled()) {
            logger.info("EVAL SPEL:" + exp);
        }
        Object root = null;
        switch (this.rootType) {
            case 0: {
                root = this.buildHashMapRoot(nodeContext, flowContext, data);
                break;
            }
            case 1: {
                root = this.buildRootMapRoot(nodeContext, flowContext, data);
            }
        }
        T result = null;
        try {
            result = SpelHelper.evalWithDefaultContext(exp, root, this.cache);
        }
        catch (Exception e) {
            if (flowContext.isLogOn() && logger.isErrorEnabled()) {
                logger.error("EVAL SPEL EXCEPTION, EXP:" + exp + "," + e.getMessage());
            }
            throw e;
        }
        if (flowContext.isLogOn() && logger.isInfoEnabled()) {
            try {
                logger.info("SPEL RESULT:" + JsonUtil.toJsonString(result));
            }
            catch (Throwable t) {
                logger.info("spel result to json string exception:" + t.getMessage());
            }
        }
        return result;
    }

    private Object buildHashMapRoot(NodeContext nodeContext, FlowContext flowContext, Map<String, Object> data) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        if (nodeContext != null) {
            root.put("nodeContext", nodeContext);
            root.put("actionResult", nodeContext.getActionResult());
            if (nodeContext.getNodeContext() != null) {
                root.put("nodeBizContext", nodeContext.getNodeContext());
            }
        }
        if (flowContext != null) {
            root.put("context", flowContext);
            if (flowContext.getContext() != null) {
                root.put("bizContext", flowContext.getContext());
            }
            root.put("param", flowContext.getParam());
            if (flowContext.getParam() != null && flowContext.getParam().getParam() != null) {
                root.put("bizParam", flowContext.getParam().getParam());
            }
            if (flowContext.getParam() != null && flowContext.getParam().getDataMap() != null) {
                root.put("paramData", flowContext.getParam().getDataMap());
            }
            root.put("result", flowContext.getResult());
            if (flowContext.getResult() != null && flowContext.getResult().getResult() != null) {
                root.put("bizResult", flowContext.getResult().getResult());
            }
        }
        if (data != null) {
            root.putAll(data);
        }
        return root;
    }

    private Object buildRootMapRoot(NodeContext nodeContext, FlowContext flowContext, Map<String, Object> data) {
        ElRootMap root = new ElRootMap();
        if (nodeContext != null) {
            root.nodeContext = nodeContext;
            root.actionResult = nodeContext.getActionResult();
            if (nodeContext.getNodeContext() != null) {
                root.nodeBizContext = nodeContext.getNodeContext();
            }
        }
        if (flowContext != null) {
            root.context = flowContext;
            if (flowContext.getContext() != null) {
                root.bizContext = flowContext.getContext();
            }
            root.param = flowContext.getParam();
            if (flowContext.getParam() != null && flowContext.getParam().getParam() != null) {
                root.bizParam = flowContext.getParam().getParam();
            }
            if (flowContext.getParam() != null && flowContext.getParam().getDataMap() != null) {
                root.paramData = flowContext.getParam().getDataMap();
            }
            root.result = flowContext.getResult();
            if (flowContext.getResult() != null && flowContext.getResult().getResult() != null) {
                root.bizResult = flowContext.getResult().getResult();
            }
        }
        if (data != null) {
            root.data = data;
        }
        return root;
    }

    public int getRootType() {
        return this.rootType;
    }

    public void setRootType(int rootType) {
        this.rootType = rootType;
    }

    public boolean isCache() {
        return this.cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }
}

