/*
 * Decompiled with CFR 0.152.
 */
package com.jd.easyflow.flow.engine;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.jd.easyflow.flow.engine.FlowContext;
import com.jd.easyflow.flow.engine.impl.FlowContextImpl;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FlowParam
implements Serializable {
    private String flowId;
    private String[] nodeIds;
    private Object param;
    @JsonIgnore
    private FlowContext context;
    private Map<String, Object> dataMap = new ConcurrentHashMap<String, Object>();
    private Boolean logFlag;

    public FlowParam() {
    }

    public FlowParam(String flowId) {
        this.flowId = flowId;
    }

    public FlowParam(String flowId, Object param) {
        this.flowId = flowId;
        this.param = param;
    }

    public FlowParam(String flowId, String[] nodeIds, Object param) {
        this.flowId = flowId;
        this.nodeIds = nodeIds;
        this.param = param;
    }

    public FlowParam(String flowId, String[] nodeIds, Object param, Map<String, Object> dataMap) {
        this.flowId = flowId;
        this.nodeIds = nodeIds;
        this.param = param;
        if (dataMap != null) {
            for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
                if (entry.getValue() == null) {
                    this.dataMap.remove(entry.getKey());
                    continue;
                }
                this.dataMap.put(entry.getKey(), entry.getValue());
            }
        }
        this.dataMap = dataMap;
    }

    public FlowParam(String flowId, String nodeId, Object param) {
        this.flowId = flowId;
        this.nodeIds = new String[]{nodeId};
        this.param = param;
    }

    public String getFlowId() {
        return this.flowId;
    }

    public void setFlowId(String flowId) {
        this.flowId = flowId;
    }

    public String[] getNodeIds() {
        return this.nodeIds;
    }

    public void setNodeIds(String[] nodeIds) {
        this.nodeIds = nodeIds;
    }

    public void setNodeId(String nodeId) {
        if (nodeId == null) {
            return;
        }
        this.nodeIds = new String[]{nodeId};
    }

    public <T> T getParam() {
        return (T)this.param;
    }

    public <T> T getParam(int index) {
        if (this.param == null) {
            return null;
        }
        if (this.param instanceof Object[]) {
            return (T)((Object[])this.param)[index];
        }
        if (this.param instanceof List) {
            return (T)((List)this.param).get(index);
        }
        throw new IllegalStateException("Param:" + this.param + " is not index type");
    }

    public <T> T getParam(String key) {
        if (this.param == null) {
            return null;
        }
        return (T)((Map)this.param).get(key);
    }

    public void putParam(String key, Object value) {
        if (this.param == null) {
            this.param = new ConcurrentHashMap();
        }
        if (value == null) {
            ((Map)this.param).remove(key);
        } else {
            ((Map)this.param).put(key, value);
        }
    }

    public void setParam(Object param) {
        this.param = param;
    }

    public FlowContext getContext() {
        return this.context;
    }

    public void setContext(FlowContext context) {
        this.context = context;
    }

    public Map<String, Object> getDataMap() {
        return this.dataMap;
    }

    public void setDataMapFrom(FlowParam fromParam) {
        this.dataMap = fromParam.dataMap;
    }

    public void put(String key, Object value) {
        if (value == null) {
            this.dataMap.remove(key);
        } else {
            this.dataMap.put(key, value);
        }
    }

    public <T> T get(String key) {
        return (T)this.dataMap.get(key);
    }

    public void putContextData(String key, Object value) {
        if (this.context == null) {
            this.context = new FlowContextImpl();
        }
        if (value == null) {
            this.context.remove(key);
        } else {
            this.context.put(key, value);
        }
    }

    public void setBizContext(Object bizContext) {
        if (this.context == null) {
            this.context = new FlowContextImpl();
        }
        this.context.setContext(bizContext);
    }

    public Boolean getLogFlag() {
        return this.logFlag;
    }

    public void setLogFlag(Boolean logFlag) {
        this.logFlag = logFlag;
    }
}

