/*
 * Decompiled with CFR 0.152.
 */
package com.jd.easyflow.flow.engine.event;

import com.jd.easyflow.flow.engine.FlowContext;
import com.jd.easyflow.flow.engine.event.FlowEvent;
import com.jd.easyflow.flow.engine.event.FlowEventListener;
import com.jd.easyflow.flow.model.Flow;
import com.jd.easyflow.flow.model.InitContext;
import com.jd.easyflow.flow.util.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowEventTrigger {
    public static final Logger logger = LoggerFactory.getLogger(FlowEventTrigger.class);
    public static final String NULL_KEY = null;
    private List<FlowEventListener> listenerList;
    private Map<String, TreeMap<Integer, List<FlowEventListener>>> listenerMap;

    public void init(InitContext initContext, Flow flow) {
        if (this.listenerList != null) {
            for (FlowEventListener listener : this.listenerList) {
                listener.init(initContext, flow);
            }
        }
    }

    public void destroy() {
        if (this.listenerList != null) {
            for (FlowEventListener listener : this.listenerList) {
                listener.destroy();
            }
        }
    }

    public void addListener(FlowEventListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new ArrayList<FlowEventListener>();
            this.listenerMap = new HashMap<String, TreeMap<Integer, List<FlowEventListener>>>();
        }
        this.listenerList.add(listener);
        Pair<String, Integer>[] pairs = listener.getAcceptedEvents();
        if (pairs == null) {
            pairs = new Pair[]{Pair.of(NULL_KEY, 0)};
        }
        for (Pair<String, Integer> pair : pairs) {
            List<FlowEventListener> listeners;
            TreeMap<Integer, List<FlowEventListener>> map = this.listenerMap.get(pair.getLeft());
            if (map == null) {
                map = new TreeMap(Comparator.reverseOrder());
                this.listenerMap.put(pair.getLeft(), map);
            }
            if ((listeners = map.get(pair.getRight())) == null) {
                listeners = new ArrayList<FlowEventListener>();
                map.put(pair.getRight(), listeners);
            }
            listeners.add(listener);
        }
    }

    public void triggerEvent(String eventType, FlowContext context) {
        this.triggerEvent(eventType, null, context, false);
    }

    public void triggerEvent(String eventType, Object eventData, FlowContext context, boolean catchThrowable) {
        List<FlowEventListener> list;
        TreeMap<Integer, List<FlowEventListener>> nullMap;
        List<FlowEventListener> keyZeroListeners;
        if (this.listenerList == null || this.listenerList.size() == 0) {
            return;
        }
        FlowEvent event = null;
        TreeMap<Integer, List<FlowEventListener>> map = this.listenerMap.get(eventType);
        if (map != null) {
            event = this.createEvent(eventType, eventData, context);
        }
        if (map != null) {
            for (Map.Entry<Integer, List<FlowEventListener>> entry : map.entrySet()) {
                if (entry.getKey() <= 0) break;
                for (FlowEventListener listener : entry.getValue()) {
                    this.onEvent(event, listener, catchThrowable);
                }
            }
        }
        if (map != null && (keyZeroListeners = map.get(0)) != null) {
            for (FlowEventListener flowEventListener : keyZeroListeners) {
                this.onEvent(event, flowEventListener, catchThrowable);
            }
        }
        if ((nullMap = this.listenerMap.get(NULL_KEY)) != null && (list = nullMap.get(0)) != null) {
            if (event == null) {
                event = this.createEvent(eventType, eventData, context);
            }
            for (FlowEventListener listener : list) {
                this.onEvent(event, listener, catchThrowable);
            }
        }
        if (map != null) {
            for (Map.Entry<Integer, List<FlowEventListener>> entry : map.entrySet()) {
                if (entry.getKey() >= 0) continue;
                for (int i = 0; i < entry.getValue().size(); ++i) {
                    this.onEvent(event, entry.getValue().get(entry.getValue().size() - 1 - i), catchThrowable);
                }
            }
        }
    }

    private FlowEvent createEvent(String eventType, Object eventData, FlowContext context) {
        FlowEvent event = new FlowEvent();
        event.setType(eventType);
        event.setData(eventData);
        event.setContext(context);
        return event;
    }

    private void onEvent(FlowEvent event, FlowEventListener listener, boolean catchThrowable) {
        if (!catchThrowable) {
            listener.on(event);
        } else {
            try {
                listener.on(event);
            }
            catch (Throwable t) {
                logger.error("Exception on event of " + listener.getClass().getName() + ", message:" + t.getMessage(), t);
            }
        }
    }

    public List<FlowEventListener> getListenerList() {
        return this.listenerList;
    }
}

