/*
 * Decompiled with CFR 0.152.
 */
package com.jd.easyflow.flow.engine.event.impl;

import com.jd.easyflow.flow.engine.event.BaseFlowEventListener;
import com.jd.easyflow.flow.engine.event.FlowEvent;
import com.jd.easyflow.flow.model.NodeContext;
import com.jd.easyflow.flow.util.FlowStringUtil;
import com.jd.easyflow.flow.util.Pair;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventFlowListener
extends BaseFlowEventListener {
    private static final Logger logger = LoggerFactory.getLogger(EventFlowListener.class);
    private int initEndEventOrder = 10000;

    @Override
    public Pair<String, Integer>[] getAcceptedEvents() {
        if (this.acceptedEvents != null) {
            return this.acceptedEvents;
        }
        return new Pair[]{Pair.of("INIT_END", this.initEndEventOrder)};
    }

    @Override
    public void on(FlowEvent event) {
        switch (event.getType()) {
            case "INIT_END": {
                String eventId = (String)event.getContext().getParam().get("_EVENT");
                if (!FlowStringUtil.isNotEmpty(eventId)) break;
                List<NodeContext> startNodes = event.getContext().getStartNodes();
                if (event.getContext().isLogOn() && logger.isInfoEnabled()) {
                    logger.info("EVENT ID:" + eventId);
                }
                if (startNodes == null || startNodes.isEmpty()) break;
                startNodes.forEach(node -> node.put("_EVENT", eventId));
                break;
            }
        }
    }

    public int getInitEndEventOrder() {
        return this.initEndEventOrder;
    }

    public void setInitEndEventOrder(int initEndEventOrder) {
        this.initEndEventOrder = initEndEventOrder;
    }
}

