/*
 * Decompiled with CFR 0.152.
 */
package com.jd.easyflow.flow.engine.impl;

import com.jd.easyflow.flow.engine.FlowContext;
import com.jd.easyflow.flow.engine.FlowRunner;
import com.jd.easyflow.flow.engine.impl.FlowContextImpl;
import com.jd.easyflow.flow.exception.FlowException;
import com.jd.easyflow.flow.model.Flow;
import com.jd.easyflow.flow.model.FlowNode;
import com.jd.easyflow.flow.model.NodeContext;
import com.jd.easyflow.flow.model.NodeContextAccessor;
import com.jd.easyflow.flow.util.Triple;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseFlowRunner
implements FlowRunner {
    private static final Logger logger = LoggerFactory.getLogger(BaseFlowRunner.class);
    private Function<Triple<FlowNode, NodeContext, FlowContext>, NodeContext> outerNodeInvoker = p -> this.invokeNode((FlowNode)p.getLeft(), (NodeContext)p.getMiddle(), (FlowContext)p.getRight());
    private Function<Triple<FlowNode, NodeContext, FlowContext>, NodeContext> innerNodeInvoker = p -> ((FlowNode)p.getLeft()).execute((NodeContext)p.getMiddle(), (FlowContext)p.getRight());
    private Function<FlowContext, Boolean> outerFlowPreHandlerInvoker = p -> this.invokePreHandler(p.getFlow(), (FlowContext)p);
    private Function<FlowContext, Boolean> innerFlowPreHandlerInvoker = p -> p.getFlow().getPreHandler().preHandle((FlowContext)p);
    private Function<FlowContext, Void> outerFlowPostHandlerInvoker = p -> {
        this.invokePostHandler(p.getFlow(), (FlowContext)p);
        return null;
    };
    private Function<FlowContext, Void> innerFlowPostHandlerInvoker = p -> {
        p.getFlow().getPostHandler().postHandle((FlowContext)p);
        return null;
    };

    @Override
    public void run(FlowContext context) {
        Flow flow = context.getFlow();
        flow.triggerEvent("RUN_START", context);
        if (!this.executePreHandler(flow, context)) {
            flow.triggerEvent("RUN_END", context);
            return;
        }
        this.runNodes((FlowContextImpl)context);
        this.executePostHandler(flow, context);
        flow.triggerEvent("RUN_END", context);
    }

    public abstract void runNodes(FlowContextImpl var1);

    protected NodeContext[] runOneNodeAndAddNextNodes(NodeContext currentNode, FlowContextImpl context) {
        NodeContext[] nextNodes = this.runOneNode(currentNode, context);
        if (nextNodes != null) {
            context.addNodes(nextNodes);
        }
        return nextNodes;
    }

    protected NodeContext[] runOneNode(NodeContext currentNode, FlowContextImpl context) {
        FlowNode node;
        if (context.isLogOn() && logger.isInfoEnabled()) {
            logger.info("EXECUTE NODE:" + currentNode.getNodeId());
        }
        if ((node = context.getFlow().getNode(currentNode.getNodeId())) == null) {
            throw new FlowException("Node " + currentNode.getNodeId() + " not exists");
        }
        NodeContext[] nextNodes = null;
        try {
            currentNode = this.runNode(node, currentNode, context);
            nextNodes = currentNode.getNextNodes();
        }
        catch (Throwable t) {
            NodeContextAccessor.setThrowable(currentNode, t);
            throw t;
        }
        finally {
            if (nextNodes == null) {
                context.addEndNode(currentNode);
            }
        }
        if (context.isLogOn() && logger.isInfoEnabled()) {
            if (nextNodes == null || nextNodes.length == 0) {
                logger.info("NEXT NODES:");
            } else if (nextNodes.length == 1) {
                logger.info("NEXT NODES:" + nextNodes[0].getNodeId());
            } else {
                StringBuilder builder = new StringBuilder();
                for (NodeContext n : nextNodes) {
                    builder.append(n.getNodeId()).append(",");
                }
                logger.info("NEXT NODES:" + (builder.length() == 0 ? "" : builder.substring(0, builder.length() - 1)));
            }
        }
        if (!context.isRecordHistory()) {
            NodeContextAccessor.setPreviousNode(currentNode, null);
            NodeContextAccessor.setNextNodes(currentNode, null);
        }
        return nextNodes;
    }

    protected NodeContext runNode(FlowNode node, NodeContext currentNode, FlowContextImpl context) {
        Flow flow = context.getFlow();
        if (flow.getFilterManager().noOuterNodeFilter()) {
            return this.invokeNode(node, currentNode, context);
        }
        return flow.getFilterManager().doOuterNodeFilter(Triple.of(node, currentNode, context), this.outerNodeInvoker);
    }

    private NodeContext invokeNode(FlowNode node, NodeContext currentNode, FlowContext context) {
        Throwable throwable = null;
        Flow flow = context.getFlow();
        try {
            flow.triggerEvent("NODE_START", currentNode, context, false);
            currentNode = flow.getFilterManager().noInnerNodeFilter() ? node.execute(currentNode, context) : flow.getFilterManager().doInnerNodeFilter(Triple.of(node, currentNode, context), this.innerNodeInvoker);
            flow.triggerEvent("NODE_END", currentNode, context, false);
            NodeContext nodeContext = currentNode;
            return nodeContext;
        }
        catch (Throwable t) {
            throwable = t;
            if (context.isLogOn() && logger.isErrorEnabled()) {
                logger.error("Flow node execute exception, Node:" + currentNode.getNodeId() + "," + t.getMessage());
            }
            throw t;
        }
        finally {
            NodeContextAccessor.setThrowable(currentNode, throwable);
            flow.triggerEvent("NODE_COMPLETE", currentNode, context, true);
        }
    }

    private boolean executePreHandler(Flow flow, FlowContext context) {
        if (flow.getFilterManager().noOuterFlowPreHandlerFilter()) {
            return this.invokePreHandler(flow, context);
        }
        Boolean preResult = flow.getFilterManager().doOuterFlowPreHandlerFilter(context, this.outerFlowPreHandlerInvoker);
        ((FlowContextImpl)context).setPreResult(preResult);
        return preResult == null ? true : preResult;
    }

    private boolean invokePreHandler(Flow flow, FlowContext context) {
        if (flow.getPreHandler() != null) {
            Boolean result;
            flow.triggerEvent("FLOW_PRE_START", context);
            boolean preResult = flow.getFilterManager().noInnerFlowPreHandlerFilter() ? flow.getPreHandler().preHandle(context) : ((result = flow.getFilterManager().doInnerFlowPreHandlerFilter(context, this.innerFlowPreHandlerInvoker)) == null ? true : result);
            ((FlowContextImpl)context).setPreResult(preResult);
            flow.triggerEvent("FLOW_PRE_END", context);
        }
        return context.getPreResult() == null ? true : context.getPreResult();
    }

    private void executePostHandler(Flow flow, FlowContext context) {
        if (flow.getFilterManager().noOuterFlowPostHandlerFilter()) {
            this.invokePostHandler(flow, context);
        } else {
            flow.getFilterManager().doOuterFlowPostHandlerFilter(context, this.outerFlowPostHandlerInvoker);
        }
    }

    private void invokePostHandler(Flow flow, FlowContext context) {
        if (flow.getPostHandler() != null) {
            flow.triggerEvent("FLOW_POST_START", context);
            if (flow.getFilterManager().noInnerFlowPostHandlerFilter()) {
                flow.getPostHandler().postHandle(context);
            } else {
                flow.getFilterManager().doInnerFlowPostHandlerFilter(context, this.innerFlowPostHandlerInvoker);
            }
            flow.triggerEvent("FLOW_POST_END", context);
        }
    }
}

