/*
 * Decompiled with CFR 0.152.
 */
package com.jd.easyflow.flow.engine.impl;

import com.jd.easyflow.flow.el.ElEvaluator;
import com.jd.easyflow.flow.el.ElFactory;
import com.jd.easyflow.flow.engine.FlowContext;
import com.jd.easyflow.flow.engine.FlowEngine;
import com.jd.easyflow.flow.engine.FlowParam;
import com.jd.easyflow.flow.engine.FlowResult;
import com.jd.easyflow.flow.engine.FlowRunner;
import com.jd.easyflow.flow.engine.event.FlowEventListener;
import com.jd.easyflow.flow.engine.event.FlowEventTrigger;
import com.jd.easyflow.flow.engine.filter.FlowEngineFilterManager;
import com.jd.easyflow.flow.engine.impl.FlowContextImpl;
import com.jd.easyflow.flow.engine.impl.SingleThreadFlowRunner;
import com.jd.easyflow.flow.exception.FlowException;
import com.jd.easyflow.flow.filter.Filter;
import com.jd.easyflow.flow.model.Flow;
import com.jd.easyflow.flow.model.NodeContext;
import com.jd.easyflow.flow.model.parser.FlowParser;
import com.jd.easyflow.flow.model.parser.FlowParserImpl;
import com.jd.easyflow.flow.util.FlowIOUtil;
import com.jd.easyflow.flow.util.JsonUtil;
import com.jd.easyflow.flow.util.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CoreFlowEngine
implements FlowEngine {
    public static final Logger logger = LoggerFactory.getLogger(CoreFlowEngine.class);
    protected Map<String, Flow> flowMap = new ConcurrentHashMap<String, Flow>();
    protected Map<String, String> flowDefinitionMap = new ConcurrentHashMap<String, String>();
    protected FlowEventTrigger eventTrigger = new FlowEventTrigger();
    protected FlowEngineFilterManager filterManager = new FlowEngineFilterManager();
    protected List<FlowEventListener> listeners;
    protected List<Filter<Pair<FlowParam, FlowEngine>, FlowResult>> filters;
    protected String flowPath;
    protected volatile boolean inited;
    protected FlowRunner defaultFlowRunner = new SingleThreadFlowRunner();
    protected FlowParser flowParser = new FlowParserImpl();
    protected Map<String, Object> properties = new ConcurrentHashMap<String, Object>();
    protected ElEvaluator elEvaluator;
    private Function<Pair<FlowParam, FlowEngine>, FlowResult> outerFlowEngineInvoker = p -> this.invokeFlowEngine((FlowParam)p.getLeft());
    private Function<Pair<FlowParam, FlowEngine>, FlowResult> innerFlowEngineInvoker = p -> this.executeFlow((FlowParam)p.getLeft());
    private Function<FlowContext, FlowResult> outerFlowInvoker = p -> this.invokeFlow((FlowContext)p);
    private Function<FlowContext, FlowResult> innerFlowInvoker = p -> {
        this.init((FlowContext)p);
        this.run((FlowContext)p);
        return p.getResult();
    };

    public void init() {
        if (this.inited) {
            return;
        }
        if (this.elEvaluator == null) {
            this.elEvaluator = ElFactory.get();
        }
        if (this.flowParser instanceof FlowParserImpl) {
            ((FlowParserImpl)this.flowParser).setElEvaluator(this.elEvaluator);
        }
        this.loadFlow();
        if (this.listeners != null) {
            this.listeners.forEach(listener -> this.eventTrigger.addListener((FlowEventListener)listener));
        }
        this.eventTrigger.init(null, null);
        if (this.filters != null) {
            this.filterManager.setFilters(this.filters);
        }
        this.filterManager.init(null, null);
        if (this.defaultFlowRunner != null) {
            this.defaultFlowRunner.init(null, null);
        }
        this.inited = true;
    }

    protected abstract void loadFlow();

    protected void loadFlowInputStream(InputStream inputStream) throws IOException {
        String flowDefinition = FlowIOUtil.toString(inputStream);
        List<Flow> flowList = this.flowParser.parse(flowDefinition);
        this.flowDefinitionMap.put(flowList.get(0).getId(), flowDefinition);
        flowList.forEach(flow -> {
            if (this.flowMap.containsKey(flow.getId())) {
                throw new FlowException("Flow " + flow.getId() + " exists");
            }
            this.flowMap.put(flow.getId(), (Flow)flow);
        });
    }

    @Override
    public FlowResult execute(FlowParam param) {
        boolean logOn;
        if (!this.inited) {
            throw new FlowException("Flow engine is not inited. flowId:" + param.getFlowId());
        }
        boolean bl = param.getContext() != null && param.getContext().getLogFlag() != null ? param.getContext().getLogFlag() : (logOn = param.getLogFlag() == null || param.getLogFlag() != false);
        if (logOn && logger.isInfoEnabled()) {
            logger.info("START EXECUTE FLOW, flowId:" + param.getFlowId() + " nodeIds:" + Arrays.toString(param.getNodeIds()));
        }
        if (logOn && logger.isDebugEnabled()) {
            try {
                logger.debug("Flow param:" + JsonUtil.toJsonString(param));
            }
            catch (Throwable t) {
                logger.debug("Flow param to json string exception:" + t.getMessage());
            }
        }
        if (this.filterManager.noOuterFilter()) {
            return this.invokeFlowEngine(param);
        }
        return this.filterManager.doOuterFilter(Pair.of(param, this), this.outerFlowEngineInvoker);
    }

    protected FlowResult invokeFlowEngine(FlowParam param) {
        FlowResult result = null;
        if (this.eventTrigger.getListenerList() == null || this.eventTrigger.getListenerList().size() == 0) {
            result = this.filterManager.noInnerFilter() ? this.executeFlow(param) : this.filterManager.doInnerFilter(Pair.of(param, this), this.innerFlowEngineInvoker);
            return result;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("param", param);
        data.put("flowEngine", this);
        try {
            this.eventTrigger.triggerEvent("FLOW_ENGINE_START", data, null, false);
            result = this.filterManager.noInnerFilter() ? this.executeFlow(param) : this.filterManager.doInnerFilter(Pair.of(param, this), this.innerFlowEngineInvoker);
            data.put("result", result);
            this.eventTrigger.triggerEvent("FLOW_ENGINE_END", data, null, false);
            FlowResult flowResult = result;
            return flowResult;
        }
        catch (Throwable t) {
            data.put("exception", t);
            throw t;
        }
        finally {
            this.eventTrigger.triggerEvent("FLOW_ENGINE_COMPLETE", data, null, true);
        }
    }

    protected FlowResult executeFlow(FlowParam param) {
        FlowContext context = this.initContext(param);
        Flow flow = this.findFlow(context);
        if (flow == null) {
            throw new FlowException("Flow is null, context flow id:" + context.getFlowId() + ", param flow id:" + param.getFlowId());
        }
        if (context.getLogFlag() == null) {
            if (param.getLogFlag() != null) {
                context.setLogFlag(param.getLogFlag());
            } else {
                context.setLogFlag(flow.getLogFlag());
            }
        }
        if (context.isLogOn() && logger.isInfoEnabled()) {
            logger.info("EXECUTE FLOW, flowId:" + flow.getId());
        }
        if (flow.getFilterManager().noOuterFilter()) {
            return this.invokeFlow(context);
        }
        return flow.getFilterManager().doOuterFilter(context, this.outerFlowInvoker);
    }

    protected FlowResult invokeFlow(FlowContext context) {
        Flow flow = context.getFlow();
        Throwable throwable = null;
        try {
            FlowResult flowResult;
            flow.triggerEvent("FLOW_START", context);
            if (flow.getFilterManager().noInnerFilter()) {
                this.init(context);
                this.run(context);
            } else {
                flowResult = flow.getFilterManager().doInnerFilter(context, this.innerFlowInvoker);
                context.setResult(flowResult);
            }
            flow.triggerEvent("FLOW_END", context);
            flowResult = context.getResult();
            return flowResult;
        }
        catch (Throwable t) {
            throwable = t;
            if (context.isLogOn() && logger.isErrorEnabled()) {
                logger.error("Flow execute exception, Flow:" + flow.getId() + "," + t.getMessage());
            }
            throw t;
        }
        finally {
            flow.triggerEvent("FLOW_COMPLETE", throwable, context, true);
        }
    }

    protected FlowContext initContext(FlowParam param) {
        FlowContext context;
        FlowContext flowContext = context = param.getContext() != null ? param.getContext() : new FlowContextImpl();
        if (context.getParam() == null) {
            context.setParam(param);
        }
        if (context.getResult() == null) {
            FlowResult result = new FlowResult();
            context.setResult(result);
            result.setContext(context);
        }
        if (context.getFlowId() == null) {
            context.setFlowId(param.getFlowId());
        }
        ((FlowContextImpl)context).setFlowEngine(this);
        if (context.getElEvaluator() == null) {
            ((FlowContextImpl)context).setElEvaluator(this.getElEvaluator());
        }
        return context;
    }

    protected void run(FlowContext context) {
        FlowRunner flowRunner = context.getFlow().getRunner();
        if (flowRunner == null) {
            flowRunner = this.defaultFlowRunner;
        }
        flowRunner.run(context);
    }

    protected Flow findFlow(FlowContext context) {
        Flow flow = context.getFlow();
        if (flow == null) {
            flow = this.getFlow(context.getFlowId());
            if (flow == null) {
                throw new FlowException("Flow " + context.getFlowId() + " not exists");
            }
            context.setFlow(flow);
        }
        context.setFlowId(flow.getId());
        return flow;
    }

    @Override
    public Flow getFlow(String flowId) {
        return this.flowMap.get(flowId);
    }

    protected void init(FlowContext context) {
        context.getFlow().triggerEvent("INIT_START", context);
        if (context.getStartNodes() == null) {
            String[] nodeIds = context.getParam().getNodeIds();
            if (nodeIds == null) {
                nodeIds = context.getFlow().getStartNodeIds();
            }
            if (nodeIds == null) {
                throw new FlowException("no start node");
            }
            NodeContext[] nodes = new NodeContext[nodeIds.length];
            for (int i = 0; i < nodeIds.length; ++i) {
                nodes[i] = new NodeContext(nodeIds[i]);
            }
            ((FlowContextImpl)context).addNodes(nodes);
            context.setStartNodes(Arrays.asList(nodes));
        } else {
            ((FlowContextImpl)context).addNodes(context.getStartNodes().toArray(new NodeContext[context.getStartNodes().size()]));
        }
        context.getFlow().triggerEvent("INIT_END", context);
    }

    public void addFlow(Flow flow) {
        this.flowMap.put(flow.getId(), flow);
    }

    public void destroy() {
        if (this.defaultFlowRunner != null) {
            this.defaultFlowRunner.destroy();
        }
        if (this.flowMap != null && this.flowMap.size() > 0) {
            for (Map.Entry<String, Flow> entry : this.flowMap.entrySet()) {
                entry.getValue().destroy();
            }
        }
        this.eventTrigger.destroy();
        if (this.filters != null) {
            this.filters.forEach(filter -> filter.destroy());
        }
    }

    public String getFlowPath() {
        return this.flowPath;
    }

    public void setFlowPath(String flowPath) {
        this.flowPath = flowPath;
    }

    public Map<String, Flow> getFlowMap() {
        return this.flowMap;
    }

    public void setFlowMap(Map<String, Flow> flowMap) {
        this.flowMap = flowMap;
    }

    public Map<String, String> getFlowDefinitionMap() {
        return this.flowDefinitionMap;
    }

    public void setFlowDefinitionMap(Map<String, String> flowDefinitionMap) {
        this.flowDefinitionMap = flowDefinitionMap;
    }

    public List<Filter<Pair<FlowParam, FlowEngine>, FlowResult>> getFilters() {
        return this.filters;
    }

    public void setFilters(List<Filter<Pair<FlowParam, FlowEngine>, FlowResult>> filters) {
        this.filters = filters;
    }

    public FlowEventTrigger getEventTrigger() {
        return this.eventTrigger;
    }

    public void setEventTrigger(FlowEventTrigger eventTrigger) {
        this.eventTrigger = eventTrigger;
    }

    public List<FlowEventListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<FlowEventListener> listeners) {
        this.listeners = listeners;
    }

    public FlowRunner getDefaultFlowRunner() {
        return this.defaultFlowRunner;
    }

    public void setDefaultFlowRunner(FlowRunner defaultFlowRunner) {
        this.defaultFlowRunner = defaultFlowRunner;
    }

    @Override
    public FlowParser getFlowParser() {
        return this.flowParser;
    }

    public void setFlowParser(FlowParser flowParser) {
        this.flowParser = flowParser;
    }

    public boolean isInited() {
        return this.inited;
    }

    public void setInited(boolean inited) {
        this.inited = inited;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @Override
    public <T> T getProperty(String key) {
        return (T)this.properties.get(key);
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    @Override
    public ElEvaluator getElEvaluator() {
        return this.elEvaluator;
    }

    public void setElEvaluator(ElEvaluator elEvaluator) {
        this.elEvaluator = elEvaluator;
    }

    public FlowEngineFilterManager getFilterManager() {
        return this.filterManager;
    }

    public void setFilterManager(FlowEngineFilterManager filterManager) {
        this.filterManager = filterManager;
    }
}

