/*
 * Decompiled with CFR 0.152.
 */
package com.jd.easyflow.flow.engine.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.jd.easyflow.flow.el.ElEvaluator;
import com.jd.easyflow.flow.engine.FlowContext;
import com.jd.easyflow.flow.engine.FlowEngine;
import com.jd.easyflow.flow.engine.FlowParam;
import com.jd.easyflow.flow.engine.FlowResult;
import com.jd.easyflow.flow.model.Flow;
import com.jd.easyflow.flow.model.NodeContext;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FlowContextImpl
implements FlowContext {
    private String flowId;
    private Flow flow;
    private FlowParam param;
    private FlowResult result;
    private List<NodeContext> startNodes;
    private List<NodeContext> endNodes;
    private Deque<NodeContext> nodeStack = new ArrayDeque<NodeContext>();
    private Map<String, Object> data = new ConcurrentHashMap<String, Object>();
    private Object context;
    @JsonIgnore
    private FlowEngine flowEngine;
    private volatile boolean interrupted = false;
    private Boolean preResult;
    private Boolean logFlag;
    private ElEvaluator elEvaluator;
    private Boolean recordHistory;
    private FlowContext parentContext;
    private NodeContext parentNodeContext;

    @Override
    public void put(String key, Object value) {
        if (value == null) {
            this.data.remove(key);
        } else {
            this.data.put(key, value);
        }
    }

    @Override
    public <T> T get(String key) {
        return (T)this.data.get(key);
    }

    @Override
    public void remove(String key) {
        this.data.remove(key);
    }

    public synchronized void addNodes(NodeContext[] nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            this.nodeStack.push(nodes[nodes.length - 1 - i]);
        }
    }

    public synchronized NodeContext getNextNode() {
        if (this.nodeStack.isEmpty()) {
            return null;
        }
        return this.nodeStack.pop();
    }

    @Override
    public FlowParam getParam() {
        return this.param;
    }

    @Override
    public void setParam(FlowParam param) {
        this.param = param;
    }

    @Override
    public FlowResult getResult() {
        return this.result;
    }

    @Override
    public void setResult(FlowResult result) {
        this.result = result;
    }

    @Override
    public String getFlowId() {
        return this.flowId;
    }

    @Override
    public void setFlowId(String flowId) {
        this.flowId = flowId;
    }

    @Override
    public Flow getFlow() {
        return this.flow;
    }

    @Override
    public void setFlow(Flow flow) {
        this.flow = flow;
    }

    @Override
    public Map<String, Object> getData() {
        return this.data;
    }

    public void setDataFrom(FlowContext fromContext) {
        this.data = fromContext.getData();
    }

    @Override
    public FlowEngine getFlowEngine() {
        return this.flowEngine;
    }

    public void setFlowEngine(FlowEngine flowEngine) {
        this.flowEngine = flowEngine;
    }

    @Override
    public List<NodeContext> getStartNodes() {
        return this.startNodes;
    }

    @Override
    public void setStartNodes(List<NodeContext> startNodes) {
        this.startNodes = startNodes;
    }

    @Override
    public List<NodeContext> getEndNodes() {
        return this.endNodes;
    }

    public void setEndNodes(List<NodeContext> endNodes) {
        this.endNodes = endNodes;
    }

    public synchronized void addEndNode(NodeContext node) {
        if (this.endNodes == null) {
            this.endNodes = new ArrayList<NodeContext>();
        }
        this.endNodes.add(node);
    }

    @Override
    public boolean isInterrupted() {
        return this.interrupted;
    }

    @Override
    public void setInterrupted() {
        this.interrupted = true;
    }

    @Override
    public Boolean getPreResult() {
        return this.preResult;
    }

    public void setPreResult(Boolean preResult) {
        this.preResult = preResult;
    }

    @Override
    public Boolean getLogFlag() {
        return this.logFlag;
    }

    @Override
    public void setLogFlag(Boolean logFlag) {
        this.logFlag = logFlag;
    }

    @Override
    public boolean isLogOn() {
        return this.logFlag == null || this.logFlag != false;
    }

    @Override
    public <T> T getContext() {
        return (T)this.context;
    }

    @Override
    public void setContext(Object context) {
        this.context = context;
    }

    @Override
    public ElEvaluator getElEvaluator() {
        return this.elEvaluator;
    }

    public void setElEvaluator(ElEvaluator elEvaluator) {
        this.elEvaluator = elEvaluator;
    }

    @Override
    public boolean isRecordHistory() {
        if (this.recordHistory == null) {
            this.recordHistory = !Boolean.FALSE.equals(this.flow.getProperty("flow.recordHistory"));
        }
        return this.recordHistory;
    }

    public Boolean getRecordHistory() {
        return this.recordHistory;
    }

    public void setRecordHistory(Boolean recordHistory) {
        this.recordHistory = recordHistory;
    }

    @Override
    public FlowContext getParentContext() {
        return this.parentContext;
    }

    public void setParentContext(FlowContext parentContext) {
        this.parentContext = parentContext;
    }

    @Override
    public NodeContext getParentNodeContext() {
        return this.parentNodeContext;
    }

    public void setParentNodeContext(NodeContext parentNodeContext) {
        this.parentNodeContext = parentNodeContext;
    }
}

