/*
 * Decompiled with CFR 0.152.
 */
package com.jd.easyflow.flow.engine.impl;

import com.jd.easyflow.flow.engine.impl.CoreFlowEngine;
import com.jd.easyflow.flow.util.SpelHelper;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class FlowEngineImpl
extends CoreFlowEngine
implements SmartLifecycle,
ApplicationContextAware {
    public static final Logger logger = LoggerFactory.getLogger(FlowEngineImpl.class);
    private ApplicationContext applicationContext;
    private int phase = Integer.MIN_VALUE;
    private boolean autoStartup = true;
    private volatile boolean isRunning = false;

    @Override
    public void init() {
        if (this.inited) {
            return;
        }
        if (this.applicationContext != null) {
            SpelHelper.setApplicationContext(this.applicationContext);
        }
        super.init();
        this.inited = true;
    }

    @Override
    protected void loadFlow() {
        String[] flowPaths;
        if (this.flowPath == null) {
            return;
        }
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        for (String path : flowPaths = this.flowPath.split(",")) {
            try {
                Resource[] resources;
                for (Resource resource : resources = resolver.getResources(path.trim())) {
                    if (logger.isInfoEnabled()) {
                        logger.info("Start parsing definition files:" + resource.getURI());
                    }
                    try (InputStream is = resource.getInputStream();){
                        this.loadFlowInputStream(is);
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Flow definition file parse exception", e);
            }
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void start() {
        this.init();
        this.isRunning = true;
    }

    public void stop() {
        this.isRunning = false;
        this.destroy();
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public int getPhase() {
        return this.phase;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }
}

