/*
 * Decompiled with CFR 0.152.
 */
package com.jd.easyflow.flow.engine.impl;

import com.jd.easyflow.flow.engine.impl.FlowContextImpl;
import com.jd.easyflow.flow.engine.impl.MultipleThreadFlowRunner;
import com.jd.easyflow.flow.model.NodeContext;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReusableThreadFlowRunner
extends MultipleThreadFlowRunner {
    private static final Logger logger = LoggerFactory.getLogger(ReusableThreadFlowRunner.class);

    public ReusableThreadFlowRunner() {
    }

    public ReusableThreadFlowRunner(Executor executor, long timeout) {
        this.executor = executor;
        this.timeout = timeout;
    }

    public ReusableThreadFlowRunner(Executor executor, long timeout, boolean throwExceptionOnTimeout) {
        this.executor = executor;
        this.timeout = timeout;
        this.throwExceptionOnTimeout = throwExceptionOnTimeout;
    }

    @Override
    protected void scheduleNodes(FlowContextImpl context, AtomicInteger counter, CountDownLatch lock, String runId) {
        List<NodeContext> startNodes = context.getStartNodes();
        if (startNodes.size() == 0) {
            lock.countDown();
            return;
        }
        counter.addAndGet(startNodes.size());
        if (this.timeout == 0L) {
            this.runNodes(startNodes.toArray(new NodeContext[startNodes.size()]), context, counter, lock, runId);
        } else {
            this.executor.execute(() -> this.runNodes(startNodes.toArray(new NodeContext[startNodes.size()]), context, counter, lock, runId));
        }
    }

    private void runNodes(NodeContext[] nodes, FlowContextImpl context, AtomicInteger counter, CountDownLatch lock, String runId) {
        while (nodes != null && nodes.length != 0) {
            if (nodes.length > 1) {
                for (int i = 1; i < nodes.length; ++i) {
                    NodeContext finalNode = nodes[i];
                    this.executor.execute(() -> this.runNodes(new NodeContext[]{finalNode}, context, counter, lock, runId));
                }
            }
            NodeContext[] nextNodes = this.doRunOneNode(nodes[0], context, counter, lock, runId);
            nodes = nextNodes;
        }
        return;
    }

    private NodeContext[] doRunOneNode(NodeContext node, FlowContextImpl context, AtomicInteger counter, CountDownLatch lock, String runId) {
        int count;
        NodeContext[] nextNodes = null;
        try {
            if (context.isLogOn() && logger.isInfoEnabled()) {
                logger.info("Start execute flow node:" + node.getNodeId() + ", runId:" + runId);
            }
            nextNodes = super.runOneNode(node, context);
        }
        catch (Throwable t) {
            this.addException(context, node, t);
        }
        if (context.isInterrupted()) {
            if (context.isLogOn() && logger.isInfoEnabled()) {
                logger.info("Flow state is interrupted");
            }
            lock.countDown();
            return null;
        }
        if (nextNodes != null && nextNodes.length > 0) {
            counter.addAndGet(nextNodes.length);
        }
        if ((count = counter.addAndGet(-1)) == 0) {
            lock.countDown();
        }
        return nextNodes;
    }
}

