/*
 * Decompiled with CFR 0.152.
 */
package com.jd.easyflow.flow.filter;

import com.jd.easyflow.flow.el.ElEvaluator;
import com.jd.easyflow.flow.el.ElFactory;
import com.jd.easyflow.flow.engine.FlowContext;
import com.jd.easyflow.flow.engine.FlowEngine;
import com.jd.easyflow.flow.filter.BaseFilter;
import com.jd.easyflow.flow.filter.FilterChain;
import com.jd.easyflow.flow.util.JsonUtil;
import com.jd.easyflow.flow.util.Pair;
import com.jd.easyflow.flow.util.Triple;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpFilter<T, R>
extends BaseFilter<T, R> {
    private static final Logger logger = LoggerFactory.getLogger(ExpFilter.class);
    private ElEvaluator elEvaluator;
    private String exp;

    public ExpFilter() {
    }

    public ExpFilter(String exp) {
        this.exp = exp;
    }

    @Override
    public R doFilter(T request, FilterChain<T, R> chain) {
        ElEvaluator evaluator;
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("request", request);
        data.put("chain", chain);
        if (logger.isDebugEnabled()) {
            logger.debug("EVAL SPEL:" + this.exp);
        }
        if ((evaluator = this.elEvaluator) == null) {
            if (request instanceof FlowContext) {
                evaluator = ((FlowContext)request).getElEvaluator();
            } else if (request instanceof Pair) {
                if (((Pair)request).getRight() instanceof FlowContext) {
                    evaluator = ((FlowContext)((Pair)request).getRight()).getElEvaluator();
                } else if (((Pair)request).getRight() instanceof FlowEngine) {
                    evaluator = ((FlowEngine)((Pair)request).getRight()).getElEvaluator();
                }
            } else if (request instanceof Triple && ((Triple)request).getRight() instanceof FlowContext) {
                evaluator = ((FlowContext)((Triple)request).getRight()).getElEvaluator();
            }
        }
        if (evaluator == null) {
            evaluator = ElFactory.get();
        }
        Object result = evaluator.evalWithDefaultContext(this.exp, data, true);
        if (logger.isDebugEnabled()) {
            try {
                logger.debug("SPEL RESULT:" + JsonUtil.toJsonString(result));
            }
            catch (Throwable t) {
                logger.debug("SPEL RESULT to json string exception:" + t.getMessage());
            }
        }
        return (R)result;
    }

    public String getExp() {
        return this.exp;
    }

    public void setExp(String exp) {
        this.exp = exp;
    }

    public ElEvaluator getElEvaluator() {
        return this.elEvaluator;
    }

    public void setElEvaluator(ElEvaluator elEvaluator) {
        this.elEvaluator = elEvaluator;
    }
}

