/*
 * Decompiled with CFR 0.152.
 */
package com.jd.easyflow.flow.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.jd.easyflow.flow.engine.FlowContext;
import com.jd.easyflow.flow.engine.FlowRunner;
import com.jd.easyflow.flow.engine.event.FlowEventTrigger;
import com.jd.easyflow.flow.exception.FlowException;
import com.jd.easyflow.flow.model.FlowLifeCycle;
import com.jd.easyflow.flow.model.FlowNode;
import com.jd.easyflow.flow.model.FlowPostHandler;
import com.jd.easyflow.flow.model.FlowPreHandler;
import com.jd.easyflow.flow.model.InitContext;
import com.jd.easyflow.flow.model.filter.FlowFilterManager;
import com.jd.easyflow.flow.model.parser.FlowParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Flow
implements FlowLifeCycle {
    public static final String DOLLAR = "$";
    private String id;
    private String name;
    private String[] startNodeIds;
    private List<FlowNode> nodeList;
    private Map<String, Object> properties = new ConcurrentHashMap<String, Object>();
    private Map<String, FlowNode> nodeMap;
    private Map<String, Integer> nodeIndexMap;
    private FlowPreHandler preHandler;
    private FlowPostHandler postHandler;
    private FlowEventTrigger eventTrigger = new FlowEventTrigger();
    private FlowFilterManager filterManager = new FlowFilterManager();
    private FlowRunner runner;
    @JsonIgnore
    private FlowParser flowParser;
    private Boolean logFlag;

    @Override
    public void init(InitContext initContext, Object parent) {
        if (this.preHandler != null) {
            this.preHandler.init(initContext, this);
        }
        if (this.nodeList != null) {
            for (FlowNode flowNode : this.nodeList) {
                flowNode.init(initContext, this);
            }
        }
        if (this.postHandler != null) {
            this.postHandler.init(initContext, this);
        }
        this.eventTrigger.init(initContext, this);
        this.filterManager.init(initContext, this);
        if (this.runner != null) {
            this.runner.init(initContext, this);
        }
    }

    @Override
    public void destroy() {
        if (this.preHandler != null) {
            this.preHandler.destroy();
        }
        if (this.nodeList != null) {
            for (FlowNode flowNode : this.nodeList) {
                flowNode.destroy();
            }
        }
        if (this.postHandler != null) {
            this.postHandler.destroy();
        }
        this.eventTrigger.destroy();
        this.filterManager.destry();
        if (this.runner != null) {
            this.runner.destroy();
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<FlowNode> getNodeList() {
        return this.nodeList;
    }

    public void initNodeList(List<FlowNode> nodeList) {
        for (FlowNode node : nodeList) {
            this.addNode(node);
        }
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties.clear();
        this.putProperties(properties);
    }

    public void putProperties(Map<String, Object> properties) {
        if (properties == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            if (entry.getValue() == null) {
                this.properties.remove(entry.getKey());
                continue;
            }
            this.properties.put(entry.getKey(), entry.getValue());
        }
    }

    public Map<String, FlowNode> getNodeMap() {
        return this.nodeMap;
    }

    public void setProperty(String key, Object value) {
        if (value == null) {
            this.properties.remove(key);
        } else {
            this.properties.put(key, value);
        }
    }

    public <T> T getProperty(String key) {
        return (T)this.properties.get(key);
    }

    public void addNode(FlowNode node) {
        if (node.getId().startsWith(DOLLAR)) {
            throw new IllegalArgumentException("Node ID CANNOT start with $");
        }
        if (this.nodeList == null) {
            this.nodeList = new ArrayList<FlowNode>();
        }
        if (this.nodeMap == null) {
            this.nodeMap = new HashMap<String, FlowNode>();
        }
        if (this.nodeMap.containsKey(node.getId())) {
            throw new FlowException("Node:" + node.getId() + " duplicate");
        }
        if (this.nodeIndexMap == null) {
            this.nodeIndexMap = new HashMap<String, Integer>();
        }
        this.nodeList.add(node);
        this.nodeMap.put(node.getId(), node);
        this.nodeIndexMap.put(node.getId(), this.nodeList.size() - 1);
    }

    public void setNodeList(List<FlowNode> nodeList) {
        if (nodeList == null) {
            this.nodeList = null;
            this.nodeMap = null;
            this.nodeIndexMap = null;
        } else {
            this.nodeList = nodeList;
            this.nodeMap = new HashMap<String, FlowNode>();
            this.nodeIndexMap = new HashMap<String, Integer>();
            for (FlowNode node : nodeList) {
                this.nodeMap.put(node.getId(), node);
                this.nodeIndexMap.put(node.getId(), this.nodeList.size() - 1);
            }
        }
    }

    public FlowNode getNode(String nodeId) {
        return this.nodeMap.get(nodeId);
    }

    public int getNodeIndex(String nodeId) {
        return this.nodeIndexMap.get(nodeId);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FlowEventTrigger getEventTrigger() {
        return this.eventTrigger;
    }

    public void setEventTrigger(FlowEventTrigger eventTrigger) {
        this.eventTrigger = eventTrigger;
    }

    public void triggerEvent(String eventType, FlowContext context) {
        this.eventTrigger.triggerEvent(eventType, context);
    }

    public void triggerEvent(String eventType, Object eventData, FlowContext context, boolean catchThrowable) {
        this.eventTrigger.triggerEvent(eventType, eventData, context, catchThrowable);
    }

    public String[] getStartNodeIds() {
        return this.startNodeIds;
    }

    public void setStartNodeIds(String[] startNodeIds) {
        this.startNodeIds = startNodeIds;
    }

    public FlowRunner getRunner() {
        return this.runner;
    }

    public void setRunner(FlowRunner runner) {
        this.runner = runner;
    }

    public String stringify() {
        if (this.flowParser == null) {
            return null;
        }
        return this.flowParser.stringify(this);
    }

    public FlowParser getFlowParser() {
        return this.flowParser;
    }

    public void setFlowParser(FlowParser flowParser) {
        this.flowParser = flowParser;
    }

    public FlowPreHandler getPreHandler() {
        return this.preHandler;
    }

    public void setPreHandler(FlowPreHandler preHandler) {
        this.preHandler = preHandler;
    }

    public FlowPostHandler getPostHandler() {
        return this.postHandler;
    }

    public void setPostHandler(FlowPostHandler postHandler) {
        this.postHandler = postHandler;
    }

    public Boolean getLogFlag() {
        return this.logFlag;
    }

    public void setLogFlag(Boolean logFlag) {
        this.logFlag = logFlag;
    }

    public FlowFilterManager getFilterManager() {
        return this.filterManager;
    }

    public void setFilterManager(FlowFilterManager filterManager) {
        this.filterManager = filterManager;
    }
}

