/*
 * Decompiled with CFR 0.152.
 */
package com.jd.easyflow.flow.model;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class NodeContext
implements Serializable {
    private String nodeId;
    private NodeContext previousNode;
    private NodeContext[] nextNodes;
    private Boolean preResult;
    private Object actionResult;
    private Throwable throwable;
    private volatile Map<String, Object> dataMap;
    private Object nodeContext;

    public NodeContext(String nodeId) {
        this.nodeId = nodeId;
    }

    public Object getActionResult() {
        return this.actionResult;
    }

    protected void setActionResult(Object actionResult) {
        this.actionResult = actionResult;
    }

    public Map<String, Object> getDataMap() {
        return this.dataMap;
    }

    protected void setDataMap(Map<String, Object> dataMap) {
        this.dataMap = dataMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, Object value) {
        if (this.dataMap == null) {
            NodeContext nodeContext = this;
            synchronized (nodeContext) {
                if (this.dataMap == null) {
                    this.dataMap = new ConcurrentHashMap<String, Object>();
                }
            }
        }
        if (value == null) {
            this.dataMap.remove(key);
        } else {
            this.dataMap.put(key, value);
        }
    }

    public <T> T get(String key) {
        if (this.dataMap == null) {
            return null;
        }
        return (T)this.dataMap.get(key);
    }

    public void remove(String key) {
        this.dataMap.remove(key);
    }

    protected void setNextNodeIds(String[] nextNodeIds) {
        if (nextNodeIds == null) {
            this.nextNodes = null;
            return;
        }
        this.nextNodes = new NodeContext[nextNodeIds.length];
        for (int i = 0; i < nextNodeIds.length; ++i) {
            NodeContext nextNode = new NodeContext(nextNodeIds[i]);
            nextNode.setPreviousNode(this);
            this.nextNodes[i] = nextNode;
        }
    }

    protected void setNextNodes(NodeContext[] nextNodes) {
        this.nextNodes = nextNodes;
        if (nextNodes != null) {
            for (int i = 0; i < nextNodes.length; ++i) {
                nextNodes[i].setPreviousNode(this);
            }
        }
    }

    public NodeContext[] getNextNodes() {
        return this.nextNodes;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    protected void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public NodeContext getPreviousNode() {
        return this.previousNode;
    }

    protected void setPreviousNode(NodeContext previousNode) {
        this.previousNode = previousNode;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    protected void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public Boolean getPreResult() {
        return this.preResult;
    }

    protected void setPreResult(Boolean preResult) {
        this.preResult = preResult;
    }

    public <T> T getNodeContext() {
        return (T)this.nodeContext;
    }

    public void setNodeContext(Object nodeContext) {
        this.nodeContext = nodeContext;
    }
}

