/*
 * Decompiled with CFR 0.152.
 */
package com.jd.easyflow.flow.model.action;

import com.jd.easyflow.flow.engine.FlowContext;
import com.jd.easyflow.flow.exception.FlowException;
import com.jd.easyflow.flow.model.FlowNode;
import com.jd.easyflow.flow.model.InitContext;
import com.jd.easyflow.flow.model.NodeAction;
import com.jd.easyflow.flow.model.NodeContext;
import com.jd.easyflow.flow.model.NodeExecutor;
import com.jd.easyflow.flow.model.parser.param.ActionParseParam;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoopNodeAction
implements NodeAction {
    private static final Logger logger = LoggerFactory.getLogger(LoopNodeAction.class);
    private Boolean testBefore;
    private String loopConditionExp;
    private NodeExecutor<Boolean> loopConditionExecutor;
    private Long loopMaxCount;
    private String loopMaxCountExp;
    private NodeExecutor<Long> loopMaxCountExecutor;
    protected NodeAction loopAction;
    private String loopPreExp;
    private NodeExecutor<Object> loopPreExecutor;
    private String loopPostExp;
    private NodeExecutor<Object> loopPostExecutor;

    @Override
    public <T> T execute(NodeContext nodeContext, FlowContext context) {
        Long maximum = null;
        if (this.loopMaxCountExecutor != null) {
            maximum = this.loopMaxCountExecutor.execute(nodeContext, context);
        } else if (this.loopMaxCountExp != null) {
            maximum = ((Number)context.getElEvaluator().eval(this.loopMaxCountExp, nodeContext, context, null)).longValue();
        } else if (this.loopMaxCount != null) {
            maximum = this.loopMaxCount;
        }
        if (context.isLogOn() && logger.isDebugEnabled()) {
            logger.debug("Loop maximum:" + this.loopMaxCount);
        }
        if (maximum == null && this.loopConditionExp == null && this.loopConditionExecutor == null) {
            throw new FlowException("Loop maximum and condition can not both be null");
        }
        if (this.loopPreExecutor != null) {
            this.loopPreExecutor.execute(nodeContext, context);
        } else if (this.loopPreExp != null) {
            context.getElEvaluator().eval(this.loopPreExp, nodeContext, context, null);
        }
        for (long i = 0L; maximum == null || i < maximum; ++i) {
            boolean testResult;
            nodeContext.put("currentLoopIndex", i);
            if (this.testBefore.booleanValue() && (this.loopConditionExecutor != null ? !(testResult = this.loopConditionExecutor.execute(nodeContext, context).booleanValue()) : this.loopConditionExp != null && !(testResult = ((Boolean)context.getElEvaluator().eval(this.loopConditionExp, nodeContext, context, null)).booleanValue()))) break;
            this.loopAction.execute(nodeContext, context);
            if (!this.testBefore.booleanValue() && (this.loopConditionExecutor != null ? !(testResult = this.loopConditionExecutor.execute(nodeContext, context).booleanValue()) : this.loopConditionExp != null && !(testResult = ((Boolean)context.getElEvaluator().eval(this.loopConditionExp, nodeContext, context, null)).booleanValue()))) break;
        }
        if (this.loopPostExecutor != null) {
            this.loopPostExecutor.execute(nodeContext, context);
        } else if (this.loopPostExp != null) {
            context.getElEvaluator().eval(this.loopPostExp, nodeContext, context, null);
        }
        return null;
    }

    @Override
    public void init(InitContext initContext, Object parent) {
        Object loopActionConf;
        Object loopMaxCountConf;
        FlowNode node = (FlowNode)parent;
        this.testBefore = (Boolean)node.getProperty("loopTestBefore");
        if (this.testBefore == null) {
            throw new FlowException("Test before can not be null");
        }
        this.loopConditionExp = (String)node.getProperty("loopConditionExp");
        Map loopConditionExecutorConf = (Map)node.getProperty("loopConditionExecutor");
        if (loopConditionExecutorConf != null) {
            String createExp = (String)loopConditionExecutorConf.get("createExp");
            if (initContext.isParseEl() && createExp != null) {
                this.loopConditionExecutor = (NodeExecutor)initContext.getFlowParser().getElEvaluator().evalWithDefaultContext(createExp, initContext, false);
            }
        }
        this.loopPreExp = (String)node.getProperty("loopPreExp");
        Map loopPreExecutorConf = (Map)node.getProperty("loopPreExecutor");
        if (loopPreExecutorConf != null) {
            String createExp = (String)loopPreExecutorConf.get("createExp");
            if (initContext.isParseEl() && createExp != null) {
                this.loopPreExecutor = (NodeExecutor)initContext.getFlowParser().getElEvaluator().evalWithDefaultContext(createExp, initContext, false);
            }
        }
        this.loopPostExp = (String)node.getProperty("loopPostExp");
        Map loopPostExecutorConf = (Map)node.getProperty("loopPostExecutor");
        if (loopPostExecutorConf != null) {
            String createExp = (String)loopPostExecutorConf.get("createExp");
            if (initContext.isParseEl() && createExp != null) {
                this.loopPostExecutor = (NodeExecutor)initContext.getFlowParser().getElEvaluator().evalWithDefaultContext(createExp, initContext, false);
            }
        }
        if ((loopMaxCountConf = node.getProperty("loopMaxCount")) != null) {
            this.loopMaxCount = (long)this.loopMaxCount;
        }
        this.loopMaxCountExp = (String)node.getProperty("loopMaxCountExp");
        Map loopMaxCountExecutorConf = (Map)node.getProperty("loopMaxCountExecutor");
        if (loopMaxCountExecutorConf != null) {
            String createExp = (String)loopMaxCountExecutorConf.get("createExp");
            if (initContext.isParseEl() && createExp != null) {
                this.loopMaxCountExecutor = (NodeExecutor)initContext.getFlowParser().getElEvaluator().evalWithDefaultContext(createExp, initContext, false);
            }
        }
        if ((loopActionConf = node.getProperty("loopAction")) != null) {
            ActionParseParam param = new ActionParseParam(loopActionConf, initContext.getFlowList(), initContext.isParseEl(), initContext.getFlow(), node);
            this.loopAction = initContext.getFlowParser().parseNodeAction(param);
        }
        if (this.loopAction == null) {
            throw new FlowException("Loop node action can not be null");
        }
        this.loopAction.init(initContext, node);
        if (this.loopMaxCount == null && this.loopMaxCountExp == null && this.loopMaxCountExecutor == null && this.loopConditionExp == null && this.loopConditionExecutor == null) {
            throw new FlowException("Loop maximum and loop condition can not both be null");
        }
    }

    public NodeAction getLoopAction() {
        return this.loopAction;
    }

    public void setLoopAction(NodeAction loopAction) {
        this.loopAction = loopAction;
    }
}

