/*
 * Decompiled with CFR 0.152.
 */
package com.jd.easyflow.flow.model.action.compensate;

import com.jd.easyflow.flow.engine.FlowContext;
import com.jd.easyflow.flow.filter.FilterChain;
import com.jd.easyflow.flow.model.FlowNode;
import com.jd.easyflow.flow.model.NodeAction;
import com.jd.easyflow.flow.model.NodeContext;
import com.jd.easyflow.flow.model.NodeContextAccessor;
import com.jd.easyflow.flow.model.action.compensate.CompensateAction;
import com.jd.easyflow.flow.model.action.compensate.CompensateHelper;
import com.jd.easyflow.flow.model.filter.impl.BaseNodeFilter;
import com.jd.easyflow.flow.model.node.NodeImpl;
import com.jd.easyflow.flow.util.LockUtil;
import com.jd.easyflow.flow.util.Triple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompensateNodeFilter
extends BaseNodeFilter {
    private static final Logger logger = LoggerFactory.getLogger(CompensateNodeFilter.class);
    private static final String CTX_COMENSATED_END_NODES_LOCK_KEY = "_compensated_end_nodes_lock";
    private static final String NODE_CTX_COMENSATING_LOCK_KEY = "_compensating_lock";

    public CompensateNodeFilter() {
    }

    public CompensateNodeFilter(int order) {
        this.order = order;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeContext doFilter(Triple<FlowNode, NodeContext, FlowContext> request, FilterChain<Triple<FlowNode, NodeContext, FlowContext>, NodeContext> chain) {
        Object lockObj;
        FlowContext context = request.getRight();
        NodeContext nodeContext = request.getMiddle();
        if (!Boolean.TRUE.equals(nodeContext.get("_compensateNodeFlag"))) {
            NodeContext newNodeContext = chain.doFilter(request);
            if (CompensateHelper.isCompensating(context)) {
                ArrayList<NodeContext> compensatedNextNodes = new ArrayList<NodeContext>();
                compensatedNextNodes.add(CompensateHelper.createCompensateNode(newNodeContext));
                if (!Boolean.TRUE.equals(context.get("_compensateEndNodesFlag"))) {
                    Object lockObj2;
                    Object object = lockObj2 = LockUtil.getFlowContextLock(CTX_COMENSATED_END_NODES_LOCK_KEY, context);
                    synchronized (object) {
                        if (!Boolean.TRUE.equals(context.get("_compensateEndNodesFlag"))) {
                            HashSet<NodeContext> endNodes = new HashSet<NodeContext>();
                            this.getEndNodes(context.getStartNodes().toArray(new NodeContext[context.getStartNodes().size()]), endNodes);
                            for (NodeContext endNode : endNodes) {
                                compensatedNextNodes.add(CompensateHelper.createCompensateNode(endNode));
                            }
                            context.put("_compensateEndNodesFlag", true);
                        }
                        NodeContextAccessor.setNextNodes(newNodeContext, compensatedNextNodes.toArray(new NodeContext[compensatedNextNodes.size()]));
                    }
                }
            }
            newNodeContext.put(CompensateNodeFilter.class.getName(), true);
            return newNodeContext;
        }
        NodeImpl nodeImpl = (NodeImpl)context.getFlow().getNode(nodeContext.getNodeId());
        NodeContext originNodeCtx = (NodeContext)nodeContext.get("_compensateFor");
        Object object = lockObj = LockUtil.getNodeContextLock(NODE_CTX_COMENSATING_LOCK_KEY, originNodeCtx);
        synchronized (object) {
            if (Boolean.TRUE.equals(originNodeCtx.get("_compensatingFlag"))) {
                if (context.isLogOn() && logger.isInfoEnabled()) {
                    logger.info("Node:" + originNodeCtx.getNodeId() + "has been compensated, return");
                }
                return nodeContext;
            }
            List<NodeContext> originNextNodes = (List<NodeContext>)originNodeCtx.get("_nextNodes");
            if (originNextNodes == null && originNodeCtx.getNextNodes() != null) {
                originNextNodes = Arrays.asList(originNodeCtx.getNextNodes());
            }
            if (originNextNodes != null && originNextNodes.size() > 0) {
                String notCompensated = null;
                for (NodeContext next : originNextNodes) {
                    if (Boolean.TRUE.equals(next.get("_compensateNodeFlag")) || Boolean.TRUE.equals(next.get("_compensatedFlag"))) continue;
                    notCompensated = next.getNodeId();
                    break;
                }
                if (notCompensated != null) {
                    if (context.isLogOn() && logger.isInfoEnabled()) {
                        logger.info("Next nodes of " + originNodeCtx.getNodeId() + " not all compensated:" + notCompensated);
                    }
                    return nodeContext;
                }
            }
            originNodeCtx.put("_compensatingFlag", true);
        }
        if (Boolean.FALSE.equals(originNodeCtx.getPreResult())) {
            if (context.isLogOn() && logger.isInfoEnabled()) {
                logger.info("Node:" + originNodeCtx.getNodeId() + " pre result is false, skip compensate action.");
            }
        } else {
            NodeAction nodeAction = nodeImpl.getAction();
            Object compensateResult = null;
            NodeAction compensateNodeAction = (NodeAction)nodeImpl.getProperty("_$compensateAction");
            if (compensateNodeAction != null) {
                if (context.isLogOn() && logger.isInfoEnabled()) {
                    logger.info("Compensate using NodeAction:" + compensateNodeAction.getClass());
                }
                compensateResult = compensateNodeAction.execute(nodeContext, context);
            } else if (nodeAction instanceof CompensateAction) {
                if (context.isLogOn() && logger.isInfoEnabled()) {
                    logger.info("Compensate using CompensateAction");
                }
                compensateResult = ((CompensateAction)((Object)nodeAction)).compensate(nodeContext, context);
            }
            NodeContextAccessor.setActionResult(nodeContext, compensateResult);
        }
        originNodeCtx.put("_compensatedFlag", true);
        List previousList = (List)originNodeCtx.get("_previousNodes");
        if (previousList != null) {
            if (previousList.size() == 0) {
                NodeContextAccessor.setNextNodes(nodeContext, null);
            } else {
                NodeContext[] previouses = new NodeContext[previousList.size()];
                for (int i = 0; i < previousList.size(); ++i) {
                    previouses[i] = CompensateHelper.createCompensateNode((NodeContext)previousList.get(i));
                }
                NodeContextAccessor.setNextNodes(nodeContext, previouses);
            }
        } else if (originNodeCtx.getPreviousNode() != null) {
            NodeContextAccessor.setNextNodes(nodeContext, new NodeContext[]{CompensateHelper.createCompensateNode(originNodeCtx.getPreviousNode())});
        } else {
            NodeContextAccessor.setNextNodes(nodeContext, null);
        }
        return nodeContext;
    }

    private void getEndNodes(NodeContext[] nodes, Set<NodeContext> result) {
        if (nodes == null || nodes.length == 0) {
            return;
        }
        for (NodeContext node : nodes) {
            if (!Boolean.TRUE.equals(node.get(CompensateNodeFilter.class.getName()))) continue;
            if (node.getNextNodes() == null || node.getNextNodes().length == 0) {
                result.add(node);
                continue;
            }
            this.getEndNodes(node.getNextNodes(), result);
        }
    }
}

