/*
 * Decompiled with CFR 0.152.
 */
package com.jd.easyflow.flow.model.filter;

import com.jd.easyflow.flow.engine.FlowContext;
import com.jd.easyflow.flow.engine.FlowResult;
import com.jd.easyflow.flow.filter.Filter;
import com.jd.easyflow.flow.filter.FilterChainImpl;
import com.jd.easyflow.flow.model.Flow;
import com.jd.easyflow.flow.model.FlowNode;
import com.jd.easyflow.flow.model.InitContext;
import com.jd.easyflow.flow.model.NodeContext;
import com.jd.easyflow.flow.util.Pair;
import com.jd.easyflow.flow.util.Triple;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class FlowFilterManager {
    private List<Filter<FlowContext, FlowResult>> filters;
    private List<Filter<Triple<FlowNode, NodeContext, FlowContext>, NodeContext>> nodeFilters;
    private List<Filter<Pair<NodeContext, FlowContext>, Object>> nodeActionFilters;
    private List<Filter<Pair<NodeContext, FlowContext>, Boolean>> nodePreHandlerFilters;
    private List<Filter<Pair<NodeContext, FlowContext>, NodeContext[]>> nodePostHandlerFilters;
    private List<Filter<FlowContext, Boolean>> flowPreHandlerFilters;
    private List<Filter<FlowContext, Void>> flowPostHandlerFilters;
    private List<Filter<FlowContext, FlowResult>> innerFilters;
    private List<Filter<FlowContext, FlowResult>> outerFilters;
    private List<Filter<Triple<FlowNode, NodeContext, FlowContext>, NodeContext>> innerNodeFilters;
    private List<Filter<Triple<FlowNode, NodeContext, FlowContext>, NodeContext>> outerNodeFilters;
    private List<Filter<Pair<NodeContext, FlowContext>, Object>> innerNodeActionFilters;
    private List<Filter<Pair<NodeContext, FlowContext>, Object>> outerNodeActionFilters;
    private List<Filter<Pair<NodeContext, FlowContext>, Boolean>> innerNodePreHandlerFilters;
    private List<Filter<Pair<NodeContext, FlowContext>, Boolean>> outerNodePreHandlerFilters;
    private List<Filter<Pair<NodeContext, FlowContext>, NodeContext[]>> innerNodePostHandlerFilters;
    private List<Filter<Pair<NodeContext, FlowContext>, NodeContext[]>> outerNodePostHandlerFilters;
    private List<Filter<FlowContext, Boolean>> innerFlowPreHandlerFilters;
    private List<Filter<FlowContext, Boolean>> outerFlowPreHandlerFilters;
    private List<Filter<FlowContext, Void>> innerFlowPostHandlerFilters;
    private List<Filter<FlowContext, Void>> outerFlowPostHandlerFilters;

    public void init(InitContext initContext, Flow flow) {
        if (this.filters != null) {
            for (Filter<Object, Serializable> filter : this.filters) {
                filter.init(initContext, flow);
            }
            this.refeshFilters();
        }
        if (this.nodeFilters != null) {
            for (Filter<Object, Object> filter : this.nodeFilters) {
                filter.init(initContext, flow);
            }
            this.refreshNodeFilters();
        }
        if (this.nodeActionFilters != null) {
            for (Filter<Object, Object> filter : this.nodeActionFilters) {
                filter.init(initContext, flow);
            }
            this.refeshNodeActionFilters();
        }
        if (this.nodePreHandlerFilters != null) {
            for (Filter<Object, Object> filter : this.nodePreHandlerFilters) {
                filter.init(initContext, flow);
            }
            this.refreshNodePreHandlerFilters();
        }
        if (this.nodePostHandlerFilters != null) {
            for (Filter<Object, Object> filter : this.nodePostHandlerFilters) {
                filter.init(initContext, flow);
            }
            this.refeshNodePostHandlerFilters();
        }
        if (this.flowPreHandlerFilters != null) {
            for (Filter<Object, Object> filter : this.flowPreHandlerFilters) {
                filter.init(initContext, flow);
            }
            this.refreshFlowPreHandlerFilters();
        }
        if (this.flowPostHandlerFilters != null) {
            for (Filter<Object, Object> filter : this.flowPostHandlerFilters) {
                filter.init(initContext, flow);
            }
            this.refreshFlowPostHandlerFilters();
        }
    }

    public void destry() {
        if (this.filters != null) {
            for (Filter<Object, Serializable> filter : this.filters) {
                filter.destroy();
            }
        }
        if (this.nodeFilters != null) {
            for (Filter<Object, Object> filter : this.nodeFilters) {
                filter.destroy();
            }
        }
        if (this.nodeActionFilters != null) {
            for (Filter<Object, Object> filter : this.nodeActionFilters) {
                filter.destroy();
            }
        }
        if (this.nodePreHandlerFilters != null) {
            for (Filter<Object, Object> filter : this.nodePreHandlerFilters) {
                filter.destroy();
            }
        }
        if (this.nodePostHandlerFilters != null) {
            for (Filter<Object, Object> filter : this.nodePostHandlerFilters) {
                filter.destroy();
            }
        }
        if (this.flowPreHandlerFilters != null) {
            for (Filter<Object, Object> filter : this.flowPreHandlerFilters) {
                filter.destroy();
            }
        }
        if (this.flowPostHandlerFilters != null) {
            for (Filter<Object, Object> filter : this.flowPostHandlerFilters) {
                filter.destroy();
            }
        }
    }

    public List<Filter<FlowContext, FlowResult>> getFilters() {
        return this.filters;
    }

    public List<Filter<FlowContext, FlowResult>> getInnerFilters() {
        return this.innerFilters;
    }

    public List<Filter<FlowContext, FlowResult>> getOuterFilters() {
        return this.outerFilters;
    }

    public void setFilters(List<Filter<FlowContext, FlowResult>> filters) {
        this.filters = filters;
        this.refeshFilters();
    }

    private void refeshFilters() {
        if (this.filters == null) {
            this.outerFilters = null;
            this.innerFilters = null;
        } else {
            this.innerFilters = new ArrayList<Filter<FlowContext, FlowResult>>();
            this.outerFilters = new ArrayList<Filter<FlowContext, FlowResult>>();
            for (Filter<FlowContext, FlowResult> filter : this.filters) {
                this.addFilter(filter, this.innerFilters, this.outerFilters);
            }
        }
    }

    public void addFilter(Filter<FlowContext, FlowResult> filter) {
        if (this.filters == null) {
            this.filters = new ArrayList<Filter<FlowContext, FlowResult>>();
            this.innerFilters = new ArrayList<Filter<FlowContext, FlowResult>>();
            this.outerFilters = new ArrayList<Filter<FlowContext, FlowResult>>();
        }
        this.filters.add(filter);
        this.addFilter(filter, this.innerFilters, this.outerFilters);
    }

    public boolean noOuterFilter() {
        return this.outerFilters == null || this.outerFilters.size() == 0;
    }

    public FlowResult doOuterFilter(FlowContext context, Function<FlowContext, FlowResult> outerInvoker) {
        FilterChainImpl<FlowContext, FlowResult> chain = new FilterChainImpl<FlowContext, FlowResult>(this.outerFilters, outerInvoker);
        return (FlowResult)chain.doFilter(context);
    }

    public boolean noInnerFilter() {
        return this.innerFilters == null || this.innerFilters.size() == 0;
    }

    public FlowResult doInnerFilter(FlowContext context, Function<FlowContext, FlowResult> innerInvoker) {
        FilterChainImpl<FlowContext, FlowResult> chain = new FilterChainImpl<FlowContext, FlowResult>(this.innerFilters, innerInvoker);
        return (FlowResult)chain.doFilter(context);
    }

    public List<Filter<Triple<FlowNode, NodeContext, FlowContext>, NodeContext>> getNodeFilters() {
        return this.nodeFilters;
    }

    public List<Filter<Triple<FlowNode, NodeContext, FlowContext>, NodeContext>> getInnerNodeFilters() {
        return this.innerNodeFilters;
    }

    public List<Filter<Triple<FlowNode, NodeContext, FlowContext>, NodeContext>> getOuterNodeFilters() {
        return this.outerNodeFilters;
    }

    public void setNodeFilters(List<Filter<Triple<FlowNode, NodeContext, FlowContext>, NodeContext>> nodeFilters) {
        this.nodeFilters = nodeFilters;
        this.refreshNodeFilters();
    }

    private void refreshNodeFilters() {
        if (this.nodeFilters.size() == 0) {
            this.outerNodeFilters = null;
            this.innerNodeFilters = null;
        } else {
            this.innerNodeFilters = new ArrayList<Filter<Triple<FlowNode, NodeContext, FlowContext>, NodeContext>>();
            this.outerNodeFilters = new ArrayList<Filter<Triple<FlowNode, NodeContext, FlowContext>, NodeContext>>();
            for (Filter<Triple<FlowNode, NodeContext, FlowContext>, NodeContext> filter : this.nodeFilters) {
                this.addFilter(filter, this.innerNodeFilters, this.outerNodeFilters);
            }
        }
    }

    public void addNodeFilter(Filter<Triple<FlowNode, NodeContext, FlowContext>, NodeContext> filter) {
        if (this.nodeFilters == null) {
            this.nodeFilters = new ArrayList<Filter<Triple<FlowNode, NodeContext, FlowContext>, NodeContext>>();
            this.innerNodeFilters = new ArrayList<Filter<Triple<FlowNode, NodeContext, FlowContext>, NodeContext>>();
            this.outerNodeFilters = new ArrayList<Filter<Triple<FlowNode, NodeContext, FlowContext>, NodeContext>>();
        }
        this.nodeFilters.add(filter);
        this.addFilter(filter, this.innerNodeFilters, this.outerNodeFilters);
    }

    public boolean noOuterNodeFilter() {
        return this.outerNodeFilters == null || this.outerNodeFilters.size() == 0;
    }

    public NodeContext doOuterNodeFilter(Triple<FlowNode, NodeContext, FlowContext> p, Function<Triple<FlowNode, NodeContext, FlowContext>, NodeContext> outerNodeInvoker) {
        FilterChainImpl<Triple<FlowNode, NodeContext, FlowContext>, NodeContext> chain = new FilterChainImpl<Triple<FlowNode, NodeContext, FlowContext>, NodeContext>(this.outerNodeFilters, outerNodeInvoker);
        return (NodeContext)chain.doFilter(p);
    }

    public boolean noInnerNodeFilter() {
        return this.innerNodeFilters == null || this.innerNodeFilters.size() == 0;
    }

    public NodeContext doInnerNodeFilter(Triple<FlowNode, NodeContext, FlowContext> p, Function<Triple<FlowNode, NodeContext, FlowContext>, NodeContext> innerNodeInvoker) {
        FilterChainImpl<Triple<FlowNode, NodeContext, FlowContext>, NodeContext> chain = new FilterChainImpl<Triple<FlowNode, NodeContext, FlowContext>, NodeContext>(this.innerNodeFilters, innerNodeInvoker);
        return (NodeContext)chain.doFilter(p);
    }

    public List<Filter<Pair<NodeContext, FlowContext>, Object>> getNodeActionFilters() {
        return this.nodeActionFilters;
    }

    public List<Filter<Pair<NodeContext, FlowContext>, Object>> getInnerNodeActionFilters() {
        return this.innerNodeActionFilters;
    }

    public List<Filter<Pair<NodeContext, FlowContext>, Object>> getOuterNodeActionFilters() {
        return this.outerNodeActionFilters;
    }

    public void setNodeActionFilters(List<Filter<Pair<NodeContext, FlowContext>, Object>> nodeActionFilters) {
        this.nodeActionFilters = nodeActionFilters;
        this.refeshNodeActionFilters();
    }

    private void refeshNodeActionFilters() {
        if (this.nodeActionFilters == null) {
            this.outerNodeActionFilters = null;
            this.innerNodeActionFilters = null;
        } else {
            this.innerNodeActionFilters = new ArrayList<Filter<Pair<NodeContext, FlowContext>, Object>>();
            this.outerNodeActionFilters = new ArrayList<Filter<Pair<NodeContext, FlowContext>, Object>>();
            for (Filter<Pair<NodeContext, FlowContext>, Object> filter : this.nodeActionFilters) {
                this.addFilter(filter, this.innerNodeActionFilters, this.outerNodeActionFilters);
            }
        }
    }

    public void addNodeActionFilter(Filter<Pair<NodeContext, FlowContext>, Object> filter) {
        if (this.nodeActionFilters == null) {
            this.nodeActionFilters = new ArrayList<Filter<Pair<NodeContext, FlowContext>, Object>>();
            this.innerNodeActionFilters = new ArrayList<Filter<Pair<NodeContext, FlowContext>, Object>>();
            this.outerNodeActionFilters = new ArrayList<Filter<Pair<NodeContext, FlowContext>, Object>>();
        }
        this.nodeActionFilters.add(filter);
        this.addFilter(filter, this.innerNodeActionFilters, this.outerNodeActionFilters);
    }

    public boolean noOuterNodeActionFilter() {
        return this.outerNodeActionFilters == null || this.outerNodeActionFilters.size() == 0;
    }

    public Object doOuterNodeActionFilter(Pair<NodeContext, FlowContext> p, Function<Pair<NodeContext, FlowContext>, Object> outerNodeActionInvoker) {
        FilterChainImpl<Pair<NodeContext, FlowContext>, Object> chain = new FilterChainImpl<Pair<NodeContext, FlowContext>, Object>(this.outerNodeActionFilters, outerNodeActionInvoker);
        return chain.doFilter(p);
    }

    public boolean noInnerNodeActionFilter() {
        return this.innerNodeActionFilters == null || this.innerNodeActionFilters.size() == 0;
    }

    public Object doInnerNodeActionFilter(Pair<NodeContext, FlowContext> p, Function<Pair<NodeContext, FlowContext>, Object> innerNodeActionInvoker) {
        FilterChainImpl<Pair<NodeContext, FlowContext>, Object> chain = new FilterChainImpl<Pair<NodeContext, FlowContext>, Object>(this.innerNodeActionFilters, innerNodeActionInvoker);
        return chain.doFilter(p);
    }

    public List<Filter<Pair<NodeContext, FlowContext>, Boolean>> getNodePreHandlerFilters() {
        return this.nodePreHandlerFilters;
    }

    public List<Filter<Pair<NodeContext, FlowContext>, Boolean>> getInnerNodePreHandlerFilters() {
        return this.innerNodePreHandlerFilters;
    }

    public List<Filter<Pair<NodeContext, FlowContext>, Boolean>> getOuterNodePreHandlerFilters() {
        return this.outerNodePreHandlerFilters;
    }

    public void setNodePreHandlerFilters(List<Filter<Pair<NodeContext, FlowContext>, Boolean>> nodePreHandlerFilters) {
        this.nodePreHandlerFilters = nodePreHandlerFilters;
        this.refeshNodeActionFilters();
    }

    private void refreshNodePreHandlerFilters() {
        if (this.nodePreHandlerFilters == null) {
            this.outerNodePreHandlerFilters = null;
            this.innerNodePreHandlerFilters = null;
        } else {
            this.innerNodePreHandlerFilters = new ArrayList<Filter<Pair<NodeContext, FlowContext>, Boolean>>();
            this.outerNodePreHandlerFilters = new ArrayList<Filter<Pair<NodeContext, FlowContext>, Boolean>>();
            for (Filter<Pair<NodeContext, FlowContext>, Boolean> filter : this.nodePreHandlerFilters) {
                this.addFilter(filter, this.innerNodePreHandlerFilters, this.outerNodePreHandlerFilters);
            }
        }
    }

    public void addNodePreHandlerFilter(Filter<Pair<NodeContext, FlowContext>, Boolean> filter) {
        if (this.nodePreHandlerFilters == null) {
            this.nodePreHandlerFilters = new ArrayList<Filter<Pair<NodeContext, FlowContext>, Boolean>>();
            this.innerNodePreHandlerFilters = new ArrayList<Filter<Pair<NodeContext, FlowContext>, Boolean>>();
            this.outerNodePreHandlerFilters = new ArrayList<Filter<Pair<NodeContext, FlowContext>, Boolean>>();
        }
        this.nodePreHandlerFilters.add(filter);
        this.addFilter(filter, this.innerNodePreHandlerFilters, this.outerNodePreHandlerFilters);
    }

    public boolean noOuterNodePreHandlerFilter() {
        return this.outerNodePreHandlerFilters == null || this.outerNodePreHandlerFilters.size() == 0;
    }

    public Boolean doOuterNodePreHandlerFilter(Pair<NodeContext, FlowContext> p, Function<Pair<NodeContext, FlowContext>, Boolean> outerNodePreHandlerInvoker) {
        FilterChainImpl<Pair<NodeContext, FlowContext>, Boolean> chain = new FilterChainImpl<Pair<NodeContext, FlowContext>, Boolean>(this.outerNodePreHandlerFilters, outerNodePreHandlerInvoker);
        return (Boolean)chain.doFilter(p);
    }

    public boolean noInnerNodePreHandlerFilter() {
        return this.innerNodePreHandlerFilters == null || this.innerNodePreHandlerFilters.size() == 0;
    }

    public Boolean doInnerNodePreHandlerFilter(Pair<NodeContext, FlowContext> p, Function<Pair<NodeContext, FlowContext>, Boolean> innerNodePreHandlerInvoker) {
        FilterChainImpl<Pair<NodeContext, FlowContext>, Boolean> chain = new FilterChainImpl<Pair<NodeContext, FlowContext>, Boolean>(this.innerNodePreHandlerFilters, innerNodePreHandlerInvoker);
        return (Boolean)chain.doFilter(p);
    }

    public List<Filter<Pair<NodeContext, FlowContext>, NodeContext[]>> getNodePostHandlerFilters() {
        return this.nodePostHandlerFilters;
    }

    public List<Filter<Pair<NodeContext, FlowContext>, NodeContext[]>> getInnerNodePostHandlerFilters() {
        return this.innerNodePostHandlerFilters;
    }

    public List<Filter<Pair<NodeContext, FlowContext>, NodeContext[]>> getOuterNodePostHandlerFilters() {
        return this.outerNodePostHandlerFilters;
    }

    public void setNodePostHandlerFilters(List<Filter<Pair<NodeContext, FlowContext>, NodeContext[]>> nodePostHandlerFilters) {
        this.nodePostHandlerFilters = nodePostHandlerFilters;
        this.refeshNodePostHandlerFilters();
    }

    private void refeshNodePostHandlerFilters() {
        if (this.nodePostHandlerFilters == null) {
            this.outerNodePostHandlerFilters = null;
            this.innerNodePostHandlerFilters = null;
        } else {
            this.innerNodePostHandlerFilters = new ArrayList<Filter<Pair<NodeContext, FlowContext>, NodeContext[]>>();
            this.outerNodePostHandlerFilters = new ArrayList<Filter<Pair<NodeContext, FlowContext>, NodeContext[]>>();
            for (Filter<Pair<NodeContext, FlowContext>, NodeContext[]> filter : this.nodePostHandlerFilters) {
                this.addFilter(filter, this.innerNodePostHandlerFilters, this.outerNodePostHandlerFilters);
            }
        }
    }

    public void addNodePostHandlerFilter(Filter<Pair<NodeContext, FlowContext>, NodeContext[]> filter) {
        if (this.nodePostHandlerFilters == null) {
            this.nodePostHandlerFilters = new ArrayList<Filter<Pair<NodeContext, FlowContext>, NodeContext[]>>();
            this.innerNodePostHandlerFilters = new ArrayList<Filter<Pair<NodeContext, FlowContext>, NodeContext[]>>();
            this.outerNodePostHandlerFilters = new ArrayList<Filter<Pair<NodeContext, FlowContext>, NodeContext[]>>();
        }
        this.nodePostHandlerFilters.add(filter);
        this.addFilter(filter, this.innerNodePostHandlerFilters, this.outerNodePostHandlerFilters);
    }

    public boolean noOuterNodePostHandlerFilter() {
        return this.outerNodePostHandlerFilters == null || this.outerNodePostHandlerFilters.size() == 0;
    }

    public NodeContext[] doOuterNodePostHandlerFilter(Pair<NodeContext, FlowContext> p, Function<Pair<NodeContext, FlowContext>, NodeContext[]> outerNodePostHandlerInvoker) {
        FilterChainImpl<Pair<NodeContext, FlowContext>, NodeContext[]> chain = new FilterChainImpl<Pair<NodeContext, FlowContext>, NodeContext[]>(this.outerNodePostHandlerFilters, outerNodePostHandlerInvoker);
        return (NodeContext[])chain.doFilter(p);
    }

    public boolean noInnerNodePostHandlerFilter() {
        return this.innerNodePostHandlerFilters == null || this.innerNodePostHandlerFilters.size() == 0;
    }

    public NodeContext[] doInnerNodePostHandlerFilter(Pair<NodeContext, FlowContext> p, Function<Pair<NodeContext, FlowContext>, NodeContext[]> innerNodePostHandlerInvoker) {
        FilterChainImpl<Pair<NodeContext, FlowContext>, NodeContext[]> chain = new FilterChainImpl<Pair<NodeContext, FlowContext>, NodeContext[]>(this.innerNodePostHandlerFilters, innerNodePostHandlerInvoker);
        return (NodeContext[])chain.doFilter(p);
    }

    public List<Filter<FlowContext, Boolean>> getFlowPreHandlerFilters() {
        return this.flowPreHandlerFilters;
    }

    public List<Filter<FlowContext, Boolean>> getInnerFlowPreHandlerFilters() {
        return this.innerFlowPreHandlerFilters;
    }

    public List<Filter<FlowContext, Boolean>> getOuterFlowPreHandlerFilters() {
        return this.outerFlowPreHandlerFilters;
    }

    public void setFlowPreHandlerFilters(List<Filter<FlowContext, Boolean>> flowPreHandlerFilters) {
        this.flowPreHandlerFilters = flowPreHandlerFilters;
        this.refreshFlowPreHandlerFilters();
    }

    private void refreshFlowPreHandlerFilters() {
        if (this.flowPreHandlerFilters == null) {
            this.outerFlowPreHandlerFilters = null;
            this.innerFlowPreHandlerFilters = null;
        } else {
            this.innerFlowPreHandlerFilters = new ArrayList<Filter<FlowContext, Boolean>>();
            this.outerFlowPreHandlerFilters = new ArrayList<Filter<FlowContext, Boolean>>();
            for (Filter<FlowContext, Boolean> filter : this.flowPreHandlerFilters) {
                this.addFilter(filter, this.innerFlowPreHandlerFilters, this.outerFlowPreHandlerFilters);
            }
        }
    }

    public void addFlowPreHandlerFilter(Filter<FlowContext, Boolean> filter) {
        if (this.flowPreHandlerFilters == null) {
            this.flowPreHandlerFilters = new ArrayList<Filter<FlowContext, Boolean>>();
            this.innerFlowPreHandlerFilters = new ArrayList<Filter<FlowContext, Boolean>>();
            this.outerFlowPreHandlerFilters = new ArrayList<Filter<FlowContext, Boolean>>();
        }
        this.flowPreHandlerFilters.add(filter);
        this.addFilter(filter, this.innerFlowPreHandlerFilters, this.outerFlowPostHandlerFilters);
    }

    public boolean noOuterFlowPreHandlerFilter() {
        return this.outerFlowPreHandlerFilters == null || this.outerFlowPreHandlerFilters.size() == 0;
    }

    public Boolean doOuterFlowPreHandlerFilter(FlowContext context, Function<FlowContext, Boolean> outerFlowPreHandlerInvoker) {
        FilterChainImpl<FlowContext, Boolean> chain = new FilterChainImpl<FlowContext, Boolean>(this.outerFlowPreHandlerFilters, outerFlowPreHandlerInvoker);
        return (Boolean)chain.doFilter(context);
    }

    public boolean noInnerFlowPreHandlerFilter() {
        return this.innerFlowPreHandlerFilters == null || this.innerFlowPreHandlerFilters.size() == 0;
    }

    public Boolean doInnerFlowPreHandlerFilter(FlowContext context, Function<FlowContext, Boolean> innerFlowPreHandlerInvoker) {
        FilterChainImpl<FlowContext, Boolean> chain = new FilterChainImpl<FlowContext, Boolean>(this.innerFlowPreHandlerFilters, innerFlowPreHandlerInvoker);
        return (Boolean)chain.doFilter(context);
    }

    public List<Filter<FlowContext, Void>> getFlowPostHandlerFilters() {
        return this.flowPostHandlerFilters;
    }

    public List<Filter<FlowContext, Void>> getInnerFlowPostHandlerFilters() {
        return this.innerFlowPostHandlerFilters;
    }

    public List<Filter<FlowContext, Void>> getOuterFlowPostHandlerFilters() {
        return this.outerFlowPostHandlerFilters;
    }

    public void setFlowPostHandlerFilters(List<Filter<FlowContext, Void>> flowPostHandlerFilters) {
        this.flowPostHandlerFilters = flowPostHandlerFilters;
        this.refreshFlowPostHandlerFilters();
    }

    private void refreshFlowPostHandlerFilters() {
        if (this.flowPostHandlerFilters == null) {
            this.outerFlowPostHandlerFilters = null;
            this.innerFlowPostHandlerFilters = null;
        } else {
            this.innerFlowPostHandlerFilters = new ArrayList<Filter<FlowContext, Void>>();
            this.outerFlowPostHandlerFilters = new ArrayList<Filter<FlowContext, Void>>();
            for (Filter<FlowContext, Void> filter : this.flowPostHandlerFilters) {
                this.addFilter(filter, this.innerFlowPostHandlerFilters, this.outerFlowPostHandlerFilters);
            }
        }
    }

    public void addFlowPostHandlerFilter(Filter<FlowContext, Void> filter) {
        if (this.flowPostHandlerFilters == null) {
            this.flowPostHandlerFilters = new ArrayList<Filter<FlowContext, Void>>();
            this.innerFlowPostHandlerFilters = new ArrayList<Filter<FlowContext, Void>>();
            this.outerFlowPostHandlerFilters = new ArrayList<Filter<FlowContext, Void>>();
        }
        this.flowPostHandlerFilters.add(filter);
        this.addFilter(filter, this.innerFlowPostHandlerFilters, this.outerFlowPostHandlerFilters);
    }

    public boolean noOuterFlowPostHandlerFilter() {
        return this.outerFlowPostHandlerFilters == null || this.outerFlowPostHandlerFilters.size() == 0;
    }

    public Void doOuterFlowPostHandlerFilter(FlowContext context, Function<FlowContext, Void> outerFlowPostHandlerInvoker) {
        FilterChainImpl<FlowContext, Void> chain = new FilterChainImpl<FlowContext, Void>(this.outerFlowPostHandlerFilters, outerFlowPostHandlerInvoker);
        return (Void)chain.doFilter(context);
    }

    public boolean noInnerFlowPostHandlerFilter() {
        return this.innerFlowPostHandlerFilters == null || this.innerFlowPostHandlerFilters.size() == 0;
    }

    public Void doInnerFlowPostHandlerFilter(FlowContext context, Function<FlowContext, Void> innerFlowPostHandlerInvoker) {
        FilterChainImpl<FlowContext, Void> chain = new FilterChainImpl<FlowContext, Void>(this.innerFlowPostHandlerFilters, innerFlowPostHandlerInvoker);
        return (Void)chain.doFilter(context);
    }

    private void addFilter(Filter filter, List innerFilters, List outerFilters) {
        int pos;
        int filterOrder = filter.getOrder();
        if (filterOrder < 0) {
            for (pos = 0; pos < innerFilters.size() && ((Filter)innerFilters.get(pos)).getOrder() >= filterOrder; ++pos) {
            }
            innerFilters.add(pos, filter);
        } else {
            while (pos < outerFilters.size() && ((Filter)outerFilters.get(pos)).getOrder() >= filterOrder) {
                ++pos;
            }
            outerFilters.add(pos, filter);
        }
    }
}

