/*
 * Decompiled with CFR 0.152.
 */
package com.jd.easyflow.flow.model.node;

import com.jd.easyflow.flow.engine.FlowContext;
import com.jd.easyflow.flow.model.FlowNode;
import com.jd.easyflow.flow.model.InitContext;
import com.jd.easyflow.flow.model.NodeAction;
import com.jd.easyflow.flow.model.NodeContext;
import com.jd.easyflow.flow.model.NodeContextAccessor;
import com.jd.easyflow.flow.model.NodePostHandler;
import com.jd.easyflow.flow.model.NodePreHandler;
import com.jd.easyflow.flow.util.Pair;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class NodeImpl
implements FlowNode {
    protected String id;
    protected String name;
    protected Map<String, Object> properties = new ConcurrentHashMap<String, Object>();
    protected NodePreHandler preHandler;
    protected NodeAction action;
    protected NodePostHandler postHandler;
    private Function<Pair<NodeContext, FlowContext>, Boolean> outerNodePreHandlerInvoker = p -> this.invokePreHandler((NodeContext)p.getLeft(), (FlowContext)p.getRight());
    private Function<Pair<NodeContext, FlowContext>, Boolean> innerNodePreHandlerInvoker = p -> this.preHandler.preHandle((NodeContext)p.getLeft(), (FlowContext)p.getRight());
    private Function<Pair<NodeContext, FlowContext>, Object> outerNodeActionInvoker = p -> this.invokeAction((NodeContext)p.getLeft(), (FlowContext)p.getRight());
    private Function<Pair<NodeContext, FlowContext>, Object> innerNodeActionInvoker = p -> this.action.execute((NodeContext)p.getLeft(), (FlowContext)p.getRight());
    private Function<Pair<NodeContext, FlowContext>, NodeContext[]> outerNodePostHandlerInvoker = p -> this.invokePostHandler((NodeContext)p.getLeft(), (FlowContext)p.getRight());
    private Function<Pair<NodeContext, FlowContext>, NodeContext[]> innerNodePostHandlerInvoker = p -> this.postHandler.postHandle((NodeContext)p.getLeft(), (FlowContext)p.getRight());

    @Override
    public void init(InitContext initContext, Object parent) {
        if (this.preHandler != null) {
            this.preHandler.init(initContext, this);
        }
        if (this.action != null) {
            this.action.init(initContext, this);
        }
        if (this.postHandler != null) {
            this.postHandler.init(initContext, this);
        }
    }

    @Override
    public void destroy() {
        if (this.preHandler != null) {
            this.preHandler.destroy();
        }
        if (this.action != null) {
            this.action.destroy();
        }
        if (this.postHandler != null) {
            this.postHandler.destroy();
        }
    }

    @Override
    public NodeContext execute(NodeContext nodeContext, FlowContext context) {
        if (!this.executePreHandler(nodeContext, context)) {
            return nodeContext;
        }
        this.executeAction(nodeContext, context);
        this.executePostHandler(nodeContext, context);
        return nodeContext;
    }

    protected boolean executePreHandler(NodeContext nodeContext, FlowContext context) {
        if (context.getFlow().getFilterManager().noOuterNodePreHandlerFilter()) {
            return this.invokePreHandler(nodeContext, context);
        }
        Boolean preResult = context.getFlow().getFilterManager().doOuterNodePreHandlerFilter(Pair.of(nodeContext, context), this.outerNodePreHandlerInvoker);
        NodeContextAccessor.setPreResult(nodeContext, preResult);
        return preResult == null ? true : preResult;
    }

    protected boolean invokePreHandler(NodeContext nodeContext, FlowContext context) {
        if (this.preHandler != null) {
            Boolean result;
            context.getFlow().triggerEvent("NODE_PRE_START", nodeContext, context, false);
            boolean preResult = context.getFlow().getFilterManager().noInnerNodePreHandlerFilter() ? this.preHandler.preHandle(nodeContext, context) : ((result = context.getFlow().getFilterManager().doInnerNodePreHandlerFilter(Pair.of(nodeContext, context), this.innerNodePreHandlerInvoker)) == null ? true : result);
            NodeContextAccessor.setPreResult(nodeContext, preResult);
            context.getFlow().triggerEvent("NODE_PRE_END", nodeContext, context, false);
        }
        return nodeContext.getPreResult() == null ? true : nodeContext.getPreResult();
    }

    protected void executeAction(NodeContext nodeContext, FlowContext context) {
        if (context.getFlow().getFilterManager().noOuterNodeActionFilter()) {
            this.invokeAction(nodeContext, context);
        } else {
            Object result = context.getFlow().getFilterManager().doOuterNodeActionFilter(Pair.of(nodeContext, context), this.outerNodeActionInvoker);
            NodeContextAccessor.setActionResult(nodeContext, result);
        }
    }

    protected Object invokeAction(NodeContext nodeContext, FlowContext context) {
        if (this.action != null) {
            context.getFlow().triggerEvent("NODE_ACTION_START", nodeContext, context, false);
            Object result = null;
            result = context.getFlow().getFilterManager().noInnerNodeActionFilter() ? (Object)this.action.execute(nodeContext, context) : context.getFlow().getFilterManager().doInnerNodeActionFilter(Pair.of(nodeContext, context), this.innerNodeActionInvoker);
            NodeContextAccessor.setActionResult(nodeContext, result);
            context.getFlow().triggerEvent("NODE_ACTION_END", nodeContext, context, false);
        }
        return nodeContext.getActionResult();
    }

    protected void executePostHandler(NodeContext nodeContext, FlowContext context) {
        if (context.getFlow().getFilterManager().noOuterNodePostHandlerFilter()) {
            this.invokePostHandler(nodeContext, context);
        } else {
            NodeContext[] result = context.getFlow().getFilterManager().doOuterNodePostHandlerFilter(Pair.of(nodeContext, context), this.outerNodePostHandlerInvoker);
            NodeContextAccessor.setNextNodes(nodeContext, result);
        }
    }

    protected NodeContext[] invokePostHandler(NodeContext nodeContext, FlowContext context) {
        if (this.postHandler != null) {
            context.getFlow().triggerEvent("NODE_POST_START", nodeContext, context, false);
            NodeContext[] nextNodes = null;
            nextNodes = context.getFlow().getFilterManager().noInnerNodePostHandlerFilter() ? this.postHandler.postHandle(nodeContext, context) : context.getFlow().getFilterManager().doInnerNodePostHandlerFilter(Pair.of(nodeContext, context), this.innerNodePostHandlerInvoker);
            if (nextNodes != null) {
                NodeContextAccessor.setNextNodes(nodeContext, nextNodes);
            }
            context.getFlow().triggerEvent("NODE_POST_END", nodeContext, context, false);
        }
        return nodeContext.getNextNodes();
    }

    public NodeAction getAction() {
        return this.action;
    }

    public void setAction(NodeAction action) {
        this.action = action;
    }

    public NodePreHandler getPreHandler() {
        return this.preHandler;
    }

    public void setPreHandler(NodePreHandler preHandler) {
        this.preHandler = preHandler;
    }

    public NodePostHandler getPostHandler() {
        return this.postHandler;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPostHandler(NodePostHandler postHandler) {
        this.postHandler = postHandler;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties.clear();
        this.putProperties(properties);
    }

    public void putProperties(Map<String, Object> properties) {
        if (properties == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            if (entry.getValue() == null) {
                this.properties.remove(entry.getKey());
                continue;
            }
            this.properties.put(entry.getKey(), entry.getValue());
        }
    }
}

