/*
 * Decompiled with CFR 0.152.
 */
package com.jd.easyflow.flow.model.post;

import com.jd.easyflow.flow.engine.FlowContext;
import com.jd.easyflow.flow.model.Flow;
import com.jd.easyflow.flow.model.FlowNode;
import com.jd.easyflow.flow.model.InitContext;
import com.jd.easyflow.flow.model.NodeContext;
import com.jd.easyflow.flow.model.NodeExecutor;
import com.jd.easyflow.flow.model.NodePostHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractNodePostHandler
implements NodePostHandler {
    private static final String IDX_VAR_PREFIX = "$";

    protected NodeContext[] parseToNodes(Object to, NodeContext nodeContext, FlowContext context) {
        if (to == null) {
            return null;
        }
        if (to instanceof String) {
            String toStr = (String)to;
            if (!toStr.startsWith(IDX_VAR_PREFIX)) {
                return new NodeContext[]{this.nodeId2Node(toStr)};
            }
            return new NodeContext[]{this.nodeId2Node(this.parseIndexVar(toStr, nodeContext, context))};
        }
        if (to instanceof Integer) {
            int toIdx = (Integer)to;
            return new NodeContext[]{this.nodeId2Node(context.getFlow().getNodeList().get(toIdx).getId())};
        }
        if (to instanceof List) {
            List toList = (List)to;
            ArrayList<NodeContext> toResult = new ArrayList<NodeContext>(toList.size());
            for (Object toObj : toList) {
                NodeContext[] nodes = this.parseToNodes(toObj, nodeContext, context);
                this.addArray2List(nodes, toResult);
            }
            NodeContext[] result = new NodeContext[toResult.size()];
            return toResult.toArray(result);
        }
        if (to instanceof Map) {
            Map toMap = (Map)to;
            NodeContext[] toNodes = null;
            String toExp = (String)toMap.get("exp");
            if (toExp != null) {
                Object result = context.getElEvaluator().eval(toExp, nodeContext, context, null);
                if (result == null) {
                    return null;
                }
                toNodes = result instanceof NodeContext[] ? (NodeContext[])result : this.parseToNodes(result, nodeContext, context);
            } else {
                Object node = toMap.get("node");
                toNodes = this.parseToNodes(node, nodeContext, context);
            }
            Map dataConf = (Map)toMap.get("data");
            if (dataConf != null && toNodes != null) {
                for (Map.Entry entry : dataConf.entrySet()) {
                    Object value = this.parseDataValue(entry.getValue(), nodeContext, context);
                    for (NodeContext node : toNodes) {
                        node.put((String)entry.getKey(), value);
                    }
                }
            }
            return toNodes;
        }
        if (to instanceof NodeExecutor) {
            Object result = ((NodeExecutor)to).execute(nodeContext, context);
            if (result == null) {
                return null;
            }
            if (result instanceof NodeContext[]) {
                return (NodeContext[])result;
            }
            return this.parseToNodes(result, nodeContext, context);
        }
        throw new UnsupportedOperationException("Unsupported type:" + to.getClass());
    }

    protected Object parseToDefinition(Object to, FlowNode node, InitContext initContext) {
        block7: {
            block6: {
                if (!(to instanceof List)) break block6;
                List list = (List)to;
                for (int i = 0; i < list.size(); ++i) {
                    Object element = list.get(i);
                    if (!(element instanceof List) && !(element instanceof Map)) continue;
                    list.set(i, this.parseToDefinition(element, node, initContext));
                }
                break block7;
            }
            if (!(to instanceof Map)) break block7;
            Map map = (Map)to;
            if (map.get("type") != null) {
                throw new IllegalArgumentException("type is reserved");
            }
            Map data = (Map)map.get("data");
            String createExp = (String)map.get("createExp");
            if (createExp != null && initContext.isParseEl()) {
                if (data != null) {
                    throw new IllegalArgumentException("data is reserved");
                }
                HashMap<String, Object> context = new HashMap<String, Object>(3);
                context.put("definition", map);
                context.put("node", node);
                context.put("flow", initContext.getFlow());
                context.put("flowParser", initContext.getFlowParser());
                NodeExecutor nodeExecutor = (NodeExecutor)initContext.getFlowParser().getElEvaluator().evalWithDefaultContext(createExp, context, false);
                return nodeExecutor;
            }
            if (data != null) {
                for (Map.Entry entry : data.entrySet()) {
                    if (!(entry.getValue() instanceof Map)) continue;
                    entry.setValue(this.parseDataValueDefinition(entry.getValue(), node, initContext));
                }
            }
        }
        return to;
    }

    private Object parseDataValueDefinition(Object dataValue, FlowNode node, InitContext initContext) {
        if (dataValue instanceof Map) {
            Map map = (Map)dataValue;
            if (map.get("type") != null) {
                throw new IllegalArgumentException("type is reserved");
            }
            String createExp = (String)map.get("createExp");
            if (createExp != null && initContext.isParseEl()) {
                HashMap<String, Object> context = new HashMap<String, Object>(3);
                context.put("definition", map);
                context.put("node", node);
                context.put("flow", initContext.getFlow());
                context.put("flowParser", initContext.getFlowParser());
                NodeExecutor executor = (NodeExecutor)initContext.getFlowParser().getElEvaluator().evalWithDefaultContext(createExp, context, false);
                return executor;
            }
        }
        return dataValue;
    }

    private Object parseDataValue(Object value, NodeContext nodeContext, FlowContext context) {
        if (value instanceof String) {
            return context.getElEvaluator().eval((String)value, nodeContext, context, null);
        }
        if (value instanceof Map) {
            Map valueMap = (Map)value;
            if (valueMap.containsKey("exp")) {
                String exp = (String)valueMap.get("exp");
                return context.getElEvaluator().eval(exp, nodeContext, context, null);
            }
            if (valueMap.containsKey("fixedValue")) {
                return valueMap.get("fixedValue");
            }
            throw new IllegalArgumentException("illegal data map, " + value);
        }
        if (value instanceof NodeExecutor) {
            return ((NodeExecutor)value).execute(nodeContext, context);
        }
        throw new IllegalArgumentException("illegal data " + value);
    }

    private String parseIndexVar(String var, NodeContext nodeContext, FlowContext flowContext) {
        int index = -1;
        Flow flow = flowContext.getFlow();
        switch (var) {
            case "$first": {
                index = 0;
                break;
            }
            case "$last": {
                index = flow.getNodeList().size() - 1;
                break;
            }
            case "$previous": {
                index = flow.getNodeIndex(nodeContext.getNodeId()) - 1;
                break;
            }
            case "$next": {
                index = flow.getNodeIndex(nodeContext.getNodeId()) + 1;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported vars:" + var);
            }
        }
        return flow.getNodeList().get(index).getId();
    }

    protected NodeContext[] list2Array(List<NodeContext> list) {
        if (list == null) {
            return null;
        }
        NodeContext[] nodes = new NodeContext[list.size()];
        return list.toArray(nodes);
    }

    protected NodeContext[] nodeIds2Nodes(List<String> nodeIds) {
        if (nodeIds == null) {
            return null;
        }
        NodeContext[] nodes = new NodeContext[nodeIds.size()];
        for (int i = 0; i < nodeIds.size(); ++i) {
            nodes[i] = new NodeContext(nodeIds.get(i));
        }
        return nodes;
    }

    protected NodeContext nodeId2Node(String nodeId) {
        if (nodeId == null) {
            return null;
        }
        return new NodeContext(nodeId);
    }

    protected void addArray2List(NodeContext[] nodes, List<NodeContext> list) {
        if (nodes == null) {
            return;
        }
        for (NodeContext node : nodes) {
            list.add(node);
        }
    }
}

