/*
 * Decompiled with CFR 0.152.
 */
package com.jd.easyflow.flow.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;

public class JsonUtil {
    private static ObjectMapper mapper = new ObjectMapper();

    public static String toJsonString(Object o) {
        return JsonUtil.toJsonString(o, mapper);
    }

    public static String toJsonString(Object o, ObjectMapper mapper) {
        try {
            return mapper.writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toPrettyJsonString(Object o) {
        return JsonUtil.toPrettyJsonString(o, mapper);
    }

    public static String toPrettyJsonString(Object o, ObjectMapper mapper) {
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parseObject(String s, Class<T> clazz) {
        return JsonUtil.parseObject(s, clazz, mapper);
    }

    public static <T> T parseObject(String s, Class<T> clazz, ObjectMapper mapper) {
        try {
            return (T)mapper.readValue(s, clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

