/*
 * Decompiled with CFR 0.152.
 */
package com.jd.easyflow.flow.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class SpelHelper {
    private static final Logger logger = LoggerFactory.getLogger(SpelHelper.class);
    public static StandardEvaluationContext context = new StandardEvaluationContext();
    private static Map<String, Expression> cacheMap = new ConcurrentHashMap<String, Expression>();
    private static Map<String, Expression> tmpCacheMap = new ConcurrentHashMap<String, Expression>();
    private static Map<String, String> safePropertyMap = new ConcurrentHashMap<String, String>();
    private static ExpressionParser parser = new SpelExpressionParser();
    private static ApplicationContext applicationContext;

    public static void clearCache() {
        cacheMap.clear();
        tmpCacheMap.clear();
        safePropertyMap.clear();
    }

    public static Expression parse(String exp) {
        return parser.parseExpression(exp);
    }

    public static <T> T safeGetProperty(String exp, Object context) {
        if (context == null) {
            return null;
        }
        return SpelHelper.safeGetProperty(exp, context, true);
    }

    public static <T> T safeGetProperty(String exp, Object context, boolean cache) {
        if (exp == null) {
            return null;
        }
        if (!cache) {
            String safeExp = SpelHelper.getSafePropertyExp(exp);
            return SpelHelper.eval(safeExp, context, false);
        }
        String safeExp = safePropertyMap.get(exp);
        if (safeExp == null) {
            safeExp = SpelHelper.getSafePropertyExp(exp);
            safePropertyMap.put(exp, safeExp);
        }
        return SpelHelper.eval(safeExp, context, true);
    }

    private static String getSafePropertyExp(String exp) {
        String[] values = exp.split("\\.");
        StringBuffer buffer = new StringBuffer();
        for (String s : values) {
            buffer.append(s).append("?.");
        }
        return buffer.substring(0, buffer.length() - 2);
    }

    public static <T> T eval(Expression exp, Object context) {
        Object value = exp.getValue(context);
        return (T)value;
    }

    public static <T> T evalWithDefaultContext(String exp, Object root, boolean cache) {
        return SpelHelper.eval(exp, (EvaluationContext)context, root, cache);
    }

    public static <T> T eval(String exp, Object context) {
        return SpelHelper.eval(exp, context, true);
    }

    public static <T> T eval(String exp, Object context, boolean cache) {
        Expression expression;
        if (cache) {
            expression = cacheMap.get(exp);
            if (expression == null) {
                expression = SpelHelper.parse(exp);
                cacheMap.put(exp, expression);
            }
        } else {
            expression = SpelHelper.parse(exp);
        }
        Object value = null;
        value = context instanceof EvaluationContext ? expression.getValue((EvaluationContext)context) : expression.getValue(context);
        return (T)value;
    }

    public static <T> T eval(String exp, EvaluationContext context, Object root, boolean cache) {
        Expression expression;
        if (cache) {
            expression = cacheMap.get(exp);
            if (expression == null) {
                expression = SpelHelper.parse(exp);
                cacheMap.put(exp, expression);
            }
        } else {
            expression = SpelHelper.parse(exp);
        }
        Object value = expression.getValue(context, root);
        return (T)value;
    }

    public static Expression parseTemplate(String template) {
        return parser.parseExpression(template, ParserContext.TEMPLATE_EXPRESSION);
    }

    public static String evalTemplate(Expression template, Object context) {
        return (String)template.getValue(context);
    }

    public static String evalTemplate(String template, Object context) {
        return SpelHelper.evalTemplate(template, context, true);
    }

    public static String evalTemplate(String template, Object context, boolean cache) {
        try {
            Expression expression;
            if (cache) {
                expression = tmpCacheMap.get(template);
                if (expression == null) {
                    expression = SpelHelper.parseTemplate(template);
                    tmpCacheMap.put(template, expression);
                }
            } else {
                expression = SpelHelper.parseTemplate(template);
            }
            Object result = null;
            result = context instanceof EvaluationContext ? expression.getValue((EvaluationContext)context) : expression.getValue(context);
            if (result == null) {
                return null;
            }
            return result.toString();
        }
        catch (Exception e) {
            logger.error("SPEL template eval exception, template:" + template, (Throwable)e);
            throw e;
        }
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static void setApplicationContext(ApplicationContext applicationContext) {
        SpelHelper.applicationContext = applicationContext;
        context.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)applicationContext));
    }

    public static StandardEvaluationContext getDefaultContext() {
        return context;
    }

    static {
        context.addPropertyAccessor((PropertyAccessor)new MapAccessor());
    }
}

