/*
 * Copyright 2018-2025 JDCLOUD.COM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http:#www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * 云存储API
 * 云存储API，主要包含查询Bucket列表，创建Bucket, 删除Bucket，查询Bucket是否存在, 更多API见：https://www.jdcloud.com/help/detail/1901/isCatalog/1
 *
 * OpenAPI spec version: v1
 * Contact: 
 *
 * NOTE: This class is auto generated by the jdcloud code generator program.
 */

package com.jdcloud.sdk.service.oss.client;

import com.jdcloud.sdk.JdcloudSdkException;
import com.jdcloud.sdk.auth.CredentialsProvider;
import com.jdcloud.sdk.client.Environment;
import com.jdcloud.sdk.client.Jdcloud;
import com.jdcloud.sdk.client.JdcloudClient;
import com.jdcloud.sdk.client.JdcloudValidateException;
import com.jdcloud.sdk.http.HttpRequestConfig;
import com.jdcloud.sdk.service.oss.model.PutBucketRequest;
import com.jdcloud.sdk.service.oss.model.PutBucketResponse;
import com.jdcloud.sdk.service.oss.client.PutBucketExecutor;
import com.jdcloud.sdk.service.oss.model.DeleteBucketRequest;
import com.jdcloud.sdk.service.oss.model.DeleteBucketResponse;
import com.jdcloud.sdk.service.oss.client.DeleteBucketExecutor;
import com.jdcloud.sdk.service.oss.model.HeadBucketRequest;
import com.jdcloud.sdk.service.oss.model.HeadBucketResponse;
import com.jdcloud.sdk.service.oss.client.HeadBucketExecutor;
import com.jdcloud.sdk.service.oss.model.ListBucketsRequest;
import com.jdcloud.sdk.service.oss.model.ListBucketsResponse;
import com.jdcloud.sdk.service.oss.client.ListBucketsExecutor;

/**
 * ossClient
 */
public class OssClient extends JdcloudClient {

    public final static String ApiVersion = "v1";
    private final static String UserAgentPrefix = "JdcloudSdkJava";
    public final static String ClientVersion = "1.0.1";
    public final static String DefaultEndpoint = "oss.jdcloud-api.com";
    public final static String ServiceName = "oss";
    public final static String UserAgent = UserAgentPrefix + "/" + ClientVersion + " " + ServiceName + "/" + ApiVersion;

    CredentialsProvider credentialsProvider;
    HttpRequestConfig httpRequestConfig;
    Environment environment = new Environment.Builder().endpoint(DefaultEndpoint).build();

    public CredentialsProvider getCredentialsProvider() {
        return credentialsProvider;
    }

    public HttpRequestConfig getHttpRequestConfig() {
        return httpRequestConfig;
    }

    public Environment getEnvironment() {
        return environment;
    }

    public String getUserAgent() {
        return UserAgent;
    }

    public String getServiceName() {
        return ServiceName;
    }

    public String getVersion() {
        return ApiVersion;
    }

    private OssClient() {

    }

    public static Builder builder() {
        return new DefaultBuilder();
    }


    /**
     * 创建bucket

     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public PutBucketResponse putBucket(PutBucketRequest request) throws JdcloudSdkException {
        return new PutBucketExecutor().client(this).execute(request);
    }

    /**
     * 删除一个bucket

     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public DeleteBucketResponse deleteBucket(DeleteBucketRequest request) throws JdcloudSdkException {
        return new DeleteBucketExecutor().client(this).execute(request);
    }

    /**
     * 查询bucket是否存在

     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public HeadBucketResponse headBucket(HeadBucketRequest request) throws JdcloudSdkException {
        return new HeadBucketExecutor().client(this).execute(request);
    }

    /**
     * 列出当前用户的所有bucket

     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public ListBucketsResponse listBuckets(ListBucketsRequest request) throws JdcloudSdkException {
        return new ListBucketsExecutor().client(this).execute(request);
    }


    public interface Builder {
        public Builder credentialsProvider(CredentialsProvider provider);
        public Builder environment(Environment environment);
        public Builder httpRequestConfig(HttpRequestConfig config);
        public OssClient build() throws JdcloudSdkException;
    }

    private static class DefaultBuilder implements Builder {

        private OssClient ossClient;

        public DefaultBuilder() {
            ossClient = new OssClient();
        }

        public DefaultBuilder credentialsProvider(CredentialsProvider provider) {
            ossClient.credentialsProvider = provider;
            return this;
        }

        public DefaultBuilder httpRequestConfig(HttpRequestConfig config) {
            ossClient.httpRequestConfig = config;
            return this;
        }

        public OssClient build() throws JdcloudSdkException {

            if (ossClient.credentialsProvider == null) {
                //if credentialsProvider not set, try load jdcloud global default  credentials provider
                ossClient.credentialsProvider = Jdcloud.defaultInstance().getCredentialsProvider();
                if (ossClient.credentialsProvider == null) {
                    throw new JdcloudValidateException("OssClient build error: jdcloud credentials provider not set");
                }
            }
            if (ossClient.httpRequestConfig == null) {
                ossClient.httpRequestConfig = Jdcloud.defaultInstance().getHttpRequestConfig();
                if (ossClient.httpRequestConfig == null) {
                    throw new JdcloudValidateException("OssClient build error: http request config not set");
                }
            }
            return ossClient;
        }

        public Builder environment(Environment environment) {
            ossClient.environment = environment;
            return this;
        }
    }
}
