/*
 * Decompiled with CFR 0.152.
 */
package com.jdiai.tools;

import com.jdiai.tools.Safe;
import java.util.function.Supplier;

public class CacheValue<T> {
    private static Safe<Long> globalCache = new Safe<Long>(0L);
    private Safe<Long> elementCache = new Safe<Supplier<Long>>(() -> 0L);
    private Safe<T> value = new Safe<Supplier<Object>>(() -> null);
    private T finalValue = null;
    private Supplier<T> getRule = () -> null;

    public static void reset() {
        globalCache.set(System.currentTimeMillis());
    }

    public CacheValue() {
    }

    public CacheValue<T> copy() {
        CacheValue<T> cv = new CacheValue<T>();
        cv.elementCache = new Safe<Supplier<Long>>(() -> this.elementCache.get());
        cv.value = new Safe<Supplier<Object>>(() -> this.value.get());
        cv.finalValue = this.finalValue;
        cv.getRule = this.getRule;
        return cv;
    }

    public CacheValue(Supplier<T> getRule) {
        this.getRule = getRule;
    }

    public T get() {
        return this.get(this.getRule);
    }

    public T getForce() {
        CacheValue.reset();
        return this.get();
    }

    public T get(Supplier<T> defaultResult) {
        if (this.finalValue != null) {
            return this.finalValue;
        }
        if (!this.isUseCache()) {
            return defaultResult.get();
        }
        if (this.elementCache.get() < globalCache.get() || this.value.get() == null) {
            this.value.set(this.getRule.get());
            this.elementCache.set(globalCache.get());
        }
        return this.value.get();
    }

    public void useCache(boolean value) {
        this.elementCache.set(value ? 0L : -1L);
    }

    public T setForce(T value) {
        if (this.finalValue != null) {
            return this.finalValue;
        }
        this.elementCache.set(globalCache.get());
        this.value.set(value);
        return value;
    }

    public T setFinal(T value) {
        this.finalValue = value;
        return value;
    }

    public T set(T value) {
        if (this.finalValue != null) {
            return this.finalValue;
        }
        return !this.isUseCache() ? value : this.setForce(value);
    }

    public void setRule(Supplier<T> getRule) {
        this.getRule = getRule;
    }

    public void clear() {
        this.value.set(null);
    }

    public boolean hasValue() {
        return this.finalValue != null || this.isUseCache() && this.value.get() != null && this.elementCache.get().equals(globalCache.get());
    }

    public boolean isUseCache() {
        return this.elementCache.get() > -1L;
    }
}

