/*
 * Decompiled with CFR 0.152.
 */
package com.jdiai.tools;

import com.jdiai.tools.ComparableData;
import com.jdiai.tools.EqualBy;
import com.jdiai.tools.EqualExclude;
import com.jdiai.tools.LinqUtils;
import com.jdiai.tools.PrintUtils;
import com.jdiai.tools.ReflectionUtils;
import com.jdiai.tools.map.MapArray;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.lang3.ObjectUtils;

public class DataClass<T>
implements Cloneable,
ComparableData {
    public T set(Consumer<T> valueFunc) {
        return (T)DataClass.set(this, valueFunc);
    }

    public static <R> R set(R thisObj, Consumer<R> valueFunc) {
        valueFunc.accept(thisObj);
        return thisObj;
    }

    public Map<String, Object> fieldsAsMap() {
        return DataClass.fieldsMap(this);
    }

    public static Map<String, Object> fieldsMap(Object obj) {
        Field[] fields;
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            map.put(field.getName(), ReflectionUtils.getValueField(field, obj));
        }
        return map;
    }

    public MapArray<String, Object> fields() {
        return DataClass.fields(this);
    }

    public static MapArray<String, Object> fields(Object obj) {
        Field[] fields = obj.getClass().getDeclaredFields();
        return new MapArray<String, Object>(fields, Field::getName, f -> ReflectionUtils.getValueField(f, obj));
    }

    public String toString() {
        return PrintUtils.printFields(this);
    }

    @Override
    public String compareTo(DataClass<?> other) {
        return DataClass.compare(this, other);
    }

    public static <R> String compare(DataClass<R> first, DataClass<R> second) {
        ArrayList<String> inequality = new ArrayList<String>();
        Map<String, Object> toCompare = second.fieldsAsMap();
        for (Map.Entry<String, Object> field : first.fieldsAsMap().entrySet()) {
            Object compareValue = toCompare.get(field.getKey());
            if (compareValue == null) {
                if (field.getValue() == null) continue;
                inequality.add(String.format("Field '%s' value should be '%s' but 'null'", field.getKey(), field.getValue()));
                continue;
            }
            if (compareValue.equals(field.getValue())) continue;
            inequality.add(String.format("Field '%s' value should be '%s' but '%s'", field.getKey(), field.getValue(), compareValue));
        }
        return ObjectUtils.isNotEmpty(inequality) ? String.join((CharSequence)"\n", inequality) : "";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        try {
            Field[] otherFields = o.getClass().getDeclaredFields();
            boolean whiteList = LinqUtils.any(otherFields, f -> f.isAnnotationPresent(EqualBy.class));
            for (Field f2 : this.getClass().getDeclaredFields()) {
                if (whiteList && !f2.isAnnotationPresent(EqualBy.class) || f2.isAnnotationPresent(EqualExclude.class)) continue;
                Field fOther = LinqUtils.first(otherFields, fo -> fo.getName().equals(f2.getName()));
                if (ReflectionUtils.getValueField(f2, this) == null && fOther.get(o) == null || !(ReflectionUtils.getValueField(f2, this) != null && fOther.get(o) == null || ReflectionUtils.getValueField(f2, this) == null && fOther.get(o) != null) && ReflectionUtils.getValueField(f2, this).equals(fOther.get(o))) continue;
                return false;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        for (Field f : this.getClass().getDeclaredFields()) {
            try {
                Object value = ReflectionUtils.getValueField(f, this);
                result += 31 * result + (value != null ? value.hashCode() : 0);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage());
            }
        }
        return result;
    }
}

