/*
 * Decompiled with CFR 0.152.
 */
package com.jdiai.tools;

import com.jdiai.tools.LinqUtils;
import com.jdiai.tools.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;

public final class EnumUtils {
    private EnumUtils() {
    }

    public static String[] getEnumValues(Enum<?> ... values) {
        String[] result = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = EnumUtils.getEnumValue(values[i]);
        }
        return result;
    }

    public static String getEnumValue(Enum<?> enumWithValue) {
        Class<?> type = enumWithValue.getClass();
        Field[] fields = type.getDeclaredFields();
        try {
            switch (fields.length) {
                case 0: {
                    return enumWithValue.toString();
                }
                case 1: {
                    return ReflectionUtils.getValueField(fields[0], enumWithValue).toString();
                }
            }
            return EnumUtils.getEnumValueFromValueField(type, enumWithValue);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to get Enum value: " + enumWithValue, ex);
        }
    }

    private static String getEnumValueFromValueField(Class<?> type, Enum<?> enumWithValue) {
        try {
            Field field = type.getDeclaredField("value");
            return ReflectionUtils.getValueField(field, enumWithValue).toString();
        }
        catch (NoSuchFieldException ex) {
            return enumWithValue.toString();
        }
    }

    public static <T extends Enum<?>> T getEnumValueByName(Class<T> cl, String expectedValueName, T defaultValue) {
        Enum firstType = LinqUtils.first(EnumUtils.getAllEnumValues(cl), t -> EnumUtils.getType(t, expectedValueName));
        return (T)(firstType != null ? firstType : defaultValue);
    }

    private static boolean getType(Object enumType, String type) {
        return enumType.toString().trim().replaceAll("[^a-z]", "").equalsIgnoreCase(type.trim().replaceAll("[^a-z]", ""));
    }

    public static <T extends Enum<?>> List<T> getAllEnumValues(Class<T> enumValue) {
        return Arrays.asList(EnumUtils.getAllEnumValuesAsArray(enumValue));
    }

    public static <T extends Enum<?>> T[] getAllEnumValuesAsArray(Class<T> enumValue) {
        return (Enum[])enumValue.getEnumConstants();
    }

    public static <T extends Enum<?>> List<String> getAllEnumNames(Class<T> enumValue) {
        return LinqUtils.select(EnumUtils.getAllEnumValuesAsArray(enumValue), EnumUtils::getEnumValue);
    }

    public static <T extends Enum<?>> String[] getAllEnumNamesAsArray(Class<T> enumValue) {
        return LinqUtils.toStringArray(EnumUtils.getAllEnumNames(enumValue));
    }
}

