/*
 * Decompiled with CFR 0.152.
 */
package com.jdiai.tools;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileUtils {
    private FileUtils() {
    }

    public static List<String> getFiles(String pathToDir) {
        try {
            return FileUtils.findFilesInFolder(pathToDir);
        }
        catch (Exception ex) {
            return new ArrayList<String>();
        }
    }

    public static List<String> findFilesInFolder(String folderName) throws IOException {
        try (Stream<Path> stream = Files.walk(Paths.get(folderName, new String[0]), new FileVisitOption[0]);){
            List<String> list = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(f -> f.toAbsolutePath().toString()).collect(Collectors.toList());
            return list;
        }
    }
}

