/*
 * Decompiled with CFR 0.152.
 */
package com.jdiai.tools;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class FixedQueue<T> {
    protected Queue<T> queue;
    protected int limit;

    public FixedQueue(int limit) {
        this.limit = Math.max(limit, 0);
        this.queue = new LinkedList<T>();
    }

    public void push(T element) {
        if (this.limit == 0) {
            return;
        }
        if (this.queue.size() >= this.limit) {
            this.queue.remove();
        }
        this.queue.add(element);
    }

    public List<T> values() {
        return new ArrayList<T>(this.queue);
    }

    public void clear() {
        this.queue.clear();
    }

    public int size() {
        if (this.limit == 0) {
            return 0;
        }
        return this.queue.size();
    }

    public T peek() {
        if (this.limit == 0) {
            return null;
        }
        T element = this.queue.peek();
        this.queue.remove();
        return element;
    }

    public T observe() {
        if (this.limit == 0) {
            return null;
        }
        return this.queue.peek();
    }
}

