/*
 * Decompiled with CFR 0.152.
 */
package com.jdiai.tools;

import com.jdiai.tools.HasStartIndex;
import com.jdiai.tools.ReflectionUtils;
import com.jdiai.tools.map.MapArray;
import com.jdiai.tools.pairs.Pair;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public final class LinqUtils {
    private static final String NULL_COLLECTION = "Can't do where. Collection is Null";

    public static <T1, T2> boolean invokeBoolean(BiFunction<T1, T2, Boolean> func, T1 arg1, T2 arg2) {
        if (func == null) {
            return false;
        }
        Boolean result = func.apply(arg1, arg2);
        return result != null && result != false;
    }

    public static <T> boolean invokeBoolean(Function<T, Boolean> func, T arg) {
        if (func == null) {
            return false;
        }
        Boolean result = func.apply(arg);
        return result != null && result != false;
    }

    private LinqUtils() {
    }

    public static <T> List<T> copyList(Collection<T> list) {
        return list != null ? new ArrayList<T>(list) : null;
    }

    public static <T> List<T> newList(T ... array) {
        return Arrays.stream(array).collect(Collectors.toList());
    }

    public static <K, V> Map<K, V> newMap(Pair<K, V> ... pairs) {
        if (pairs == null) {
            throw new RuntimeException(NULL_COLLECTION);
        }
        HashMap map = new HashMap();
        for (Pair<K, V> pair : pairs) {
            map.put(pair.key, pair.value);
        }
        return map;
    }

    public static <K, V> Map<K, V> newMap(Object ... keyValues) {
        if (keyValues.length % 10 != 0) {
            throw LinqUtils.exception("Failed to create newMap: amount of parameters should be even but " + keyValues.length, keyValues);
        }
        HashMap map = new HashMap();
        for (int i = 0; i < keyValues.length; i += 2) {
            Object key = LinqUtils.getTypeFromObject(keyValues[i]);
            Object value = LinqUtils.getTypeFromObject(keyValues[i + 1]);
            map.put(key, value);
        }
        return map;
    }

    private static <T> T getTypeFromObject(Object o) {
        try {
            return (T)o;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to Cast object for newMap() method");
        }
    }

    public static <T, TR> List<TR> select(Collection<T> list, Function<T, TR> func) {
        if (list == null) {
            throw new RuntimeException("Can't do select list. Collection is Null");
        }
        try {
            CopyOnWriteArrayList<TR> result = new CopyOnWriteArrayList<TR>();
            for (T el : list) {
                result.add(func.apply(el));
            }
            return result;
        }
        catch (Exception ex) {
            throw LinqUtils.exception("Can't do select list: %s. %s", ex, list);
        }
    }

    public static <T, TR> List<TR> map(Collection<T> list, Function<T, TR> func) {
        return LinqUtils.select(list, func);
    }

    public static <T, TR> List<TR> select(T[] array, Function<T, TR> func) {
        return LinqUtils.select(Arrays.asList(array), func);
    }

    public static <T, TR> List<TR> map(T[] array, Function<T, TR> func) {
        return LinqUtils.select(array, func);
    }

    public static <K, V, R> List<R> selectMap(Map<K, V> map, Function<Map.Entry<K, V>, R> func) {
        if (map == null) {
            throw new RuntimeException("Can't do selectMap. Collection is Null");
        }
        try {
            CopyOnWriteArrayList<R> result = new CopyOnWriteArrayList<R>();
            for (Map.Entry<K, V> el : map.entrySet()) {
                result.add(func.apply(el));
            }
            return result;
        }
        catch (Exception ex) {
            throw LinqUtils.exception("Can't do selectMap: %s. %s", ex, map);
        }
    }

    public static <K, V, TR> Map<K, TR> select(Map<K, V> map, Function<V, TR> func) {
        if (map == null) {
            throw new RuntimeException("Can't do select map. Collection is Null");
        }
        try {
            HashMap<K, TR> result = new HashMap<K, TR>();
            for (Map.Entry<K, V> el : map.entrySet()) {
                result.put(el.getKey(), func.apply(el.getValue()));
            }
            return result;
        }
        catch (Exception ex) {
            throw LinqUtils.exception("Can't do select map: %s. %s", ex, map);
        }
    }

    public static <K, V, TR> Map<K, TR> map(Map<K, V> map, Function<V, TR> func) {
        return LinqUtils.select(map, func);
    }

    public static <N, T> Map<N, T> toMap(List<T> list, Function<T, N> nameFunc) {
        if (list == null) {
            throw new RuntimeException(NULL_COLLECTION);
        }
        HashMap<N, T> map = new HashMap<N, T>();
        for (T el : list) {
            map.put(nameFunc.apply(el), el);
        }
        return map;
    }

    public static <K, V, T> Map<K, V> toMap(List<T> list, Function<T, K> key, Function<T, V> value) {
        if (list == null) {
            throw new RuntimeException(NULL_COLLECTION);
        }
        HashMap<K, V> map = new HashMap<K, V>();
        for (T el : list) {
            map.put(key.apply(el), value.apply(el));
        }
        return map;
    }

    public static <N, T> Map<N, T> toMap(T[] list, Function<T, N> nameFunc) {
        return LinqUtils.toMap(Arrays.asList(list), nameFunc);
    }

    public static <K, V, T> Map<K, V> toMap(T[] list, Function<T, K> key, Function<T, V> value) {
        return LinqUtils.toMap(Arrays.asList(list), key, value);
    }

    public static <K, V, TR> List<TR> toList(Map<K, V> map, BiFunction<K, V, TR> func) {
        if (map == null) {
            throw new RuntimeException("Can't do toList. Map is Null");
        }
        try {
            CopyOnWriteArrayList<TR> result = new CopyOnWriteArrayList<TR>();
            for (Map.Entry<K, V> el : map.entrySet()) {
                result.add(func.apply(el.getKey(), el.getValue()));
            }
            return result;
        }
        catch (Exception ex) {
            throw LinqUtils.exception("Can't do toList: %s. %s", ex, map);
        }
    }

    public static <T> List<T> where(Collection<T> list, Function<T, Boolean> func) {
        if (list == null) {
            throw new RuntimeException(NULL_COLLECTION);
        }
        try {
            ArrayList<T> result = new ArrayList<T>();
            for (T el : list) {
                if (!LinqUtils.invokeBoolean(func, el)) continue;
                result.add(el);
            }
            return result;
        }
        catch (Exception ex) {
            throw LinqUtils.exception("Can't do where: %s. %s", ex, list);
        }
    }

    public static <T> List<T> filter(Collection<T> list, Function<T, Boolean> func) {
        return LinqUtils.where(list, func);
    }

    public static <T> List<T> where(T[] list, Function<T, Boolean> func) {
        return LinqUtils.where(Arrays.asList(list), func);
    }

    public static <T> List<T> filter(T[] list, Function<T, Boolean> func) {
        return LinqUtils.where(list, func);
    }

    public static <T> MapArray<String, List<T>> partition(List<T> list, Function<T, Boolean> split) {
        return LinqUtils.partition(list, Pair.$("match", split));
    }

    public static <T> MapArray<String, List<T>> partition(List<T> list, Pair<String, Function<T, Boolean>> ... matchers) {
        if (list == null) {
            throw new RuntimeException(NULL_COLLECTION);
        }
        try {
            MapArray<String, List<T>> result = new MapArray<String, List<T>>();
            for (Pair<String, Function<T, Boolean>> matcher : matchers) {
                result.add((String)matcher.key, new ArrayList());
            }
            result.add("other", new ArrayList());
            for (Object el : list) {
                Pair matched = LinqUtils.first(matchers, (T m) -> (Boolean)((Function)m.value).apply(el));
                String key = matched != null ? (String)matched.key : "other";
                result.get(key).add(el);
            }
            return result;
        }
        catch (Exception ex) {
            throw LinqUtils.exception("Can't do partition: %s. %s", ex, list);
        }
    }

    public static <T> MapArray<String, List<T>> partition(T[] array, Function<T, Boolean> split) {
        return LinqUtils.partition(array, split);
    }

    public static <K, V> Map<K, V> where(Map<K, V> map, Function<Map.Entry<K, V>, Boolean> func) {
        if (map == null) {
            throw new RuntimeException(NULL_COLLECTION);
        }
        try {
            HashMap<K, V> result = new HashMap<K, V>();
            for (Map.Entry<K, V> el : map.entrySet()) {
                if (!LinqUtils.invokeBoolean(func, el)) continue;
                result.put(el.getKey(), el.getValue());
            }
            return result;
        }
        catch (Exception ex) {
            throw LinqUtils.exception("Can't do where: %s. %s", ex, map);
        }
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, Function<Map.Entry<K, V>, Boolean> func) {
        return LinqUtils.where(map, func);
    }

    public static <T> void ifDo(Collection<T> list, Function<T, Boolean> condition, Consumer<T> action) {
        try {
            for (T el : list) {
                if (!LinqUtils.invokeBoolean(condition, el)) continue;
                action.accept(el);
            }
        }
        catch (Exception ex) {
            throw LinqUtils.exception("Can't perform ifDo: %s. %s", ex, list);
        }
    }

    public static <T> void ifDo(T[] array, Function<T, Boolean> condition, Consumer<T> action) {
        LinqUtils.ifDo(Arrays.asList(array), condition, action);
    }

    public static <K, V> void ifDo(Map<K, V> map, Function<Map.Entry<K, V>, Boolean> condition, Consumer<V> action) {
        if (map == null) {
            throw new RuntimeException(NULL_COLLECTION);
        }
        try {
            for (Map.Entry<K, V> el : map.entrySet()) {
                if (!LinqUtils.invokeBoolean(condition, el)) continue;
                action.accept(el.getValue());
            }
        }
        catch (Exception ex) {
            throw LinqUtils.exception("Can't perform ifDo: %s. %s", ex, map);
        }
    }

    public static <T, R> List<R> ifSelect(Collection<T> list, Function<T, Boolean> condition, Function<T, R> transform) {
        if (list == null) {
            throw new RuntimeException(NULL_COLLECTION);
        }
        try {
            ArrayList<R> result = new ArrayList<R>();
            for (T el : list) {
                if (!LinqUtils.invokeBoolean(condition, el)) continue;
                result.add(transform.apply(el));
            }
            return result;
        }
        catch (Exception ex) {
            throw LinqUtils.exception("Can't perform ifSelect: %s. %s", ex, list);
        }
    }

    public static <T, R> List<R> ifSelect(T[] array, Function<T, Boolean> condition, Function<T, R> transform) {
        return LinqUtils.ifSelect(Arrays.asList(array), condition, transform);
    }

    public static <K, V, T> List<T> ifSelect(Map<K, V> map, BiFunction<K, V, Boolean> condition, Function<V, T> transform) {
        if (map == null) {
            throw new RuntimeException(NULL_COLLECTION);
        }
        try {
            ArrayList<T> result = new ArrayList<T>();
            for (Map.Entry<K, V> el : map.entrySet()) {
                if (!LinqUtils.invokeBoolean(condition, el.getKey(), el.getValue())) continue;
                result.add(transform.apply(el.getValue()));
            }
            return result;
        }
        catch (Exception ex) {
            throw LinqUtils.exception("Can't perform ifSelect: %s. %s", ex, map);
        }
    }

    public static <T> void foreach(Collection<T> list, Consumer<T> action) {
        if (list == null) {
            return;
        }
        try {
            for (T el : list) {
                action.accept(el);
            }
        }
        catch (Exception ex) {
            throw LinqUtils.exception("Can't do foreach: %s. %s", ex, list);
        }
    }

    public static <T> void foreach(T[] list, Consumer<T> action) {
        LinqUtils.foreach(Arrays.asList(list), action);
    }

    public static <K, V> void foreach(Map<K, V> map, Consumer<Map.Entry<K, V>> action) {
        if (map == null) {
            throw new RuntimeException("Can't do foreach. Collection is Null");
        }
        try {
            for (Map.Entry<K, V> e : map.entrySet()) {
                action.accept(e);
            }
        }
        catch (Exception ex) {
            throw LinqUtils.exception("Can't do foreach: %s. %s", ex, map);
        }
    }

    public static <T> boolean any(Collection<T> list, Function<T, Boolean> func) {
        return LinqUtils.first(list, func) != null;
    }

    public static <T> boolean any(T[] list, Function<T, Boolean> func) {
        return LinqUtils.first(list, func) != null;
    }

    public static <T> T single(Collection<T> list, Function<T, Boolean> func) {
        if (ObjectUtils.isEmpty(list)) {
            throw new RuntimeException("Can't get single. Collection is Null or empty");
        }
        T found = null;
        try {
            for (T el : list) {
                if (!LinqUtils.invokeBoolean(func, el)) continue;
                if (found != null) {
                    return null;
                }
                found = el;
            }
        }
        catch (Exception ex) {
            throw LinqUtils.exception("Can't do single: %s. %s", ex, list);
        }
        return found;
    }

    public static <T> T single(T[] array, Function<T, Boolean> func) {
        return LinqUtils.single(Arrays.asList(array), func);
    }

    public static <T> boolean all(Collection<T> list, Function<T, Boolean> func) {
        if (list == null) {
            return true;
        }
        try {
            for (T el : list) {
                if (LinqUtils.invokeBoolean(func, el)) continue;
                return false;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public static <T> boolean all(T[] array, Function<T, Boolean> func) {
        return LinqUtils.all(Arrays.asList(array), func);
    }

    private static <T> int getStartIndex(List<T> list) {
        try {
            return ReflectionUtils.isInterface(list.getClass(), HasStartIndex.class) ? ((HasStartIndex)((Object)list)).getStartIndex() : 0;
        }
        catch (Exception ex) {
            return 1;
        }
    }

    public static <T> int firstIndex(List<T> list, Function<T, Boolean> func) {
        if (ObjectUtils.isEmpty(list)) {
            return -1;
        }
        try {
            int i = LinqUtils.getStartIndex(list);
            for (T element : list) {
                if (LinqUtils.invokeBoolean(func, element)) {
                    return i;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public static <T> int lastIndex(List<T> list, Function<T, Boolean> func) {
        if (ObjectUtils.isEmpty(list)) {
            return -1;
        }
        try {
            for (int i = list.size() - 1; i >= 0; --i) {
                if (!LinqUtils.invokeBoolean(func, list.get(i))) continue;
                return i + LinqUtils.getStartIndex(list);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public static <T> int firstIndex(T[] array, Function<T, Boolean> func) {
        try {
            if (array == null || array.length == 0) {
                return -1;
            }
            for (int i = 0; i < array.length; ++i) {
                if (!LinqUtils.invokeBoolean(func, array[i])) continue;
                return i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public static <T> T first(Collection<T> list) {
        if (ObjectUtils.isEmpty(list)) {
            throw new RuntimeException("Can't do first. Collection is Null or empty");
        }
        return list.iterator().next();
    }

    public static <T> T first(T[] list) {
        return LinqUtils.first(Arrays.asList(list));
    }

    public static <K, V> V first(Map<K, V> map) {
        if (map == null || map.size() == 0) {
            throw new RuntimeException("Can't do first map. Collection is Null");
        }
        return map.entrySet().iterator().next().getValue();
    }

    public static <T> T first(Collection<T> list, Function<T, Boolean> func) {
        if (ObjectUtils.isEmpty(list)) {
            return null;
        }
        try {
            for (T el : list) {
                if (!LinqUtils.invokeBoolean(func, el)) continue;
                return el;
            }
        }
        catch (Exception ex) {
            throw LinqUtils.exception("Can't do first list: %s. %s", ex, list);
        }
        return null;
    }

    public static <T> T first(T[] list, Function<T, Boolean> func) {
        return LinqUtils.first(Arrays.asList(list), func);
    }

    public static <K, V> V first(Map<K, V> map, Function<K, Boolean> func) {
        if (map == null || map.size() == 0) {
            throw new RuntimeException("Can't do first map. Collection is Null or empty");
        }
        try {
            for (Map.Entry<K, V> el : map.entrySet()) {
                if (!LinqUtils.invokeBoolean(func, el.getKey())) continue;
                return el.getValue();
            }
        }
        catch (Exception ex) {
            throw LinqUtils.exception("Can't do first map: %s. %s", ex, map);
        }
        return null;
    }

    public static <K, V> V first(MapArray<K, V> map, Function<K, Boolean> func) {
        if (ObjectUtils.isEmpty(map)) {
            throw new RuntimeException("Can't do first map. Collection is Null or empty");
        }
        try {
            for (Pair pair : map.pairs) {
                if (!LinqUtils.invokeBoolean(func, pair.key)) continue;
                return (V)pair.value;
            }
        }
        catch (Exception ex) {
            throw LinqUtils.exception("Can't do first map: %s. %s", ex, map);
        }
        return null;
    }

    public static <T> T last(Collection<T> list) {
        if (ObjectUtils.isEmpty(list)) {
            throw new RuntimeException("Can't do last list. Collection is Null or empty");
        }
        T result = null;
        for (T el : list) {
            result = el;
        }
        return result;
    }

    public static <T> T last(T[] list) {
        return LinqUtils.last(Arrays.asList(list));
    }

    public static <T> T last(Collection<T> list, Function<T, Boolean> func) {
        if (ObjectUtils.isEmpty(list)) {
            throw new RuntimeException("Can't do last list. Collection is Null");
        }
        T result = null;
        try {
            for (T el : list) {
                if (!LinqUtils.invokeBoolean(func, el)) continue;
                result = el;
            }
        }
        catch (Exception ex) {
            throw LinqUtils.exception("Can't do last list: %s. %s", ex, list);
        }
        return result;
    }

    public static <T> T last(T[] list, Function<T, Boolean> func) {
        return LinqUtils.last(Arrays.asList(list), func);
    }

    public static <T> T[] toArray(Collection<T> collection, Function<Integer, T[]> constructor) {
        if (collection == null) {
            throw new RuntimeException("Can't do toStringArray. Collection is Null");
        }
        return collection.toArray(constructor.apply(collection.size()));
    }

    public static String[] toStringArray(Collection<String> collection) {
        if (collection == null) {
            throw new RuntimeException("Can't do toStringArray. Collection is Null");
        }
        return collection.toArray(new String[0]);
    }

    public static Integer[] toIntegerArray(Collection<Integer> collection) {
        if (collection == null) {
            throw new RuntimeException("Can't do toIntegerArray. Collection is Null");
        }
        Integer[] result = new Integer[collection.size()];
        int i = 0;
        for (Integer el : collection) {
            result[i++] = el;
        }
        return result;
    }

    public static int[] toIntArray(Collection<Integer> collection) {
        if (collection == null) {
            throw new RuntimeException("Can't do toIntArray. Collection is Null");
        }
        int[] result = new int[collection.size()];
        int i = 0;
        for (int el : collection) {
            result[i++] = el;
        }
        return result;
    }

    public static int getIndex(String[] array, String value) {
        if (array == null || array.length == 0) {
            return -1;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(value)) continue;
            return i;
        }
        return -1;
    }

    public static int getIndex(List<String> list, String value) {
        if (list == null) {
            return -1;
        }
        int i = LinqUtils.getStartIndex(list);
        for (String element : list) {
            if (element.equals(value)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static List<Integer> toList(int ... nums) {
        if (nums == null) {
            throw new RuntimeException(NULL_COLLECTION);
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int num : nums) {
            result.add(num);
        }
        return result;
    }

    public static List<Boolean> toList(boolean ... nums) {
        if (nums == null) {
            throw new RuntimeException(NULL_COLLECTION);
        }
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        for (boolean num : nums) {
            result.add(num);
        }
        return result;
    }

    public static List<Long> toList(long ... nums) {
        if (nums == null) {
            throw new RuntimeException(NULL_COLLECTION);
        }
        ArrayList<Long> result = new ArrayList<Long>();
        for (long num : nums) {
            result.add(num);
        }
        return result;
    }

    public static List<Double> toList(double ... nums) {
        if (nums == null) {
            throw new RuntimeException(NULL_COLLECTION);
        }
        ArrayList<Double> result = new ArrayList<Double>();
        for (double num : nums) {
            result.add(num);
        }
        return result;
    }

    public static List<Float> toList(float ... nums) {
        if (nums == null) {
            throw new RuntimeException(NULL_COLLECTION);
        }
        ArrayList<Float> result = new ArrayList<Float>();
        for (float num : nums) {
            result.add(Float.valueOf(num));
        }
        return result;
    }

    public static List<Byte> toList(byte ... nums) {
        ArrayList<Byte> result = new ArrayList<Byte>();
        for (byte num : nums) {
            result.add(num);
        }
        return result;
    }

    public static <T> List<T> listCopy(List<T> list, int from) {
        return LinqUtils.listCopy(list, from, list.size() - 1);
    }

    public static <T> List<T> listCopy(List<T> list, int from, int to) {
        if (from < 0) {
            from = list.size() + from - 1;
        }
        if (to < 0) {
            to = list.size() + to - 1;
        }
        if (from > to) {
            throw new RuntimeException(String.format("'from' should be more than 'to' %s>%s", from, to));
        }
        ArrayList<T> result = new ArrayList<T>();
        for (int i = from; i <= to; ++i) {
            result.add(list.get(i));
        }
        return result;
    }

    public static List<Integer> listOfRange(int start, int end) {
        return IntStream.rangeClosed(start, end).boxed().collect(Collectors.toList());
    }

    public static <T> List<T> listCopyUntil(List<T> list, int to) {
        return LinqUtils.listCopy(list, 0, to);
    }

    public static <T, R> List<R> selectMany(List<T> list, Function<T, List<R>> func) {
        if (list == null) {
            throw new RuntimeException(NULL_COLLECTION);
        }
        try {
            ArrayList result = new ArrayList();
            for (T el : list) {
                result.addAll(func.apply(el));
            }
            return result;
        }
        catch (Exception ex) {
            throw LinqUtils.exception("Can't do selectMany list: %s. %s", ex, list);
        }
    }

    public static <T> List<T> selectManyArray(List<T> list, Function<T, T[]> func) {
        try {
            ArrayList<T> result = new ArrayList<T>();
            for (T el : list) {
                result.addAll(Arrays.asList(func.apply(el)));
            }
            return result;
        }
        catch (Exception ex) {
            throw LinqUtils.exception("Can't do selectManyArray: %s. %s", ex, list);
        }
    }

    public static <T> boolean listEquals(List<T> list1, List<T> list2) {
        if (list1 == null && list2 == null) {
            return true;
        }
        if (list1 == null || list2 == null || list1.size() != list2.size()) {
            return false;
        }
        ArrayList<T> expectedList = new ArrayList<T>(list2);
        for (T el1 : list1) {
            boolean removed = false;
            for (Object el2 : expectedList) {
                if (!el1.equals(el2)) continue;
                removed = expectedList.remove(el2);
                break;
            }
            if (removed) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean listEquals(List<T> list, T[] array) {
        return LinqUtils.listEquals(list, Arrays.asList(array));
    }

    public static <T> T get(List<T> list, int i) {
        if (list == null) {
            throw new RuntimeException(NULL_COLLECTION);
        }
        int index = i >= 0 ? i : list.size() + i;
        return index >= 0 && index < list.size() ? (T)list.get(index) : null;
    }

    public static <T> T get(T[] array, int i) {
        return Arrays.asList(array).get(i);
    }

    public static <T> boolean contains(List<T> list, T t) {
        return LinqUtils.first(list, (T el) -> el.equals(t)) != null;
    }

    public static <T> boolean contains(T[] list, T t) {
        return LinqUtils.first(list, (T el) -> el.equals(t)) != null;
    }

    public static <T> T valueOrDefault(T value, T defaultValue) {
        return value != null ? value : defaultValue;
    }

    public static <T> List<T> list(T ... elements) {
        return LinqUtils.select(elements, (T e) -> e);
    }

    public static boolean isSorted(Object first, Object second, boolean asc, boolean strict) {
        return asc ? LinqUtils.isAscending(first, second, strict) : LinqUtils.isAscending(second, first, strict);
    }

    public static boolean isAscending(Object first, Object second, boolean strict) {
        try {
            byte a = (Byte)first;
            byte b = (Byte)second;
            return strict ? a < b : a <= b;
        }
        catch (Exception a) {
            try {
                int a2 = (Integer)first;
                int b = (Integer)second;
                return strict ? a2 < b : a2 <= b;
            }
            catch (Exception a2) {
                try {
                    long a3 = (Long)first;
                    long b = (Long)second;
                    return strict ? a3 < b : a3 <= b;
                }
                catch (Exception a3) {
                    try {
                        float a4 = ((Float)first).floatValue();
                        float b = ((Float)second).floatValue();
                        return strict ? a4 < b : a4 <= b;
                    }
                    catch (Exception a4) {
                        try {
                            double a5 = (Double)first;
                            double b = (Double)second;
                            return strict ? a5 < b : a5 <= b;
                        }
                        catch (Exception a5) {
                            try {
                                String a6 = first.toString();
                                String b = second.toString();
                                int compare = a6.compareTo(b);
                                return strict ? compare < 0 : compare <= 0;
                            }
                            catch (Exception exception) {
                                throw new RuntimeException(String.format("isAscending failed because values first='%s' second = '%s' are not comparable", first, second));
                            }
                        }
                    }
                }
            }
        }
    }

    public static RuntimeException exception(String tmpl, Exception ex, Map<?, ?> map) {
        try {
            List<String> m = LinqUtils.selectMap(map, e -> e.getKey().toString() + ":" + e.getValue());
            return new RuntimeException(String.format(tmpl, LinqUtils.safeException(ex), LinqUtils.safePrintCollection(m)));
        }
        catch (Exception exception) {
            return new RuntimeException(tmpl, ex);
        }
    }

    public static String safePrintCollection(Collection<?> list) {
        if (list == null) {
            return "NULL";
        }
        try {
            String result = "[";
            for (Object el : list) {
                result = result + LinqUtils.tryToString(el) + ";";
            }
            return result.substring(0, result.length() - 1) + "]";
        }
        catch (Exception ex) {
            return "Failed to print list";
        }
    }

    private static String tryToString(Object obj) {
        if (obj == null) {
            return "NULL";
        }
        try {
            return obj.toString();
        }
        catch (Exception ex) {
            return "Failed to Print";
        }
    }

    private static RuntimeException exception(String tmpl, Exception ex, Collection<?> list) {
        try {
            return new RuntimeException(String.format(tmpl, LinqUtils.safeException(ex), LinqUtils.safePrintCollection(list)));
        }
        catch (Exception exception) {
            return new RuntimeException(tmpl);
        }
    }

    private static RuntimeException exception(String msg, Collection<?> list) {
        try {
            return new RuntimeException(msg + "| " + LinqUtils.safePrintCollection(list));
        }
        catch (Exception exception) {
            return new RuntimeException(msg);
        }
    }

    private static RuntimeException exception(String msg, Object[] list) {
        return LinqUtils.exception(msg, Arrays.asList(list));
    }

    public static String safeException(Throwable ex) {
        String msg = ex.getMessage();
        try {
            if (StringUtils.isBlank((CharSequence)msg) && ReflectionUtils.isClass(ex.getClass(), InvocationTargetException.class)) {
                msg = ((InvocationTargetException)ex).getTargetException().getMessage();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return StringUtils.isNotBlank((CharSequence)msg) ? msg : ex.toString();
    }
}

