/*
 * Decompiled with CFR 0.152.
 */
package com.jdiai.tools;

import java.io.File;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;

public class PathUtils {
    private PathUtils() {
    }

    public static String path(String first, String ... more) {
        return Paths.get(first, more).toAbsolutePath().toString();
    }

    public static String mergePath(String root, String ... suffix) {
        root = PathUtils.toStandardSlash(root);
        if ((suffix = PathUtils.toStandardSlash(suffix)).length == 1 && suffix[0].contains(File.separator)) {
            String path = suffix[0];
            if (path.charAt(0) == File.separator.charAt(0)) {
                path = path.substring(1);
            }
            suffix = path.split(PathUtils.encodedSeparator());
        }
        if (root.charAt(root.length() - 1) == File.separator.charAt(0)) {
            root = root.substring(0, root.length() - 1);
        }
        return root + File.separator + String.join((CharSequence)File.separator, suffix);
    }

    public static String encodedSeparator() {
        return "\\" + File.separator;
    }

    private static String toStandardSlash(String s) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return "";
        }
        return File.separator.equals("\\") ? s.replace("/", PathUtils.encodedSeparator()) : s.replace("\\\\", File.separator);
    }

    private static String[] toStandardSlash(String ... strings) {
        String[] result = new String[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            result[i] = PathUtils.toStandardSlash(strings[i]);
        }
        return result;
    }
}

