/*
 * Decompiled with CFR 0.152.
 */
package com.jdiai.tools;

import com.jdiai.tools.LinqUtils;
import com.jdiai.tools.ReflectionUtils;
import com.jdiai.tools.map.MapArray;
import com.jdiai.tools.pairs.Pair;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class PrintUtils {
    private PrintUtils() {
    }

    public static String print(Collection<String> list) {
        return PrintUtils.print(list, ",", "%s");
    }

    public static String print(Collection<String> list, String separator) {
        return PrintUtils.print(list, separator, "%s");
    }

    public static <T extends Enum> String printEnum(List<T> enums) {
        return enums != null ? String.join((CharSequence)",", PrintUtils.toList(enums, (T el) -> String.format("%s", el))) : "";
    }

    public static String print(Collection<String> list, String separator, String format) {
        return list != null ? String.join((CharSequence)separator, PrintUtils.toList(list, (T el) -> String.format(format, el))) : "";
    }

    public static String print(String[] list) {
        return PrintUtils.print(list, ",", "%s");
    }

    public static String print(String[] list, String separator) {
        return PrintUtils.print(list, separator, "%s");
    }

    public static String print(String[] list, String separator, String format) {
        return PrintUtils.print(Arrays.asList(list), separator, format);
    }

    public static <T> String print(Map<String, T> map, String separator, String format) {
        return PrintUtils.print(PrintUtils.toList(map, (K k, V v) -> MessageFormat.format(format, k, v)), separator, "%s");
    }

    public static <T> String print(Map<String, T> map, String separator) {
        return PrintUtils.print(map, separator, "{0}:{1}");
    }

    public static <T> String print(Map<String, T> map) {
        return PrintUtils.print(map, ";", "{0}:{1}");
    }

    public static String print(int[] list) {
        return PrintUtils.print(list, ",", "%s");
    }

    public static String print(int[] list, String separator) {
        return PrintUtils.print(list, separator, "%s");
    }

    public static String print(int[] list, String separator, String format) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i : list) {
            result.add(Integer.toString(i));
        }
        return PrintUtils.print(result, separator, format);
    }

    public static String print(boolean[] list) {
        return PrintUtils.print(list, ",", "%s");
    }

    public static String print(boolean[] list, String separator) {
        return PrintUtils.print(list, separator, "%s");
    }

    public static String print(boolean[] list, String separator, String format) {
        ArrayList<String> result = new ArrayList<String>();
        for (boolean i : list) {
            result.add(Boolean.toString(i));
        }
        return PrintUtils.print(result, separator, format);
    }

    public static String printFields(Object obj) {
        return PrintUtils.printFields(obj, "; ");
    }

    public static String printFields(Object obj, String separator) {
        String className = obj.getClass().getSimpleName();
        String params = PrintUtils.print(PrintUtils.toList(ReflectionUtils.getFieldsDeep(obj), field -> ReflectionUtils.getValueField(field, obj) != null, field -> String.format("%s:%s", field.getName(), ReflectionUtils.getValueField(field, obj))), separator, "%s");
        return String.format("%s(%s)", className, params);
    }

    public static <T> String print(Collection<T> list, Function<T, String> func) {
        return PrintUtils.print(PrintUtils.toList(list, func));
    }

    public static <T> String print(Collection<T> list, Function<T, String> func, String separator) {
        return PrintUtils.print(PrintUtils.toList(list, func), separator);
    }

    public static <T> String print(Collection<T> list, Function<T, String> func, String separator, String format) {
        return PrintUtils.print(PrintUtils.toList(list, func), separator, format);
    }

    public static String formatParams(String template, MapArray<String, String> params) {
        String result = template;
        for (Pair<String, String> pair : params) {
            result = result.replaceAll("\\{" + (String)pair.key + "}", (String)pair.value);
        }
        return result;
    }

    public static String printList(Object obj) {
        List list = (List)obj;
        String result = "[";
        for (Object el : list) {
            result = result + el + ", ";
        }
        return result + list.get(list.size() - 1) + "]";
    }

    public static String printArray(Object array) {
        try {
            Object[] a = (Object[])array;
            if (a.length == 1) {
                return a[0].toString();
            }
            return Arrays.toString(a);
        }
        catch (Exception a) {
            try {
                int[] a2 = (int[])array;
                if (a2.length == 1) {
                    return String.valueOf(a2[0]);
                }
                return Arrays.toString(a2);
            }
            catch (Exception a2) {
                try {
                    boolean[] a3 = (boolean[])array;
                    if (a3.length == 1) {
                        return String.valueOf(a3[0]);
                    }
                    return Arrays.toString(a3);
                }
                catch (Exception a3) {
                    try {
                        float[] a4 = (float[])array;
                        if (a4.length == 1) {
                            return String.valueOf(a4[0]);
                        }
                        return Arrays.toString(a4);
                    }
                    catch (Exception a4) {
                        try {
                            double[] a5 = (double[])array;
                            if (a5.length == 1) {
                                return String.valueOf(a5[0]);
                            }
                            return Arrays.toString(a5);
                        }
                        catch (Exception a5) {
                            try {
                                char[] a6 = (char[])array;
                                if (a6.length == 1) {
                                    return String.valueOf(a6[0]);
                                }
                                return Arrays.toString(a6);
                            }
                            catch (Exception a6) {
                                try {
                                    byte[] a7 = (byte[])array;
                                    if (a7.length == 1) {
                                        return String.valueOf(a7[0]);
                                    }
                                    return Arrays.toString(a7);
                                }
                                catch (Exception exception) {
                                    return "Unsupported array";
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private static RuntimeException getPrintException(Exception ex, int index) {
        return new RuntimeException(String.format("Can't print list: %s; Failed to print at index: %s", LinqUtils.safeException(ex), index), ex);
    }

    private static <T, TR> List<TR> toList(Collection<T> list, Function<T, TR> func) {
        if (list == null) {
            throw new RuntimeException("Can't do select list. Collection is Null");
        }
        int index = 0;
        try {
            CopyOnWriteArrayList<TR> result = new CopyOnWriteArrayList<TR>();
            for (T el : list) {
                result.add(func.apply(el));
                ++index;
            }
            return result;
        }
        catch (Exception ex) {
            throw PrintUtils.getPrintException(ex, index);
        }
    }

    public static <K, V, TR> List<TR> toList(Map<K, V> map, BiFunction<K, V, TR> func) {
        if (map == null) {
            throw new RuntimeException("Can't do toList. Map is Null");
        }
        int index = 0;
        try {
            CopyOnWriteArrayList<TR> result = new CopyOnWriteArrayList<TR>();
            for (Map.Entry<K, V> el : map.entrySet()) {
                result.add(func.apply(el.getKey(), el.getValue()));
                ++index;
            }
            return result;
        }
        catch (Exception ex) {
            throw PrintUtils.getPrintException(ex, index);
        }
    }

    public static <T, R> List<R> toList(Collection<T> list, Function<T, Boolean> condition, Function<T, R> transform) {
        int index = 0;
        try {
            ArrayList<R> result = new ArrayList<R>();
            for (T el : list) {
                if (LinqUtils.invokeBoolean(condition, el)) {
                    result.add(transform.apply(el));
                }
                ++index;
            }
            return result;
        }
        catch (Exception ex) {
            throw PrintUtils.getPrintException(ex, index);
        }
    }
}

