/*
 * Decompiled with CFR 0.152.
 */
package com.jdiai.tools;

import com.jdiai.tools.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.function.Consumer;

public class PropReader {
    private String propertiesPath;
    private volatile Properties properties;
    private InputStream inputStream;

    public PropReader(String path) {
        this.propertiesPath = path;
    }

    public String getPath() {
        if (this.propertiesPath.charAt(0) != '/') {
            this.propertiesPath = "/" + this.propertiesPath;
        }
        return this.propertiesPath;
    }

    public Properties readProperties() {
        this.properties = new Properties();
        try {
            this.inputStream = PropReader.class.getResourceAsStream(this.getPath());
            if (this.inputStream != null) {
                this.properties.load(this.inputStream);
            }
        }
        catch (Exception ex) {
            try {
                if (this.inputStream != null) {
                    this.inputStream.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.properties;
    }

    public Properties loadProperties() {
        return this.properties != null ? this.properties : this.readProperties();
    }

    public Properties getProperties() {
        return this.readProperties();
    }

    public String getProperty(String propertyName) {
        return this.loadProperties().getProperty(propertyName);
    }

    public void fillAction(Consumer<String> action, String name) {
        String prop = null;
        try {
            prop = this.getProperty(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)prop)) {
            return;
        }
        if (this.isMvnProperty(prop)) {
            throw new RuntimeException(String.format("Can't read Maven property '%s'. Get value '%s'" + StringUtils.LINE_BREAK + "You need to add property in pom.xml and add <resources> block in <build>. See example: https://github.com/jdi-templates/jdi-light-testng-template/blob/master/pom.xml", name, prop));
        }
        action.accept(prop);
    }

    private boolean isMvnProperty(String prop) {
        return prop.matches("^\\$\\{.+}");
    }
}

