/*
 * Decompiled with CFR 0.152.
 */
package com.jdiai.tools;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class PropertyReader {
    private static String propertiesPath;
    private static volatile Properties properties;
    private static InputStream inputStream;

    private PropertyReader() {
    }

    public static String getPath() {
        if (StringUtils.isBlank((CharSequence)propertiesPath)) {
            return "";
        }
        if (propertiesPath.charAt(0) != '/') {
            propertiesPath = "/" + propertiesPath;
        }
        return propertiesPath;
    }

    public static Properties readProperties() {
        properties = new Properties();
        try {
            inputStream = PropertyReader.class.getResourceAsStream(PropertyReader.getPath());
            if (inputStream != null) {
                properties.load(inputStream);
            }
        }
        catch (Exception ex) {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return properties;
    }

    public static Properties loadProperties() {
        return properties != null ? properties : PropertyReader.readProperties();
    }

    public static Properties getProperties(String path) {
        propertiesPath = path;
        return PropertyReader.readProperties();
    }

    public static boolean hasProperty(String name) {
        try {
            return StringUtils.isNotBlank((CharSequence)PropertyReader.getProperty(name));
        }
        catch (Exception ignore) {
            return false;
        }
    }

    public static String getProperty(String propertyName) {
        String prop = null;
        try {
            prop = PropertyReader.loadProperties().getProperty(propertyName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (StringUtils.isBlank((CharSequence)prop)) {
            return "";
        }
        if (PropertyReader.isMvnProperty(prop)) {
            prop = PropertyReader.replaceProperty(prop);
        }
        return prop;
    }

    public static void fillAction(Consumer<String> action, String name) {
        String property = PropertyReader.getProperty(name);
        if (StringUtils.isBlank((CharSequence)property)) {
            return;
        }
        action.accept(property);
    }

    private static boolean isMvnProperty(String prop) {
        return prop.matches("^\\$\\{.+}");
    }

    private static String replaceProperty(String property) {
        Matcher matcher = Pattern.compile("\\$\\{([^}]*)}").matcher(property);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String pattern = matcher.group(1);
            String replacement = System.getProperty(pattern);
            if (replacement == null) {
                replacement = property;
            }
            matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

