/*
 * Decompiled with CFR 0.152.
 */
package com.jdiai.tools;

import com.jdiai.tools.LinqUtils;
import com.jdiai.tools.PrintUtils;
import com.jdiai.tools.map.MapArray;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.ObjectUtils;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static boolean isClass(Field field, Class<?> expected) {
        return ReflectionUtils.isClass(field.getType(), expected);
    }

    public static boolean isClass(Class<?> t, Class<?> expected) {
        if (expected == Object.class) {
            return true;
        }
        for (Class<?> type = t; type != null && type != Object.class; type = type.getSuperclass()) {
            if (type != expected) continue;
            return true;
        }
        return ReflectionUtils.isInterface(t, expected);
    }

    public static boolean isClassOr(Class<?> type, Class<?> ... expected) {
        for (Class<?> expectedType : expected) {
            if (!ReflectionUtils.isClass(type, expectedType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isClassAnd(Class<?> type, Class<?> ... expected) {
        for (Class<?> expectedType : expected) {
            if (ReflectionUtils.isClass(type, expectedType)) continue;
            return false;
        }
        return true;
    }

    public static boolean isInterface(Field field, Class<?> expected) {
        return ReflectionUtils.isInterface(field.getType(), expected);
    }

    public static boolean isInterfaceAnd(Class<?> type, Class<?> ... interfaces) {
        for (Class<?> i : interfaces) {
            if (ReflectionUtils.isInterface(type, i)) continue;
            return false;
        }
        return true;
    }

    public static boolean isInterfaceOr(Class<?> type, Class<?> ... interfaces) {
        for (Class<?> i : interfaces) {
            if (!ReflectionUtils.isInterface(type, i)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInterface(Class<?> type, Class<?> expected) {
        if (type == null || expected == null || type == Object.class) {
            return false;
        }
        if (type == expected) {
            return true;
        }
        List<Class<?>> interfaces = Arrays.asList(type.getInterfaces());
        return LinqUtils.any(interfaces, i -> ReflectionUtils.isInterface(i, expected)) || ReflectionUtils.isInterface(type.getSuperclass(), expected);
    }

    public static MapArray<String, Object> getAllFields(Object obj) {
        return new MapArray<String, Object>(ReflectionUtils.getFields(obj, Object.class), Field::getName, f -> ReflectionUtils.getValueField(f, obj), true);
    }

    public static List<Field> getFields(Object obj) {
        return ReflectionUtils.getFields(obj, new Class[0], new Class[]{null});
    }

    public static List<Field> getFieldsDeep(Field field) {
        return ReflectionUtils.getFieldsDeep(field.getType());
    }

    public static List<Field> getFieldsDeep(Class<?> cl) {
        return ReflectionUtils.getFieldsDeep(cl, Object.class);
    }

    public static List<Field> getFieldsDeep(Class<?> cl, Class<?> stopClass) {
        return ReflectionUtils.recursion(cl, t -> t != null && !t.equals(stopClass), s -> Arrays.asList(s.getDeclaredFields()));
    }

    public static List<Field> getFieldsDeep(Object obj) {
        return ReflectionUtils.getFieldsDeep(obj, Object.class);
    }

    public static List<Field> getFieldsDeep(Object obj, Class<?> ... stopClasses) {
        return ReflectionUtils.getFieldsRegress(obj, new Class[0], stopClasses);
    }

    public static List<Field> getFields(Object obj, Class<?> ... stopTypes) {
        return ReflectionUtils.getFieldsRegress(obj, stopTypes, Object.class);
    }

    public static List<Field> getFields(Object obj, Class<?>[] filterTypes, Class<?> ... stopTypes) {
        return ReflectionUtils.getFields(obj, ReflectionUtils.getFieldsDeep(obj.getClass(), stopTypes), filterTypes, (Field f) -> !Modifier.isStatic(f.getModifiers()));
    }

    public static List<Field> getFieldsRegress(Object obj, Class<?>[] filterTypes, Class<?> ... stopTypes) {
        return ReflectionUtils.getFields(obj, ReflectionUtils.getFieldsRegress(obj.getClass(), stopTypes), filterTypes, (Field f) -> !Modifier.isStatic(f.getModifiers()));
    }

    public static List<Field> getFieldsExact(Class<?> cl) {
        return ReflectionUtils.getTypeFields(cl);
    }

    public static List<Field> getFieldsExact(Class<?> cl, Function<Field, Boolean> filter) {
        return LinqUtils.filter(ReflectionUtils.getFieldsExact(cl), filter);
    }

    public static List<Field> getFieldsExact(Class<?> cl, Class<?> ... stopTypes) {
        return ReflectionUtils.getFieldsExact(cl, (Field f) -> LinqUtils.any(stopTypes, stopType -> f.getType() == stopType));
    }

    public static List<Field> getFieldsExact(Class<?> cl, Class<?> stopType) {
        return ReflectionUtils.getFieldsExact(cl, (Field f) -> f.getType() == stopType);
    }

    public static List<Field> getFieldsExact(Object obj, Class<?> ... stopTypes) {
        return ReflectionUtils.getFieldsExact(obj.getClass(), stopTypes);
    }

    public static List<Field> getFields(List<Field> fields, Class<?>[] filterTypes, Function<Field, Boolean> filter) {
        return ReflectionUtils.getFields(null, fields, filterTypes, filter);
    }

    public static List<Field> getFieldsInterfaceOf(Object obj, Class<?> ... filterTypes) {
        return ReflectionUtils.getFields(obj, ReflectionUtils.getTypeFields(obj.getClass()), filterTypes, (Field f) -> true);
    }

    public static List<Field> getFields(Object obj, List<Field> fields, Class<?>[] filterTypes, Function<Field, Boolean> filter) {
        if (obj == null) {
            return new ArrayList<Field>();
        }
        ArrayList<Field> result = new ArrayList<Field>();
        try {
            for (Field field : fields) {
                if (!LinqUtils.invokeBoolean(filter, field)) continue;
                Object value = ReflectionUtils.getValueField(field, obj);
                if (value != null) {
                    if (!ReflectionUtils.isExpectedClass(value, filterTypes)) continue;
                    result.add(field);
                    continue;
                }
                if (!ReflectionUtils.isExpectedClass(field, filterTypes)) continue;
                result.add(field);
            }
            return result;
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Failed to get Fields from '%s'; fields: %s; filterTypes: %s", obj.getClass().getSimpleName(), PrintUtils.print(fields, Field::getName), PrintUtils.print(Arrays.asList(filterTypes), Class::getSimpleName)));
        }
    }

    public static List<Field> getFieldsRegress(Class<?> type, Class<?> ... stopTypes) {
        if (stopTypes == null || stopTypes.length == 0) {
            return ReflectionUtils.getTypeFields(type);
        }
        return ReflectionUtils.recursion(type, t -> !t.equals(Object.class), stopTypes.length == 1 && stopTypes[0] == Object.class ? ReflectionUtils::getFieldsDeep3 : t -> ReflectionUtils.getFieldsDeep2(t, stopTypes));
    }

    public static List<Field> recursion(Class<?> objType, Function<Class<?>, Boolean> condition, Function<Class<?>, List<Field>> func) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (LinqUtils.invokeBoolean(condition, objType)) {
            List<Field> fList = func.apply(objType);
            for (Field field : fList) {
                Field notUnique = LinqUtils.first(fields, f -> f.getName().equals(field.getName()));
                if (notUnique != null) {
                    fields.remove(notUnique);
                }
                fields.add(field);
            }
            objType = objType.getSuperclass();
        }
        return fields;
    }

    public static List<Field> getFieldsDeep(Class<?> type, Class<?> ... stopTypes) {
        if (stopTypes == null || stopTypes.length == 0) {
            return ReflectionUtils.getTypeFields(type);
        }
        return stopTypes.length == 1 && stopTypes[0] == Object.class ? ReflectionUtils.getFieldsDeep3(type) : ReflectionUtils.getFieldsDeep2(type, stopTypes);
    }

    private static List<Field> getFieldsDeep3(Class<?> type) {
        return type == Object.class ? new ArrayList<Field>() : new ArrayList<Field>(ReflectionUtils.getTypeFields(type));
    }

    private static List<Field> getFieldsDeep2(Class<?> type, Class<?>[] stopTypes) {
        return Arrays.asList(stopTypes).contains(type) || type == Object.class ? new ArrayList<Field>() : new ArrayList<Field>(ReflectionUtils.getTypeFields(type));
    }

    public static <T> T getFirstField(Object obj, Class<?> ... types) {
        return (T)ReflectionUtils.getValueField(LinqUtils.first(ReflectionUtils.getTypeFields(obj.getClass()), field -> ReflectionUtils.isExpectedClass(field, types)), obj);
    }

    private static boolean isExpectedClass(Field field, Class<?> ... types) {
        if (types == null || types.length == 0) {
            return true;
        }
        for (Class<?> type : types) {
            if (!ReflectionUtils.isClass(field, type) && !ReflectionUtils.isInterface(field, type)) continue;
            return true;
        }
        return false;
    }

    private static boolean isExpectedClass(Object obj, Class<?> ... types) {
        if (obj == null) {
            return false;
        }
        if (types == null || types.length == 0) {
            return true;
        }
        for (Class<?> type : types) {
            if (!ReflectionUtils.isClass(obj.getClass(), type) && !ReflectionUtils.isInterface(obj.getClass(), type)) continue;
            return true;
        }
        return false;
    }

    public static Object getValueField(Field field, Object obj) {
        field.setAccessible(true);
        try {
            return field.get(obj);
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Can't get field '%s' value", field.getName()));
        }
    }

    public static Object stringToPrimitive(String str) {
        if (str.equalsIgnoreCase("true")) {
            return true;
        }
        if (str.equalsIgnoreCase("false")) {
            return false;
        }
        try {
            return Byte.parseByte(str);
        }
        catch (Exception exception) {
            try {
                return Short.parseShort(str);
            }
            catch (Exception exception2) {
                try {
                    return Byte.parseByte(str);
                }
                catch (Exception exception3) {
                    try {
                        return Integer.parseInt(str);
                    }
                    catch (Exception exception4) {
                        try {
                            return Long.parseLong(str);
                        }
                        catch (Exception exception5) {
                            try {
                                return Float.valueOf(Float.parseFloat(str));
                            }
                            catch (Exception exception6) {
                                try {
                                    return Double.parseDouble(str);
                                }
                                catch (Exception exception7) {
                                    return str;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public static Object convertStringToType(String value, Class<?> clazz) {
        if (clazz.isAssignableFrom(String.class) || value == null) {
            return value;
        }
        if (clazz.isAssignableFrom(Byte.class)) {
            return Byte.parseByte(value);
        }
        if (clazz.isAssignableFrom(Short.class)) {
            return Short.parseShort(value);
        }
        if (clazz.isAssignableFrom(Integer.class)) {
            return Integer.parseInt(value);
        }
        if (clazz.isAssignableFrom(Long.class)) {
            return Long.parseLong(value);
        }
        if (clazz.isAssignableFrom(Float.class)) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (clazz.isAssignableFrom(Double.class)) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (clazz.isAssignableFrom(Boolean.class)) {
            return Boolean.parseBoolean(value);
        }
        throw new IllegalArgumentException("Can't parse field string " + value + ". Type [" + clazz + "] is unsupported");
    }

    public static Object convertStringToType(String value, Field field) {
        Class<?> clazz = field.getType();
        try {
            return ReflectionUtils.convertStringToType(value, clazz);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Can't parse field " + field.getName() + ". Type [" + clazz + "] is unsupported");
        }
    }

    public static <T> Class<T> checkEntityIsNotNull(Class<T> entityClass) {
        if (entityClass == null) {
            throw new IllegalArgumentException("Entity type was not specified");
        }
        return entityClass;
    }

    public static <T> T newEntity(Class<T> entityClass) {
        try {
            return entityClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't instantiate " + entityClass.getSimpleName() + ". You must have empty constructor to do this");
        }
    }

    private static List<Field> getTypeFields(Class<?> type) {
        Field[] fields = type.getDeclaredFields();
        return LinqUtils.filter(fields, f -> !f.getName().contains("$"));
    }

    private static <T> T csInit(Constructor<?> cs, Object ... params) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        cs.setAccessible(true);
        return (T)cs.newInstance(params);
    }

    public static <T> T create(Class<T> cs) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        if (cs == null) {
            throw new RuntimeException("Can't init class. Class Type is null.");
        }
        Constructor<?>[] constructors = cs.getDeclaredConstructors();
        Constructor constructor = LinqUtils.first(constructors, c -> c.getParameterCount() == 0);
        if (constructor != null) {
            return ReflectionUtils.csInit(constructor, new Object[0]);
        }
        throw new RuntimeException(String.format("%s has no empty constructors", cs.getSimpleName()));
    }

    public static <T> T create(Class<T> cs, Object ... params) {
        if (cs == null) {
            throw new RuntimeException("Can't init class. Class Type is null.");
        }
        Constructor<?>[] constructors = cs.getDeclaredConstructors();
        List<Constructor> listConst = LinqUtils.filter(constructors, c -> c.getParameterCount() == params.length);
        if (ObjectUtils.isEmpty(listConst)) {
            throw new RuntimeException(String.format("%s has no constructor with %s params", cs.getSimpleName(), params.length));
        }
        for (Constructor cnst : listConst) {
            try {
                return ReflectionUtils.csInit(cnst, params);
            }
            catch (Exception exception) {
            }
        }
        throw new RuntimeException(String.format("%s has no appropriate constructors", cs.getSimpleName()));
    }

    public static boolean isList(Field f, Function<Class<?>, Boolean> func) {
        try {
            return f.getType() == List.class && func.apply(ReflectionUtils.getGenericType(f)) != false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isList(Class<?> clazz, Function<Class<?>, Boolean> func) {
        try {
            return clazz == List.class && func.apply(ReflectionUtils.getGenericType(clazz)) != false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isList(Field f, Class<?> type) {
        return ReflectionUtils.isList(f, (Class<?> g) -> g == type);
    }

    public static boolean isListOf(Field field, Class<?> type) {
        return ReflectionUtils.isList(field, (Class<?> g) -> ReflectionUtils.isClass(g, type) || ReflectionUtils.isInterface(g, type));
    }

    public static Type[] getGenericTypes(Field field) {
        try {
            Class cl = field.getGenericType();
            while (!cl.getTypeName().endsWith("Object")) {
                try {
                    return ((ParameterizedType)((Object)cl)).getActualTypeArguments();
                }
                catch (ClassCastException ignore) {
                    try {
                        cl = ((Class)cl).getGenericSuperclass();
                    }
                    catch (ClassCastException ignore2) {
                        try {
                            cl = ((Class)cl).getSuperclass();
                        }
                        catch (ClassCastException ignore3) {
                            return new Type[0];
                        }
                    }
                }
            }
            return new Type[0];
        }
        catch (Throwable ex) {
            throw new RuntimeException(String.format("'%s' is List but has no Generic types", field.getName()), ex);
        }
    }

    public static Class<?> getGenericType(Field field) {
        try {
            return (Class)ReflectionUtils.getGenericTypes(field)[0];
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("'%s' is List but has no Generic types", field.getName()), ex);
        }
    }

    public static Class<?> getGenericType(Class<?> clazz) {
        try {
            return (Class)((ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments()[0];
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("'%s' is List but has no Generic type", clazz.getName()), ex);
        }
    }
}

