/*
 * Decompiled with CFR 0.152.
 */
package com.jdiai.tools;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;

public class Safe<T>
extends ThreadLocal<T> {
    private Supplier<T> DEFAULT;
    Map<Long, T> threadValues = new ConcurrentHashMap<Long, T>();

    public Safe() {
        this(() -> null);
    }

    public Safe(Supplier<T> func) {
        this.DEFAULT = func;
    }

    public Safe(T value) {
        this(() -> value);
    }

    @Override
    public T get() {
        T value;
        long threadId = this.threadId();
        if (this.hasValue()) {
            return this.threadValues.get(threadId);
        }
        if (this.threadValues.size() == 1 && this.threadValues.containsKey(1L)) {
            value = this.threadValues.get(1L);
            this.threadValues.clear();
        } else {
            value = this.DEFAULT.get();
        }
        this.update(threadId, value);
        return value;
    }

    @Override
    public void set(T value) {
        this.update(this.threadId(), value);
    }

    public void update(Function<T, T> func) {
        this.set(func.apply(this.get()));
    }

    public boolean hasValue() {
        return this.threadValues.containsKey(this.threadId());
    }

    public void reset() {
        this.set(this.DEFAULT.get());
    }

    public T getDefault() {
        return this.DEFAULT.get();
    }

    private long threadId() {
        return Thread.currentThread().getId();
    }

    private void update(long threadId, T value) {
        this.threadValues.compute(threadId, (k, v) -> value);
    }

    public String toString() {
        return this.threadValues.keySet().toString();
    }
}

