/*
 * Decompiled with CFR 0.152.
 */
package com.jdiai.tools;

import com.jdiai.tools.ReflectionUtils;
import com.jdiai.tools.map.MapArray;
import com.jdiai.tools.pairs.Pair;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;

public final class StringUtils {
    public static final String LINE_BREAK = System.getProperty("line.separator");

    public static boolean namesEqual(String name1, String name2) {
        return name1.replace(" ", "").equalsIgnoreCase(name2.replace(" ", ""));
    }

    public static String msgFormat(String template, List<Object> args) {
        String result = template;
        int i = 0;
        for (Object arg : args) {
            if (template.contains("{" + i + "}")) {
                result = result.replaceAll("\\{" + i + "}", arg.toString());
            }
            ++i;
        }
        return result;
    }

    public static String msgFormat(String template, Object ... args) {
        String result = template;
        int i = 0;
        for (Object arg : args) {
            if (template.contains("{" + i + "}")) {
                result = result.replaceAll("\\{" + i + "}", arg.toString().replace("$", "\\$"));
            }
            ++i;
        }
        return result;
    }

    public static String msgFormat(String template, Object obj) {
        return StringUtils.msgFormat(template, ReflectionUtils.getAllFields(obj));
    }

    public static String msgFormat(String template, MapArray<String, Object> args) {
        Matcher matcher = Pattern.compile("\\{([^}]*)}").matcher(template);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String pattern = matcher.group(1);
            Object replacement = args.get(pattern);
            if (replacement == null) {
                replacement = matcher.group();
            }
            matcher.appendReplacement(sb, Matcher.quoteReplacement(StringUtils.getValue(replacement)));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static String getValue(Object obj) {
        Supplier supplier;
        try {
            supplier = (Supplier)obj;
        }
        catch (Exception ignore) {
            supplier = null;
        }
        if (supplier != null) {
            return (String)supplier.get();
        }
        return obj != null ? obj.toString() : "";
    }

    public static String msgFormat(String template, Pair<String, Object> ... pairs) {
        return StringUtils.msgFormat(template, MapArray.map(pairs));
    }

    public static boolean contains(String string, String[] strings) {
        return StringUtils.contains(string, Arrays.asList(strings));
    }

    public static boolean contains(String string, List<String> strings) {
        for (String s : strings) {
            if (string.contains(s)) continue;
            return false;
        }
        return true;
    }

    public static String splitLowerCase(String value) {
        String result = "";
        for (int i = 0; i < value.length(); ++i) {
            if (Character.isUpperCase(value.charAt(i))) {
                result = result + " ";
            }
            result = result + Character.toLowerCase(value.charAt(i));
        }
        return result;
    }

    public static String splitFirstCapital(String name) {
        String result = Character.toUpperCase(name.charAt(0)) + "";
        char previousLetter = name.charAt(0);
        for (int i = 1; i < name.length() - 1; ++i) {
            if (!Character.isDigit(name.charAt(i)) && !Character.isLetter(name.charAt(i))) continue;
            if (Character.isUpperCase(name.charAt(i)) && Character.isLowerCase(previousLetter) || !Character.isDigit(name.charAt(i - 1)) && !Character.isLetter(name.charAt(i - 1))) {
                result = result + " ";
            }
            result = result + Character.toLowerCase(name.charAt(i));
            previousLetter = name.charAt(i);
        }
        return result + name.charAt(name.length() - 1);
    }

    public static String splitCamelCase(String value) {
        String result = (value.charAt(0) + "").toUpperCase();
        for (int i = 1; i < value.length() - 1; ++i) {
            result = result + (Character.isUpperCase(value.charAt(i)) && (Character.isLowerCase(value.charAt(i + 1)) || Character.isLowerCase(value.charAt(i - 1))) ? " " : "") + value.charAt(i);
        }
        return result + value.charAt(value.length() - 1);
    }

    private static String cleanupString(String text) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)text)) {
            return "";
        }
        return text.replaceAll("[^a-zA-Z0-9 ]", "").trim().replaceAll(" +", " ");
    }

    public static String toCamelCase(String value) {
        String result = StringUtils.cleanupString(value);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)(result = result.replace(" ", "")))) {
            return "";
        }
        return Character.toLowerCase(result.charAt(0)) + result.substring(1);
    }

    public static String toPascalCase(String value) {
        String result = StringUtils.cleanupString(value);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)(result = result.replace(" ", "")))) {
            return "";
        }
        return Character.toUpperCase(result.charAt(0)) + result.substring(1);
    }

    public static String toSnakeCase(String value) {
        String clean = StringUtils.cleanupString(value);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)clean)) {
            return "";
        }
        return StringUtils.processString(clean, "_").toLowerCase();
    }

    public static String toKebabCase(String value) {
        String clean = StringUtils.cleanupString(value);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)clean)) {
            return "";
        }
        return StringUtils.processString(clean, "-").toLowerCase();
    }

    public static String toUpperSnakeCase(String value) {
        String clean = StringUtils.cleanupString(value).toUpperCase();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)clean)) {
            return "";
        }
        return StringUtils.processString(clean, "_").toUpperCase();
    }

    private static String processString(String str, String splitter) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)str) || str.length() < 3) {
            return str;
        }
        String result = "" + str.charAt(0);
        for (int i = 1; i < str.length() - 1; ++i) {
            if (str.charAt(i) == ' ') {
                if (!Character.isLetter(str.charAt(i + 1))) continue;
                result = result + splitter;
                continue;
            }
            if (Character.isUpperCase(str.charAt(i)) && Character.isLetter(str.charAt(i - 1)) && Character.isLetter(str.charAt(i + 1)) && (Character.isLowerCase(str.charAt(i - 1)) || Character.isLowerCase(str.charAt(i + 1)))) {
                result = result + splitter;
            }
            result = result + str.charAt(i);
        }
        return result + str.charAt(str.length() - 1);
    }

    public static String splitHyphen(String value) {
        String text = StringUtils.cleanupString(value);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)text)) {
            return "";
        }
        return text.toLowerCase().replace(" ", "-");
    }

    public static String correctPath(String path) {
        return path.replace("\\", File.separator);
    }

    public static String format(String s, Object ... args) {
        return args.length > 0 ? String.format(s, args) : s;
    }

    public static List<String> inputStreamToList(InputStream stream) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            while ((line = reader.readLine()) != null) {
                list.add(line);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't read Input Stream: " + ex.getMessage());
        }
        return list;
    }

    public static String arrayToString(Object array) {
        String result = "";
        boolean first = true;
        for (Object a : (Object[])array) {
            if (first) {
                first = false;
            } else {
                result = result + ",";
            }
            result = result + a.toString();
        }
        return result;
    }

    public static void setPrimitiveField(Field field, Object obj, String value) {
        field.setAccessible(true);
        try {
            if (String.class.isAssignableFrom(field.getType())) {
                field.set(obj, value);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (Boolean.TYPE.isAssignableFrom(field.getType())) {
                field.set(obj, Boolean.parseBoolean(value));
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (Character.TYPE.isAssignableFrom(field.getType())) {
                field.set(obj, Character.valueOf(value.charAt(0)));
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (Byte.TYPE.isAssignableFrom(field.getType())) {
                field.set(obj, DatatypeConverter.parseByte((String)value));
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (Short.TYPE.isAssignableFrom(field.getType())) {
                field.set(obj, DatatypeConverter.parseShort((String)value));
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (Integer.TYPE.isAssignableFrom(field.getType())) {
                field.set(obj, Integer.parseInt(value));
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (Long.TYPE.isAssignableFrom(field.getType())) {
                field.set(obj, DatatypeConverter.parseLong((String)value));
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (Float.TYPE.isAssignableFrom(field.getType())) {
                field.set(obj, Float.valueOf(DatatypeConverter.parseFloat((String)value)));
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (Double.TYPE.isAssignableFrom(field.getType())) {
                field.set(obj, DatatypeConverter.parseDouble((String)value));
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (Boolean.class.isAssignableFrom(field.getType())) {
                field.set(obj, Boolean.parseBoolean(value));
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (Character.class.isAssignableFrom(field.getType())) {
                field.set(obj, Character.valueOf(value.charAt(0)));
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (Byte.class.isAssignableFrom(field.getType())) {
                field.set(obj, DatatypeConverter.parseByte((String)value));
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (Short.class.isAssignableFrom(field.getType())) {
                field.set(obj, DatatypeConverter.parseShort((String)value));
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (Integer.class.isAssignableFrom(field.getType())) {
                field.set(obj, Integer.parseInt(value));
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (Long.class.isAssignableFrom(field.getType())) {
                field.set(obj, DatatypeConverter.parseLong((String)value));
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (Float.class.isAssignableFrom(field.getType())) {
                field.set(obj, Float.valueOf(DatatypeConverter.parseFloat((String)value)));
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (Double.class.isAssignableFrom(field.getType())) {
                field.set(obj, DatatypeConverter.parseDouble((String)value));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private StringUtils() {
    }
}

