/*
 * Decompiled with CFR 0.152.
 */
package com.jdiai.tools;

import com.jdiai.tools.ReflectionUtils;
import com.jdiai.tools.func.JAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Function;
import java.util.function.Supplier;

public class Timer {
    private Long start = System.currentTimeMillis();
    private long timeoutInMSec = 5000L;
    private long retryTimeoutInMSec = 100L;
    private static int i = 1;

    public Timer() {
    }

    public Timer(long timeoutInMSec, long retryTimeoutInMSec) {
        this();
        this.timeoutInMSec = timeoutInMSec;
        this.retryTimeoutInMSec = retryTimeoutInMSec;
    }

    public Timer(long timeoutInMSec) {
        this();
        this.timeoutInMSec = timeoutInMSec;
    }

    public void restart() {
        this.start = System.currentTimeMillis();
    }

    public static String nowTime() {
        return Timer.nowTime("HH:mm:ss.SSS");
    }

    public static String nowTimeShort() {
        return Timer.nowTime("mm:ss.SSS");
    }

    public static String nowDate() {
        return Timer.nowTime("yyyy-MM-dd HH:mm:ss");
    }

    public static String nowTime(String timeFormat) {
        return new SimpleDateFormat(timeFormat).format(new Date());
    }

    public static String nowMSecs() {
        return Long.toString(System.currentTimeMillis());
    }

    public static void sleep(long mSec) {
        try {
            Thread.sleep(mSec);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static <T> T getByCondition(Supplier<T> getFunc, Function<T, Boolean> conditionFunc) {
        return new Timer().getResultByCondition(getFunc, conditionFunc);
    }

    public static <T> T getResultAction(Supplier<T> getFunc) {
        return (T)new Timer().getResultByCondition(getFunc, result -> true);
    }

    public static boolean alwaysDoneAction(JAction action) {
        return new Timer().wait(() -> {
            action.execute();
            return true;
        });
    }

    public static boolean waitCondition(Supplier<Boolean> condition) {
        return new Timer().wait(condition);
    }

    public Timer setTimeout(long timeoutInMSec) {
        this.timeoutInMSec = timeoutInMSec;
        return this;
    }

    public Timer setRetryTimeout(long retryTimeoutInMSec) {
        this.retryTimeoutInMSec = retryTimeoutInMSec;
        return this;
    }

    public Long timePassedInMSec() {
        Long now = System.currentTimeMillis();
        return now - this.start;
    }

    public String timePassed() {
        return this.timePassed("mm:ss.SSS");
    }

    public String timePassed(String timeFormat) {
        return new SimpleDateFormat(timeFormat).format(new Date(this.timePassedInMSec()));
    }

    public boolean isRunning() {
        return this.timePassedInMSec() < this.timeoutInMSec;
    }

    private void throwException(Throwable ex) {
        if (ReflectionUtils.isClass(AssertionError.class, ex.getClass())) {
            throw new AssertionError((Object)ex.getMessage());
        }
        throw new RuntimeException(ex.getMessage());
    }

    public boolean wait(JAction waitCase) {
        Throwable exception = null;
        while (this.isRunning()) {
            try {
                waitCase.invoke();
                return true;
            }
            catch (Error | Exception ex) {
                exception = ex;
                Timer.sleep(this.retryTimeoutInMSec);
            }
        }
        if (exception != null) {
            this.throwException(exception);
        }
        return false;
    }

    public boolean wait(Supplier<Boolean> waitCase) {
        Throwable exception = null;
        while (this.isRunning()) {
            try {
                if (waitCase != null && waitCase.get().booleanValue()) {
                    return true;
                }
                Timer.sleep(this.retryTimeoutInMSec);
            }
            catch (Error | Exception ex) {
                exception = ex;
            }
        }
        if (exception != null) {
            this.throwException(exception);
        }
        return false;
    }

    public <T> T getResult(Supplier<T> getFunc) {
        return (T)this.getResultByCondition(getFunc, result -> true);
    }

    public <T> T getResultByCondition(Supplier<T> getFunc, Function<T, Boolean> conditionFunc) {
        Throwable exception = null;
        do {
            try {
                T result = getFunc.get();
                if (result != null && conditionFunc.apply(result).booleanValue()) {
                    return result;
                }
            }
            catch (Error | Exception ex) {
                exception = ex;
            }
            Timer.sleep(this.retryTimeoutInMSec);
        } while (this.isRunning());
        if (exception != null) {
            this.throwException(exception);
        }
        return null;
    }

    public static void logTime() {
        System.out.println(i++ + ": " + Timer.nowTime());
    }
}

