/*
 * Decompiled with CFR 0.152.
 */
package com.jdiai.tools.map;

import com.jdiai.tools.LinqUtils;
import com.jdiai.tools.PrintUtils;
import com.jdiai.tools.TryCatchUtil;
import com.jdiai.tools.pairs.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;

public class MapArray<K, V>
implements Collection<Pair<K, V>>,
Cloneable {
    public List<Pair<K, V>> pairs = new ArrayList<Pair<K, V>>();
    private boolean ignoreNotUnique = false;

    @SafeVarargs
    public static <K, V> MapArray<K, V> map(Pair<K, V> ... pairs) {
        return new MapArray<K, V>(pairs);
    }

    public static <V> MapArray<Integer, V> map(List<V> list) {
        return new MapArray<Integer, Object>(list.size(), i -> i, list::get);
    }

    public MapArray() {
    }

    public MapArray(K key, V value) {
        this();
        this.add(key, value);
    }

    @SafeVarargs
    public MapArray(Pair<K, V> ... pairs) {
        this(Arrays.asList(pairs));
    }

    public MapArray(List<Pair<K, V>> pairs) {
        this();
        try {
            for (Pair<K, V> pair : pairs) {
                this.add(pair.key, pair.value);
            }
        }
        catch (Exception ex) {
            throw super.cantCreateMapException(ex);
        }
    }

    private RuntimeException cantCreateMapException(Exception ex) {
        return new RuntimeException(String.format("Can't create MapArray. Exception: %s", ex.getMessage()));
    }

    private RuntimeException cantConvertMapException(Exception ex) {
        return new RuntimeException(String.format("Can't convert toMap. Exception: %s", ex.getMessage()));
    }

    public MapArray(Collection<K> collection, Function<K, V> value) {
        this(collection, (T k) -> k, value);
    }

    public <T> MapArray(Collection<T> collection, Function<T, K> keyFunc, Function<T, V> valueFunc) {
        this(collection, keyFunc, valueFunc, false);
    }

    public <T> MapArray(Collection<T> collection, Function<T, K> keyFunc, Function<T, V> valueFunc, boolean ignoreNotUnique) {
        this();
        try {
            for (T t : collection) {
                if (ignoreNotUnique) {
                    this.addNew(keyFunc.apply(t), valueFunc.apply(t));
                    continue;
                }
                this.add(keyFunc.apply(t), valueFunc.apply(t));
            }
        }
        catch (Exception ex) {
            throw super.cantCreateMapException(ex);
        }
    }

    public MapArray(K[] array, Function<K, V> value) {
        this((Collection<K>)Arrays.asList(array), value);
    }

    public <T> MapArray(T[] array, Function<T, K> key, Function<T, V> value) {
        this(array, key, value, false);
    }

    public <T> MapArray(T[] array, Function<T, K> key, Function<T, V> value, boolean ignoreNotUnique) {
        this(Arrays.asList(array), key, value, ignoreNotUnique);
    }

    public MapArray(int count, Function<Integer, K> keyFunc, Function<Integer, V> value) {
        this();
        try {
            for (int i = 0; i < count; ++i) {
                this.add(keyFunc.apply(i), value.apply(i));
            }
        }
        catch (Exception ex) {
            throw super.cantCreateMapException(ex);
        }
    }

    public MapArray(int count, Function<Integer, Pair<K, V>> pairFunc) {
        this();
        try {
            for (int i = 0; i < count; ++i) {
                Pair<K, V> pair = pairFunc.apply(i);
                this.add(pair.key, pair.value);
            }
        }
        catch (Exception ex) {
            throw super.cantCreateMapException(ex);
        }
    }

    public void addUnique(K key, V value) {
        if (this.keys().contains(key)) {
            throw new RuntimeException("Duplicated keys " + key + ". Can't create MapArray");
        }
        this.add(key, value);
    }

    public MapArray(MapArray<K, V> mapArray) {
        this();
        this.addAll((Collection<Pair<K, V>>)mapArray.pairs);
        this.ignoreNotUnique = mapArray.ignoreNotUnique;
    }

    public MapArray(Map<K, V> map) {
        this();
        if (map == null) {
            return;
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    public MapArray(Object[][] objects) {
        this();
        if (objects == null) {
            return;
        }
        this.add(objects);
    }

    public MapArray(Collection<K> keys, Collection<V> values) {
        this();
        if (keys == null || values == null) {
            return;
        }
        if (keys.size() != values.size()) {
            throw new RuntimeException(String.format("keys and values has different count (keys:[%s]; values:[%s])", LinqUtils.safePrintCollection(keys), LinqUtils.safePrintCollection(values)));
        }
        Iterator<K> ik = keys.iterator();
        Iterator<V> vk = values.iterator();
        for (int i = 0; i < keys.size(); ++i) {
            this.add(ik.next(), vk.next());
        }
    }

    public MapArray(K[] keys, V[] values) {
        this((Collection<K>)Arrays.asList(keys), (Collection<V>)Arrays.asList(values));
    }

    public static <T> MapArray<Integer, T> toMapArray(Collection<T> collection) {
        MapArray<Integer, T> mapArray = new MapArray<Integer, T>();
        if (collection == null) {
            return mapArray;
        }
        int i = 0;
        for (T t : collection) {
            mapArray.add(i++, t);
        }
        return mapArray;
    }

    public static <Value> MapArray<Integer, Value> toMapArray(int count, Function<Integer, Value> valueFunc) {
        MapArray<Integer, Value> mapArray = new MapArray<Integer, Value>();
        try {
            for (int i = 0; i < count; ++i) {
                mapArray.add(i, valueFunc.apply(i));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Can't get MapArray. Exception: %s", ex.getMessage()));
        }
        return mapArray;
    }

    public static <T> MapArray<Integer, T> toMapArray(T[] array) {
        return MapArray.toMapArray(Arrays.asList(array));
    }

    public static <Key, Value> MapArray<Key, Value> toMapArray(Map<Key, Value> map) {
        MapArray<Key, Value> mapArray = new MapArray<Key, Value>();
        if (map == null) {
            return mapArray;
        }
        for (Map.Entry<Key, Value> e : map.entrySet()) {
            mapArray.add(e.getKey(), e.getValue());
        }
        return mapArray;
    }

    public <KResult, VResult> MapArray<KResult, VResult> toMapArray(BiFunction<K, V, KResult> key, BiFunction<K, V, VResult> value) {
        MapArray<KResult, VResult> result = new MapArray<KResult, VResult>();
        try {
            for (Pair<K, V> pair : this.pairs) {
                result.add(key.apply(pair.key, pair.value), value.apply(pair.key, pair.value));
            }
        }
        catch (Exception ex) {
            throw this.cantConvertMapException(ex);
        }
        return result;
    }

    public <VResult> MapArray<K, VResult> toMapArray(Function<V, VResult> value) {
        MapArray result = new MapArray();
        try {
            for (Pair<K, V> pair : this.pairs) {
                result.add(pair.key, value.apply(pair.value));
            }
            return result;
        }
        catch (Exception ex) {
            throw this.cantConvertMapException(ex);
        }
    }

    public Map<K, V> toMap() {
        return this.toMap(v -> v);
    }

    public <VResult> Map<K, VResult> toMap(Function<V, VResult> value) {
        return this.toMap((k, v) -> k, (k, v) -> value.apply(v));
    }

    public <KResult, VResult> Map<KResult, VResult> toMap(BiFunction<K, V, KResult> key, BiFunction<K, V, VResult> value) {
        HashMap<KResult, VResult> result = new HashMap<KResult, VResult>();
        try {
            for (Pair<K, V> pair : this.pairs) {
                result.put(key.apply(pair.key, pair.value), value.apply(pair.key, pair.value));
            }
        }
        catch (Exception ex) {
            throw this.cantConvertMapException(ex);
        }
        return result;
    }

    public void ignoreNotUnique() {
        this.ignoreNotUnique = true;
    }

    public MapArray<K, V> add(K key, V value) {
        if (this.has(key)) {
            if (!this.ignoreNotUnique) {
                throw new RuntimeException("Key '" + key + "' already exist. " + this.toString());
            }
        } else {
            this.pairs.add(new Pair<K, V>(key, value));
        }
        return this;
    }

    public MapArray<K, V> addNew(K key, V value) {
        if (!this.has(key)) {
            this.pairs.add(new Pair<K, V>(key, value));
        }
        return this;
    }

    public MapArray<K, V> update(K key, V value) {
        try {
            this.add(key, value);
        }
        catch (Exception ex) {
            if (ex.getMessage().contains("already exist")) {
                this.updateByKey(key, value);
            }
            throw ex;
        }
        return this;
    }

    public MapArray<K, V> update(K key, Function<V, V> func) {
        try {
            if (this.has(key)) {
                V value = this.get(key);
                this.updateByKey(key, func.apply(value));
            } else {
                this.add(key, func.apply(null));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Can't do update. Exception: %s", ex.getMessage()));
        }
        return this;
    }

    public void add(Object[][] pairs) {
        if (pairs == null) {
            return;
        }
        for (Object[] pair : pairs) {
            if (pair.length != 2) continue;
            this.add(this.cast(pair[0]), this.cast(pair[1]));
        }
    }

    public void update(Object[][] pairs) {
        if (pairs == null) {
            return;
        }
        for (Object[] pair : pairs) {
            if (pair.length != 2) continue;
            this.update(this.cast(pair[0]), this.cast(pair[1]));
        }
    }

    private <R> R cast(Object obj) {
        try {
            return (R)obj;
        }
        catch (ClassCastException ex) {
            throw new ClassCastException(String.format("Can't cast element '%s' in MapArray. Exception: %s", obj, ex.getMessage()));
        }
    }

    public void addOrReplace(K key, V value) {
        if (this.has(key)) {
            this.removeByKey(key);
        }
        this.add(key, value);
    }

    public void addOrReplace(Object[][] pairs) {
        if (pairs == null) {
            return;
        }
        for (Object[] pair : pairs) {
            if (pair.length != 2) continue;
            this.addOrReplace(pair[0], pair[1]);
        }
    }

    public boolean has(K key) {
        return this.keys().contains(key);
    }

    public MapArray<K, V> addFirst(K key, V value) {
        if (this.has(key)) {
            throw new RuntimeException(String.format("Can't addFirst element for key '%s'. MapArray already have element with this key.", key));
        }
        CopyOnWriteArrayList<Pair<K, V>> result = new CopyOnWriteArrayList<Pair<K, V>>();
        result.add(new Pair<K, V>(key, value));
        result.addAll(this.pairs);
        this.pairs = result;
        return this;
    }

    public V get(K key) {
        Pair first = null;
        try {
            first = LinqUtils.first(this.pairs, pair -> pair.key.equals(key));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return first != null ? (V)first.value : null;
    }

    public Pair<K, V> get(int i) {
        int index = i >= 0 ? i : this.pairs.size() + i;
        return index >= 0 && index < this.pairs.size() ? this.pairs.get(index) : null;
    }

    public K key(int index) {
        return (K)this.get((int)index).key;
    }

    public V value(int index) {
        return (V)this.get((int)index).value;
    }

    public int indexOf(K key) {
        int index = 0;
        for (Pair<K, V> pair : this.pairs) {
            if (pair.key.equals(key)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public List<K> keys() {
        return this.pairs.stream().map((? super T pair) -> pair.key).collect(Collectors.toList());
    }

    public List<V> values() {
        return this.pairs.stream().map((? super T pair) -> pair.value).collect(Collectors.toList());
    }

    public List<V> values(Function<V, Boolean> condition) {
        return LinqUtils.filter(this.values(), condition);
    }

    @Override
    public int size() {
        return this.pairs.size();
    }

    public int count() {
        return this.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public boolean any() {
        return this.size() > 0;
    }

    public boolean any(Function<V, Boolean> func) {
        return LinqUtils.any(this.values(), func);
    }

    public boolean all(Function<V, Boolean> func) {
        return LinqUtils.all(this.values(), func);
    }

    public Pair<K, V> first() {
        return this.get(0);
    }

    public Pair<K, V> last() {
        return this.get(-1);
    }

    public MapArray<K, V> revert() {
        CopyOnWriteArrayList<Pair<K, V>> result = new CopyOnWriteArrayList<Pair<K, V>>();
        for (int i = this.size() - 1; i >= 0; --i) {
            result.add(this.get(i));
        }
        this.pairs = result;
        return this;
    }

    @Override
    public boolean contains(Object o) {
        return this.values().contains(o);
    }

    @Override
    public Iterator<Pair<K, V>> iterator() {
        return this.pairs.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.pairs.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.pairs.toArray(a);
    }

    @Override
    public boolean add(Pair<K, V> kv) {
        return this.pairs.add(kv);
    }

    public MapArray<K, V> update(Pair<K, V> kv) {
        if (kv == null) {
            return this;
        }
        return this.update(kv.key, kv.value);
    }

    @Override
    public boolean remove(Object o) {
        boolean isRemoved = false;
        for (Pair<K, V> kv : this.pairs) {
            if (!((Object)kv).equals(o)) continue;
            this.pairs.remove(kv);
            isRemoved = true;
        }
        return isRemoved;
    }

    public void removeByKey(K key) {
        for (Pair<K, V> pair : this.pairs) {
            if (!pair.key.equals(key)) continue;
            this.pairs.remove(pair);
            return;
        }
    }

    private void updateByKey(K key, V value) {
        for (Pair<K, V> pair : this.pairs) {
            if (!pair.key.equals(key)) continue;
            pair.value = value;
            return;
        }
    }

    public int firstIndex(Function<V, Boolean> func) {
        if (this.pairs == null || this.pairs.size() == 0) {
            throw new RuntimeException("Can't get firstIndex. Collection is Null or empty");
        }
        try {
            for (int i = 0; i < this.size(); ++i) {
                if (!LinqUtils.invokeBoolean(func, this.pairs.get((int)i).value)) continue;
                return i;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't get firstIndex." + ex.getMessage());
        }
        return -1;
    }

    public void removeAllValues(V value) {
        List<Pair> values = LinqUtils.where(this.pairs, p -> p.value.equals(value));
        if (ObjectUtils.isNotEmpty(value)) {
            this.pairs.removeAll(values);
        }
    }

    public Pair<K, V> removeByIndex(int index) {
        return this.pairs.remove(index);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(Pair<K, V> ... pairs) {
        return this.addAll((Collection<? extends Pair<K, V>>)Arrays.asList(pairs));
    }

    @Override
    public boolean addAll(Collection<? extends Pair<K, V>> c) {
        if (c == null) {
            return false;
        }
        for (Pair<K, V> pair : c) {
            if (this.add(pair)) continue;
            return false;
        }
        return true;
    }

    public MapArray<K, V> addAll(Map<K, V> map) {
        if (map == null) {
            return this;
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public MapArray<K, V> merge(MapArray<K, V> map) {
        if (map == null) {
            return this;
        }
        if (!this.addAll((Collection<? extends Pair<K, V>>)map)) {
            throw new RuntimeException("Can't merge MapArray");
        }
        return this;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c == null) {
            return false;
        }
        for (Object o : c) {
            if (this.remove(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (c == null) {
            return false;
        }
        for (Pair<K, V> pair : this.pairs) {
            if (c.contains(pair) || this.remove(pair)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clear() {
        this.pairs.clear();
    }

    public String toString() {
        return PrintUtils.print(this.pairs, pair -> pair.key + ":" + pair.value);
    }

    public MapArray<K, V> clone() {
        return new MapArray<K, V>(this);
    }

    public MapArray<K, V> copy() {
        return this.clone();
    }

    public <T1> List<T1> map(BiFunction<K, V, T1> func) {
        return this.select(func);
    }

    public <T1> List<T1> map(Function<V, T1> func) {
        return this.select(func);
    }

    public <T1> List<T1> select(BiFunction<K, V, T1> func) {
        try {
            ArrayList<T1> result = new ArrayList<T1>();
            for (Pair<K, V> pair : this.pairs) {
                result.add(func.apply(pair.key, pair.value));
            }
            return result;
        }
        catch (Exception ignore) {
            TryCatchUtil.throwRuntimeException(ignore);
            return new ArrayList();
        }
    }

    public <T1> List<T1> select(Function<V, T1> func) {
        try {
            ArrayList<T1> result = new ArrayList<T1>();
            for (Pair<K, V> pair : this.pairs) {
                result.add(func.apply(pair.value));
            }
            return result;
        }
        catch (Exception ex) {
            TryCatchUtil.throwRuntimeException(ex);
            return new ArrayList();
        }
    }

    public MapArray<K, V> filter(BiFunction<K, V, Boolean> func) {
        return this.where(func);
    }

    public MapArray<K, V> filter(Function<V, Boolean> func) {
        return this.where(func);
    }

    public MapArray<K, V> where(BiFunction<K, V, Boolean> func) {
        try {
            MapArray<K, V> result = new MapArray<K, V>();
            for (Pair<K, V> pair : this.pairs) {
                if (!LinqUtils.invokeBoolean(func, pair.key, pair.value)) continue;
                result.add(pair);
            }
            return result;
        }
        catch (Exception ex) {
            TryCatchUtil.throwRuntimeException(ex);
            return null;
        }
    }

    public MapArray<K, V> where(Function<V, Boolean> func) {
        try {
            MapArray<K, V> result = new MapArray<K, V>();
            for (Pair<K, V> pair : this.pairs) {
                if (!LinqUtils.invokeBoolean(func, pair.value)) continue;
                result.add(pair);
            }
            return result;
        }
        catch (Exception ex) {
            TryCatchUtil.throwRuntimeException(ex);
            return null;
        }
    }

    public void ifDo(BiFunction<K, V, Boolean> condition, Consumer<V> action) {
        try {
            for (Pair<K, V> el : this.pairs) {
                if (!LinqUtils.invokeBoolean(condition, el.key, el.value)) continue;
                action.accept(el.value);
            }
        }
        catch (Exception ex) {
            TryCatchUtil.throwRuntimeException(ex);
        }
    }

    public void ifDo(Function<V, Boolean> condition, Consumer<V> action) {
        try {
            for (Pair<K, V> el : this.pairs) {
                if (!LinqUtils.invokeBoolean(condition, el.value)) continue;
                action.accept(el.value);
            }
        }
        catch (Exception ex) {
            TryCatchUtil.throwRuntimeException(ex);
        }
    }

    public <T> List<T> ifSelect(BiFunction<K, V, Boolean> condition, Function<V, T> transform) {
        try {
            ArrayList<T> result = new ArrayList<T>();
            for (Pair<K, V> el : this.pairs) {
                if (!LinqUtils.invokeBoolean(condition, el.key, el.value)) continue;
                result.add(transform.apply(el.value));
            }
            return result;
        }
        catch (Exception ex) {
            TryCatchUtil.throwRuntimeException(ex);
            return null;
        }
    }

    public <T> List<T> ifSelect(Function<V, Boolean> condition, Function<V, T> transform) {
        try {
            ArrayList<T> result = new ArrayList<T>();
            for (Pair<K, V> el : this.pairs) {
                if (!LinqUtils.invokeBoolean(condition, el.value)) continue;
                result.add(transform.apply(el.value));
            }
            return result;
        }
        catch (Exception ex) {
            TryCatchUtil.throwRuntimeException(ex);
            return null;
        }
    }

    public V firstValue(BiFunction<K, V, Boolean> func) {
        Pair<K, V> first = this.first(func);
        return first == null ? null : (V)first.value;
    }

    public V firstValue(Function<V, Boolean> func) {
        Pair<K, V> first = this.first(func);
        return first == null ? null : (V)first.value;
    }

    public Pair<K, V> first(BiFunction<K, V, Boolean> func) {
        try {
            for (Pair<K, V> pair : this.pairs) {
                if (!LinqUtils.invokeBoolean(func, pair.key, pair.value)) continue;
                return pair;
            }
            return null;
        }
        catch (Exception ex) {
            TryCatchUtil.throwRuntimeException(ex);
            return null;
        }
    }

    public Pair<K, V> first(Function<V, Boolean> func) {
        try {
            for (Pair<K, V> pair : this.pairs) {
                if (!LinqUtils.invokeBoolean(func, pair.value)) continue;
                return pair;
            }
            return null;
        }
        catch (Exception ex) {
            TryCatchUtil.throwRuntimeException(ex);
            return null;
        }
    }

    public V lastValue(BiFunction<K, V, Boolean> func) {
        Pair<K, V> last = this.last(func);
        return last == null ? null : (V)last.value;
    }

    public V lastValue(Function<V, Boolean> func) {
        Pair<K, V> last = this.last(func);
        return last == null ? null : (V)last.value;
    }

    public Pair<K, V> last(BiFunction<K, V, Boolean> func) {
        Pair<K, V> result = null;
        try {
            for (Pair<K, V> pair : this.pairs) {
                if (!LinqUtils.invokeBoolean(func, pair.key, pair.value)) continue;
                result = pair;
            }
            return result;
        }
        catch (Exception ex) {
            TryCatchUtil.throwRuntimeException(ex);
            return null;
        }
    }

    public Pair<K, V> last(Function<V, Boolean> func) {
        Pair<K, V> result = null;
        try {
            for (Pair<K, V> pair : this.pairs) {
                if (!LinqUtils.invokeBoolean(func, pair.value)) continue;
                result = pair;
            }
            return result;
        }
        catch (Exception ex) {
            TryCatchUtil.throwRuntimeException(ex);
            return null;
        }
    }

    public MapArray<K, V> slice(int from, int to) {
        return new MapArray<K, V>(LinqUtils.listCopy(this.pairs, from, to));
    }

    public void foreach(BiConsumer<K, V> action) {
        try {
            for (Pair<K, V> pair : this.pairs) {
                action.accept(pair.key, pair.value);
            }
        }
        catch (Exception ex) {
            TryCatchUtil.throwRuntimeException(ex);
        }
    }

    public <R> List<R> selectMany(BiFunction<K, V, List<R>> func) {
        try {
            ArrayList result = new ArrayList();
            for (Pair<K, V> pair : this.pairs) {
                result.addAll(func.apply(pair.key, pair.value));
            }
            return result;
        }
        catch (Exception ex) {
            TryCatchUtil.throwRuntimeException(ex);
            return null;
        }
    }

    public <R> List<R> selectMany(Function<V, List<R>> func) {
        try {
            ArrayList result = new ArrayList();
            for (Pair<K, V> pair : this.pairs) {
                result.addAll(func.apply(pair.value));
            }
            return result;
        }
        catch (Exception ex) {
            TryCatchUtil.throwRuntimeException(ex);
            return null;
        }
    }
}

