/*
 * Decompiled with CFR 0.152.
 */
package com.jdiai.tools.map;

import com.jdiai.tools.LinqUtils;
import com.jdiai.tools.PrintUtils;
import com.jdiai.tools.TryCatchUtil;
import com.jdiai.tools.map.MapArray;
import com.jdiai.tools.pairs.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class MultiMap<K, V>
implements Collection<Pair<K, V>>,
Cloneable {
    private List<Pair<K, V>> pairs = new ArrayList<Pair<K, V>>();
    private boolean ignoreKeyCase = false;

    public List<Pair<K, V>> getPairs() {
        return this.pairs;
    }

    public static <K, V> MultiMap<K, V> multiMap(Pair<K, V> ... pairs) {
        return new MultiMap<K, V>(pairs);
    }

    public static <V> MultiMap<Integer, V> multiMap(List<V> list) {
        return new MultiMap<Integer, Object>(list.size(), i -> i, list::get);
    }

    public MultiMap() {
    }

    public MultiMap(K key, V value) {
        this();
        this.add(key, value);
    }

    public MultiMap(Pair<K, V> ... pairs) {
        this(Arrays.asList(pairs));
    }

    public MultiMap(List<Pair<K, V>> pairs) {
        this();
        try {
            for (Pair<K, V> pair : pairs) {
                this.add(pair.key, pair.value);
            }
        }
        catch (Exception ex) {
            throw super.cantCreateException(ex);
        }
    }

    public MultiMap(Collection<K> collection, Function<K, V> value) {
        this(collection, (T k) -> k, value);
    }

    public <T> MultiMap(Collection<T> collection, Function<T, K> keyFunc, Function<T, V> valueFunc) {
        this();
        try {
            for (T t : collection) {
                this.add(keyFunc.apply(t), valueFunc.apply(t));
            }
        }
        catch (Exception ex) {
            throw super.cantCreateException(ex);
        }
    }

    public MultiMap(K[] array, Function<K, V> value) {
        this((Collection<K>)Arrays.asList(array), value);
    }

    public <T> MultiMap(T[] array, Function<T, K> key, Function<T, V> value) {
        this(Arrays.asList(array), key, value);
    }

    public MultiMap(int count, Function<Integer, K> keyFunc, Function<Integer, V> value) {
        this();
        try {
            for (int i = 0; i < count; ++i) {
                this.add(keyFunc.apply(i), value.apply(i));
            }
        }
        catch (Exception ex) {
            throw super.cantCreateException(ex);
        }
    }

    public MultiMap(int count, Function<Integer, Pair<K, V>> pairFunc) {
        this();
        try {
            for (int i = 0; i < count; ++i) {
                Pair<K, V> pair = pairFunc.apply(i);
                this.add(pair.key, pair.value);
            }
        }
        catch (Exception ex) {
            throw super.cantCreateException(ex);
        }
    }

    public MultiMap(MultiMap<K, V> mapArray) {
        this();
        this.addAll((Collection<Pair<K, V>>)mapArray.pairs);
        this.ignoreKeyCase = mapArray.ignoreKeyCase;
    }

    public MultiMap(MapArray<K, V> mapArray) {
        this();
        this.addAll(mapArray.pairs);
    }

    public MultiMap(Map<K, V> map) {
        this();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    public MultiMap(Object[][] objects) {
        this();
        this.add(objects);
    }

    public MultiMap(List<K> keys, List<V> values) {
        this();
        if (keys == null || values == null) {
            throw new RuntimeException("Can't create MultiMap for null keys or values");
        }
        if (keys.size() != values.size()) {
            throw new RuntimeException(String.format("keys and values has different count (keys:[%s]; values:[%s])", LinqUtils.safePrintCollection(keys), LinqUtils.safePrintCollection(values)));
        }
        for (int i = 0; i < keys.size(); ++i) {
            this.add(keys.get(i), values.get(i));
        }
    }

    public MultiMap(K[] keys, V[] values) {
        this(Arrays.asList(keys), Arrays.asList(values));
    }

    private RuntimeException cantCreateException(Exception ex) {
        return new RuntimeException("Can't create MapArray", ex);
    }

    private RuntimeException cantConvertException(Exception ex) {
        throw new RuntimeException(String.format("Can't convert toMap. Exception: %s", ex.getMessage()));
    }

    public static <T> MultiMap<Integer, T> toMultiMap(Collection<T> collection) {
        MultiMap<Integer, T> multiMap = new MultiMap<Integer, T>();
        int i = 0;
        for (T t : collection) {
            multiMap.add(i++, t);
        }
        return multiMap;
    }

    public static <Value> MultiMap<Integer, Value> toMultiMap(int count, Function<Integer, Value> valueFunc) {
        MultiMap<Integer, Value> multiMap = new MultiMap<Integer, Value>();
        try {
            for (int i = 0; i < count; ++i) {
                multiMap.add(i, valueFunc.apply(i));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Can't get MapArray. Exception: %s", ex.getMessage()));
        }
        return multiMap;
    }

    public static <T> MultiMap<Integer, T> toMultiMap(T[] array) {
        return MultiMap.toMultiMap(Arrays.asList(array));
    }

    public static <Key, Value> MultiMap<Key, Value> toMultiMap(Map<Key, Value> map) {
        MultiMap<Key, Value> mapArray = new MultiMap<Key, Value>();
        for (Map.Entry<Key, Value> e : map.entrySet()) {
            mapArray.add(e.getKey(), e.getValue());
        }
        return mapArray;
    }

    public static <Key, Value> MultiMap<Key, Value> toMultiMap(MapArray<Key, Value> map) {
        MultiMap mapArray = new MultiMap();
        for (Pair<Key, Value> pair : map) {
            mapArray.add(pair.key, pair.value);
        }
        return mapArray;
    }

    public <KResult, VResult> MultiMap<KResult, VResult> toMultiMap(BiFunction<K, V, KResult> key, BiFunction<K, V, VResult> value) {
        MultiMap<KResult, VResult> result = new MultiMap<KResult, VResult>();
        result.ignoreKeyCase = this.ignoreKeyCase;
        try {
            for (Pair<K, V> pair : this.pairs) {
                result.add(key.apply(pair.key, pair.value), value.apply(pair.key, pair.value));
            }
        }
        catch (Exception ex) {
            throw this.cantConvertException(ex);
        }
        return result;
    }

    public <VResult> MultiMap<K, VResult> toMultiMap(Function<V, VResult> value) {
        MultiMap result = new MultiMap();
        result.ignoreKeyCase = this.ignoreKeyCase;
        try {
            for (Pair<K, V> pair : this.pairs) {
                result.add(pair.key, value.apply(pair.value));
            }
            return result;
        }
        catch (Exception ex) {
            throw this.cantConvertException(ex);
        }
    }

    public Map<K, V> toMap() {
        return this.toMap(v -> v);
    }

    public <VResult> Map<K, VResult> toMap(Function<V, VResult> value) {
        return this.toMap((k, v) -> k, (k, v) -> value.apply(v));
    }

    public <KResult, VResult> Map<KResult, VResult> toMap(BiFunction<K, V, KResult> key, BiFunction<K, V, VResult> value) {
        HashMap<KResult, VResult> result = new HashMap<KResult, VResult>();
        try {
            for (Pair<K, V> pair : this.pairs) {
                result.put(key.apply(pair.key, pair.value), value.apply(pair.key, pair.value));
            }
        }
        catch (Exception ex) {
            throw this.cantConvertException(ex);
        }
        return result;
    }

    public MultiMap<K, V> add(K key, V value) {
        this.pairs.add(new Pair<K, V>(key, value));
        return this;
    }

    public void add(Object[][] pairs) {
        for (Object[] pair : pairs) {
            if (pair.length != 2) continue;
            this.add(this.cast(pair[0]), this.cast(pair[1]));
        }
    }

    private <R> R cast(Object obj) {
        try {
            return (R)obj;
        }
        catch (ClassCastException ex) {
            throw new ClassCastException(String.format("Can't cast element '%s' in MapArray. Exception: %s", obj, ex.getMessage()));
        }
    }

    public boolean has(K key) {
        return this.keys().contains(key);
    }

    public MultiMap<K, V> addFirst(K key, V value) {
        CopyOnWriteArrayList<Pair<K, V>> result = new CopyOnWriteArrayList<Pair<K, V>>();
        result.add(new Pair<K, V>(key, value));
        result.addAll(this.pairs);
        this.pairs = result;
        return this;
    }

    public MultiMap<K, V> ignoreKeyCase() {
        this.ignoreKeyCase = true;
        return this;
    }

    protected boolean keysEqual(K key1, K key2) {
        return key1.getClass() == String.class && this.ignoreKeyCase ? ((String)key1).equalsIgnoreCase((String)key2) : key1.equals(key2);
    }

    public int getIndex(K key) {
        for (int i = 0; i < this.keys().size(); ++i) {
            if (!this.keysEqual(this.keys().get(i), key)) continue;
            return i;
        }
        return -1;
    }

    public V get(K key) {
        Pair first = null;
        try {
            first = LinqUtils.first(this.pairs, pair -> this.keysEqual(pair.key, key));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return first != null ? (V)first.value : null;
    }

    public List<V> getList(K key) {
        List<Object> result = null;
        try {
            result = LinqUtils.ifSelect(this.pairs, pair -> this.keysEqual(pair.key, key), pair -> pair.value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result != null ? result : new ArrayList();
    }

    public Pair<K, V> get(int i) {
        int index = i >= 0 ? i : this.pairs.size() + i;
        return index >= 0 && index < this.pairs.size() ? this.pairs.get(index) : null;
    }

    public K key(int index) {
        return (K)this.get((int)index).key;
    }

    public V value(int index) {
        return (V)this.get((int)index).value;
    }

    public List<K> keys() {
        return LinqUtils.map(this.pairs, pair -> pair.key);
    }

    public List<K> uniqueKeys() {
        ArrayList keys = new ArrayList();
        for (Pair<K, V> pair : this.pairs) {
            if (keys.contains(pair.key)) continue;
            keys.add(pair.key);
        }
        return keys;
    }

    public List<V> values() {
        return LinqUtils.map(this.pairs, pair -> pair.value);
    }

    public List<V> uniqueValues() {
        ArrayList values = new ArrayList();
        for (Pair<K, V> pair : this.pairs) {
            if (values.contains(pair.value)) continue;
            values.add(pair.value);
        }
        return values;
    }

    public List<V> values(Function<V, Boolean> condition) {
        return LinqUtils.filter(this.values(), condition);
    }

    @Override
    public int size() {
        return this.pairs.size();
    }

    public int count() {
        return this.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public boolean any() {
        return this.size() > 0;
    }

    public boolean any(Function<V, Boolean> func) {
        return LinqUtils.any(this.values(), func);
    }

    public boolean all(Function<V, Boolean> func) {
        return LinqUtils.all(this.values(), func);
    }

    public Pair<K, V> first() {
        return this.get(0);
    }

    public Pair<K, V> last() {
        return this.get(-1);
    }

    public MultiMap<K, V> revert() {
        CopyOnWriteArrayList<Pair<K, V>> result = new CopyOnWriteArrayList<Pair<K, V>>();
        for (int i = this.size() - 1; i >= 0; --i) {
            result.add(this.get(i));
        }
        this.pairs = result;
        return this;
    }

    @Override
    public boolean contains(Object o) {
        return this.values().contains(o);
    }

    @Override
    public Iterator<Pair<K, V>> iterator() {
        return this.pairs.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.pairs.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.pairs.toArray(a);
    }

    @Override
    public boolean add(Pair<K, V> kv) {
        return this.pairs.add(kv);
    }

    @Override
    public boolean remove(Object o) {
        boolean isRemoved = false;
        for (Pair<K, V> kv : this.pairs) {
            if (!((Object)kv).equals(o)) continue;
            this.pairs.remove(kv);
            isRemoved = true;
        }
        return isRemoved;
    }

    public void removeByKey(K key) {
        this.pairs.removeAll(LinqUtils.where(this.pairs, p -> this.keysEqual(p.key, key)));
    }

    public void removeByValue(V value) {
        this.pairs.removeAll(LinqUtils.where(this.pairs, p -> p.value.equals(value)));
    }

    public Pair<K, V> removeByIndex(int index) {
        return this.pairs.remove(index);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Pair<K, V>> c) {
        for (Pair<K, V> pair : c) {
            if (this.add(pair)) continue;
            return false;
        }
        return true;
    }

    public MultiMap<K, V> addAll(Map<K, V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public MultiMap<K, V> merge(MultiMap<K, V> map) {
        if (!this.addAll((Collection<? extends Pair<K, V>>)map)) {
            throw new RuntimeException("Can't merge MapArray");
        }
        return this;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        for (Object o : c) {
            if (this.remove(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.pairs.stream().filter((? super T pair) -> !c.contains(pair)).allMatch(this::remove);
    }

    @Override
    public void clear() {
        this.pairs.clear();
    }

    public String toString() {
        return PrintUtils.print(this.pairs, pair -> pair.key + ":" + pair.value);
    }

    public MultiMap<K, V> clone() {
        return new MultiMap<K, V>(this);
    }

    public MultiMap<K, V> copy() {
        return this.clone();
    }

    public <T1> List<T1> map(BiFunction<K, V, T1> func) {
        return this.select(func);
    }

    public <T1> List<T1> map(Function<V, T1> func) {
        return this.select(func);
    }

    public <T1> List<T1> select(BiFunction<K, V, T1> func) {
        try {
            ArrayList<T1> result = new ArrayList<T1>();
            for (Pair<K, V> pair : this.pairs) {
                result.add(func.apply(pair.key, pair.value));
            }
            return result;
        }
        catch (Exception ex) {
            TryCatchUtil.throwRuntimeException(ex);
            return new ArrayList();
        }
    }

    public <T1> List<T1> select(Function<V, T1> func) {
        try {
            ArrayList<T1> result = new ArrayList<T1>();
            for (Pair<K, V> pair : this.pairs) {
                result.add(func.apply(pair.value));
            }
            return result;
        }
        catch (Exception ex) {
            TryCatchUtil.throwRuntimeException(ex);
            return new ArrayList();
        }
    }

    public MultiMap<K, V> filter(BiFunction<K, V, Boolean> func) {
        return this.where(func);
    }

    public MultiMap<K, V> filter(Function<V, Boolean> func) {
        return this.where(func);
    }

    public MultiMap<K, V> where(BiFunction<K, V, Boolean> func) {
        try {
            MultiMap<K, V> result = new MultiMap<K, V>();
            for (Pair<K, V> pair : this.pairs) {
                if (!LinqUtils.invokeBoolean(func, pair.key, pair.value)) continue;
                result.add(pair);
            }
            return result;
        }
        catch (Exception ex) {
            TryCatchUtil.throwRuntimeException(ex);
            return null;
        }
    }

    public MultiMap<K, V> where(Function<V, Boolean> func) {
        try {
            MultiMap<K, V> result = new MultiMap<K, V>();
            for (Pair<K, V> pair : this.pairs) {
                if (!LinqUtils.invokeBoolean(func, pair.value)) continue;
                result.add(pair);
            }
            return result;
        }
        catch (Exception ex) {
            TryCatchUtil.throwRuntimeException(ex);
            return null;
        }
    }

    public void ifDo(BiFunction<K, V, Boolean> condition, Consumer<V> action) {
        try {
            for (Pair<K, V> el : this.pairs) {
                if (!LinqUtils.invokeBoolean(condition, el.key, el.value)) continue;
                action.accept(el.value);
            }
        }
        catch (Exception ex) {
            TryCatchUtil.throwRuntimeException(ex);
        }
    }

    public void ifDo(Function<V, Boolean> condition, Consumer<V> action) {
        try {
            for (Pair<K, V> el : this.pairs) {
                if (!LinqUtils.invokeBoolean(condition, el.value)) continue;
                action.accept(el.value);
            }
        }
        catch (Exception ex) {
            TryCatchUtil.throwRuntimeException(ex);
        }
    }

    public <T> List<T> ifSelect(BiFunction<K, V, Boolean> condition, Function<V, T> transform) {
        try {
            ArrayList<T> result = new ArrayList<T>();
            for (Pair<K, V> el : this.pairs) {
                if (!LinqUtils.invokeBoolean(condition, el.key, el.value)) continue;
                result.add(transform.apply(el.value));
            }
            return result;
        }
        catch (Exception ex) {
            TryCatchUtil.throwRuntimeException(ex);
            return null;
        }
    }

    public <T> List<T> ifSelect(Function<V, Boolean> condition, Function<V, T> transform) {
        try {
            ArrayList<T> result = new ArrayList<T>();
            for (Pair<K, V> el : this.pairs) {
                if (!LinqUtils.invokeBoolean(condition, el.value)) continue;
                result.add(transform.apply(el.value));
            }
            return result;
        }
        catch (Exception ex) {
            TryCatchUtil.throwRuntimeException(ex);
            return null;
        }
    }

    public V firstValue(BiFunction<K, V, Boolean> func) {
        Pair<K, V> first = this.first(func);
        return first == null ? null : (V)first.value;
    }

    public V firstValue(Function<V, Boolean> func) {
        Pair<K, V> first = this.first(func);
        return first == null ? null : (V)first.value;
    }

    public Pair<K, V> first(BiFunction<K, V, Boolean> func) {
        try {
            for (Pair<K, V> pair : this.pairs) {
                if (!LinqUtils.invokeBoolean(func, pair.key, pair.value)) continue;
                return pair;
            }
            return null;
        }
        catch (Exception ex) {
            TryCatchUtil.throwRuntimeException(ex);
            return null;
        }
    }

    public Pair<K, V> first(Function<V, Boolean> func) {
        try {
            for (Pair<K, V> pair : this.pairs) {
                if (!LinqUtils.invokeBoolean(func, pair.value)) continue;
                return pair;
            }
            return null;
        }
        catch (Exception ex) {
            TryCatchUtil.throwRuntimeException(ex);
            return null;
        }
    }

    public V lastValue(BiFunction<K, V, Boolean> func) {
        Pair<K, V> last = this.last(func);
        return last == null ? null : (V)last.value;
    }

    public V lastValue(Function<V, Boolean> func) {
        Pair<K, V> last = this.last(func);
        return last == null ? null : (V)last.value;
    }

    public Pair<K, V> last(BiFunction<K, V, Boolean> func) {
        Pair<K, V> result = null;
        try {
            for (Pair<K, V> pair : this.pairs) {
                if (!LinqUtils.invokeBoolean(func, pair.key, pair.value)) continue;
                result = pair;
            }
            return result;
        }
        catch (Exception ex) {
            TryCatchUtil.throwRuntimeException(ex);
            return null;
        }
    }

    public Pair<K, V> last(Function<V, Boolean> func) {
        Pair<K, V> result = null;
        try {
            for (Pair<K, V> pair : this.pairs) {
                if (!LinqUtils.invokeBoolean(func, pair.value)) continue;
                result = pair;
            }
            return result;
        }
        catch (Exception ex) {
            TryCatchUtil.throwRuntimeException(ex);
            return null;
        }
    }

    public MultiMap<K, V> slice(int from, int to) {
        return new MultiMap<K, V>(LinqUtils.listCopy(this.pairs, from, to));
    }

    public MultiMap<K, V> slice(int from) {
        return new MultiMap<K, V>(LinqUtils.listCopy(this.pairs, from));
    }

    public MultiMap<K, V> sliceTo(int to) {
        return new MultiMap<K, V>(LinqUtils.listCopyUntil(this.pairs, to));
    }

    public void foreach(BiConsumer<K, V> action) {
        try {
            for (Pair<K, V> pair : this.pairs) {
                action.accept(pair.key, pair.value);
            }
        }
        catch (Exception ex) {
            TryCatchUtil.throwRuntimeException(ex);
        }
    }

    public void foreach(Consumer<V> action) {
        try {
            for (Pair<K, V> pair : this.pairs) {
                action.accept(pair.value);
            }
        }
        catch (Exception ex) {
            TryCatchUtil.throwRuntimeException(ex);
        }
    }

    public <R> List<R> selectMany(BiFunction<K, V, List<R>> func) {
        try {
            ArrayList result = new ArrayList();
            for (Pair<K, V> pair : this.pairs) {
                result.addAll(func.apply(pair.key, pair.value));
            }
            return result;
        }
        catch (Exception ex) {
            TryCatchUtil.throwRuntimeException(ex);
            return null;
        }
    }

    public <R> List<R> selectMany(Function<V, List<R>> func) {
        try {
            ArrayList result = new ArrayList();
            for (Pair<K, V> pair : this.pairs) {
                result.addAll(func.apply(pair.value));
            }
            return result;
        }
        catch (Exception ex) {
            TryCatchUtil.throwRuntimeException(ex);
            return null;
        }
    }
}

